/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.simiacryptus.ref.lang.RefAware;
import com.simiacryptus.ref.lang.RefIgnore;
import com.simiacryptus.ref.lang.RefUtil;
import com.simiacryptus.ref.wrappers.RefIterator;
import com.simiacryptus.ref.wrappers.RefMap;
import com.simiacryptus.ref.wrappers.RefSet;
import com.simiacryptus.util.ReflectionUtil;
import java.io.IOException;
import java.util.Map;
import java.util.Set;

public class RefMapSerializer
extends MapSerializer {
    public RefMapSerializer(Set<String> ignoredEntries, JavaType keyType, JavaType valueType, boolean valueTypeIsStatic, TypeSerializer vts, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer) {
        super(ignoredEntries, keyType, valueType, valueTypeIsStatic, vts, keySerializer, valueSerializer);
    }

    public RefMapSerializer(MapSerializer src, BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, Set<String> ignoredEntries) {
        super(src, property, keySerializer, valueSerializer, ignoredEntries);
    }

    public RefMapSerializer(MapSerializer src, TypeSerializer vts, Object suppressableValue, boolean suppressNulls) {
        super(src, vts, suppressableValue, suppressNulls);
    }

    public RefMapSerializer(MapSerializer src, Object filterId, boolean sortKeys) {
        super(src, filterId, sortKeys);
    }

    public static <T> JsonSerializer<T> wrap(JsonSerializer<T> jsonSerializer) {
        if (jsonSerializer instanceof MapSerializer) {
            return RefMapSerializer.wrap((MapSerializer)jsonSerializer);
        }
        return jsonSerializer;
    }

    public static MapSerializer wrap(MapSerializer mapSerializer) {
        if (mapSerializer instanceof RefMapSerializer) {
            return mapSerializer;
        }
        return new RefMapSerializer((Set)ReflectionUtil.getField(mapSerializer, "_ignoredEntries"), (JavaType)ReflectionUtil.getField(mapSerializer, "_keyType"), (JavaType)ReflectionUtil.getField(mapSerializer, "_valueType"), (Boolean)ReflectionUtil.getField(mapSerializer, "_valueTypeIsStatic"), (TypeSerializer)ReflectionUtil.getField(mapSerializer, "_valueTypeSerializer"), (JsonSerializer)ReflectionUtil.getField(mapSerializer, "_keySerializer"), (JsonSerializer)ReflectionUtil.getField(mapSerializer, "_valueSerializer"));
    }

    public MapSerializer _withValueTypeSerializer(TypeSerializer vts) {
        return RefMapSerializer.wrap(super._withValueTypeSerializer(vts));
    }

    public MapSerializer withResolved(BeanProperty property, JsonSerializer<?> keySerializer, JsonSerializer<?> valueSerializer, Set<String> ignored, boolean sortKeys) {
        return RefMapSerializer.wrap(super.withResolved(property, keySerializer, valueSerializer, ignored, sortKeys));
    }

    public MapSerializer withFilterId(Object filterId) {
        return RefMapSerializer.wrap(super.withFilterId(filterId));
    }

    public MapSerializer withContentInclusion(Object suppressableValue, boolean suppressNulls) {
        return RefMapSerializer.wrap(super.withContentInclusion(suppressableValue, suppressNulls));
    }

    public MapSerializer withContentInclusion(Object suppressableValue) {
        return RefMapSerializer.wrap(super.withContentInclusion(suppressableValue));
    }

    public void serializeFields(Map<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (value instanceof RefMap) {
            this.serializeFields((RefMap)value, gen, provider);
        } else {
            super.serializeFields(value, gen, provider);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeTypedFields(RefMap<?, ?> value, JsonGenerator gen, SerializerProvider provider, Object suppressableValue) throws IOException {
        Set ignored = this._ignoredEntries;
        boolean checkEmpty = MARKER_FOR_EMPTY == suppressableValue;
        RefSet entries = value.entrySet();
        RefIterator entryIterator = entries.iterator();
        try {
            while (entryIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)entryIterator.next();
                Object keyElem = entry.getKey();
                Object valueElem = entry.getValue();
                try {
                    JsonSerializer<Object> valueSer;
                    JsonSerializer keySerializer;
                    if (keyElem == null) {
                        keySerializer = provider.findNullKeySerializer(this._keyType, this._property);
                    } else {
                        if (ignored != null && ignored.contains(keyElem)) continue;
                        keySerializer = this._keySerializer;
                    }
                    if (valueElem == null) {
                        if (this._suppressNulls) continue;
                        valueSer = provider.getDefaultNullValueSerializer();
                    } else {
                        valueSer = this._valueSerializer;
                        if (valueSer == null) {
                            valueSer = this._findSerializer(provider, valueElem);
                        }
                        if (checkEmpty ? valueSer.isEmpty(provider, valueElem) : suppressableValue != null && suppressableValue.equals(valueElem)) continue;
                    }
                    keySerializer.serialize(keyElem, gen, provider);
                    valueSer.serializeWithType(valueElem, gen, provider, this._valueTypeSerializer);
                }
                catch (Exception e) {
                    this.wrapAndThrow(provider, e, value.addRef(), String.valueOf(keyElem));
                }
                finally {
                    RefUtil.freeRef((Object)entry);
                    RefUtil.freeRef(valueElem);
                    RefUtil.freeRef(keyElem);
                }
            }
        }
        finally {
            value.freeRef();
            entryIterator.freeRef();
            entries.freeRef();
        }
    }

    @RefIgnore
    public void wrapAndThrow(SerializerProvider provider, Throwable t, @RefAware Object bean, String fieldName) throws IOException {
        super.wrapAndThrow(provider, t, bean, fieldName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeFields(RefMap<?, ?> value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        if (this._valueTypeSerializer != null) {
            this.serializeTypedFields(value, gen, provider, null);
            return;
        }
        JsonSerializer keySerializer = this._keySerializer;
        Set ignored = this._ignoredEntries;
        RefSet entries = value.entrySet();
        RefIterator entryIterator = entries.iterator();
        try {
            while (entryIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)entryIterator.next();
                Object valueElem = entry.getValue();
                Object keyElem = entry.getKey();
                try {
                    if (keyElem == null) {
                        provider.findNullKeySerializer(this._keyType, this._property).serialize(null, gen, provider);
                    } else {
                        if (ignored != null && ignored.contains(keyElem)) continue;
                        keySerializer.serialize(keyElem, gen, provider);
                    }
                    if (valueElem == null) {
                        provider.defaultSerializeNull(gen);
                        continue;
                    }
                    JsonSerializer<Object> serializer = this._valueSerializer;
                    if (serializer == null) {
                        serializer = this._findSerializer(provider, valueElem);
                    }
                    serializer.serialize(valueElem, gen, provider);
                }
                catch (Exception e) {
                    this.wrapAndThrow(provider, e, value.addRef(), String.valueOf(keyElem));
                }
                finally {
                    RefUtil.freeRef((Object)entry);
                    RefUtil.freeRef(valueElem);
                    RefUtil.freeRef(keyElem);
                }
            }
        }
        finally {
            value.freeRef();
            entryIterator.freeRef();
            entries.freeRef();
        }
    }

    protected void _ensureOverride(String method) {
    }

    private final JsonSerializer<Object> _findSerializer(SerializerProvider provider, Object value) throws JsonMappingException {
        Class<?> cc = value.getClass();
        JsonSerializer valueSer = this._dynamicValueSerializers.serializerFor(cc);
        if (valueSer != null) {
            return valueSer;
        }
        if (this._valueType.hasGenericTypes()) {
            return this._findAndAddDynamic(this._dynamicValueSerializers, provider.constructSpecializedType(this._valueType, cc), provider);
        }
        return this._findAndAddDynamic(this._dynamicValueSerializers, cc, provider);
    }
}

