/*
 * Decompiled with CFR 0.152.
 */
package com.simiacryptus.util.io;

import com.simiacryptus.ref.wrappers.RefArrays;
import com.simiacryptus.util.Util;
import com.simiacryptus.util.io.FairAsyncWorkQueue;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;

public class AsyncOutputStream
extends FilterOutputStream {
    private final FairAsyncWorkQueue queue = new FairAsyncWorkQueue();

    public AsyncOutputStream(@Nonnull OutputStream stream) {
        super(stream);
    }

    @Override
    public synchronized void close() {
        this.queue.submit(() -> {
            try {
                this.out.close();
            }
            catch (IOException e) {
                throw Util.throwException(e);
            }
        });
    }

    @Override
    public synchronized void flush() {
        this.queue.submit(() -> {
            try {
                this.out.flush();
            }
            catch (IOException e) {
                throw Util.throwException(e);
            }
        });
    }

    @Override
    public synchronized void write(@Nonnull byte[] b, int off, int len) {
        @Nonnull byte[] _b = RefArrays.copyOfRange((byte[])b, (int)off, (int)Math.min(b.length, off + len));
        this.queue.submit(() -> {
            try {
                this.out.write(_b);
            }
            catch (IOException e) {
                throw Util.throwException(e);
            }
        });
    }

    @Override
    public synchronized void write(int b) {
        this.queue.submit(() -> {
            try {
                this.out.write(b);
            }
            catch (IOException e) {
                throw Util.throwException(e);
            }
        });
    }
}

