/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs;

import com.sinacloud.scs.ClientConfiguration;
import com.sinacloud.scs.Request;
import com.sinacloud.scs.http.ExecutionContext;
import com.sinacloud.scs.http.HttpConnect;
import com.sinacloud.scs.http.HttpMethodName;
import com.sinacloud.scs.http.HttpRequest;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SCSWebServiceClient {
    protected URI endpoint;
    protected URI endpoint4Upload;
    protected ClientConfiguration clientConfiguration;
    protected HttpConnect client;
    protected int timeOffset;

    public SCSWebServiceClient(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new HttpConnect(clientConfiguration);
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.endpoint = this.configEndpoint(endpoint);
    }

    public void setEndpoint4Upload(String endpoint) throws IllegalArgumentException {
        this.endpoint4Upload = this.configEndpoint(endpoint);
    }

    private URI configEndpoint(String endpoint) throws IllegalArgumentException {
        if (!endpoint.contains("://")) {
            endpoint = this.clientConfiguration.getProtocol().toString() + "://" + endpoint;
        }
        try {
            return new URI(endpoint);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setConfiguration(ClientConfiguration clientConfiguration) {
        this.clientConfiguration = clientConfiguration;
        this.client = new HttpConnect(clientConfiguration);
    }

    public void shutdown() {
        this.client.shutdown();
    }

    @Deprecated
    protected <T> HttpRequest convertToHttpRequest(Request<T> request, HttpMethodName methodName) {
        HttpRequest httpRequest = new HttpRequest(methodName);
        for (Map.Entry<String, String> parameter : request.getParameters().entrySet()) {
            httpRequest.addParameter(parameter.getKey(), parameter.getValue());
        }
        for (Map.Entry<String, String> parameter : request.getHeaders().entrySet()) {
            httpRequest.addHeader(parameter.getKey(), parameter.getValue());
        }
        httpRequest.setServiceName(request.getServiceName());
        httpRequest.setEndpoint(request.getEndpoint());
        httpRequest.setResourcePath(request.getResourcePath());
        httpRequest.setOriginalRequest(request.getOriginalRequest());
        return httpRequest;
    }

    protected final ExecutionContext createExecutionContext(Request<?> req) {
        return this.createExecutionContext();
    }

    protected final ExecutionContext createExecutionContext() {
        return new ExecutionContext();
    }

    private static boolean isProfilingEnabled() {
        return System.getProperty("com.amazonaws.sdk.enableRuntimeProfiling") != null;
    }

    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    public SCSWebServiceClient withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    public int getTimeOffset() {
        return this.timeOffset;
    }
}

