/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.http;

import com.sinacloud.scs.ClientConfiguration;
import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.http.ConnectionManagerFactory;
import com.sinacloud.scs.http.impl.client.SdkHttpClient;
import com.sinacloud.scs.http.impl.client.SdkHttpRequestRetryHandler;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeLayeredSocketFactory;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SchemeSocketFactory;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.conn.PoolingClientConnectionManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;

class HttpClientFactory {
    HttpClientFactory() {
    }

    public HttpClient createHttpClient(ClientConfiguration config) {
        BasicHttpParams httpClientParams = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout((HttpParams)httpClientParams, (int)config.getConnectionTimeout());
        HttpConnectionParams.setSoTimeout((HttpParams)httpClientParams, (int)config.getSocketTimeout());
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)httpClientParams, (boolean)true);
        HttpConnectionParams.setTcpNoDelay((HttpParams)httpClientParams, (boolean)true);
        int socketSendBufferSizeHint = config.getSocketBufferSizeHints()[0];
        int socketReceiveBufferSizeHint = config.getSocketBufferSizeHints()[1];
        if (socketSendBufferSizeHint > 0 || socketReceiveBufferSizeHint > 0) {
            HttpConnectionParams.setSocketBufferSize((HttpParams)httpClientParams, (int)Math.max(socketSendBufferSizeHint, socketReceiveBufferSizeHint));
        }
        PoolingClientConnectionManager connectionManager = ConnectionManagerFactory.createPoolingClientConnManager(config, (HttpParams)httpClientParams);
        SdkHttpClient httpClient = new SdkHttpClient((ClientConnectionManager)connectionManager, (HttpParams)httpClientParams);
        if (config.getMaxErrorRetry() > 0) {
            httpClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)SdkHttpRequestRetryHandler.Singleton);
        }
        try {
            Scheme http = new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80);
            SSLSocketFactory sf = new SSLSocketFactory(SSLContext.getDefault(), SSLSocketFactory.STRICT_HOSTNAME_VERIFIER);
            Scheme https = new Scheme("https", (SocketFactory)sf, 443);
            SchemeRegistry sr = connectionManager.getSchemeRegistry();
            sr.register(http);
            sr.register(https);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SCSClientException("Unable to access default SSL context", e);
        }
        Scheme sch = new Scheme("https", 443, (SchemeSocketFactory)new TrustingSocketFactory());
        httpClient.getConnectionManager().getSchemeRegistry().register(sch);
        String proxyHost = config.getProxyHost();
        int proxyPort = config.getProxyPort();
        if (proxyHost != null && proxyPort > 0) {
            HttpHost proxyHttpHost = new HttpHost(proxyHost, proxyPort);
            httpClient.getParams().setParameter("http.route.default-proxy", (Object)proxyHttpHost);
            String proxyUsername = config.getProxyUsername();
            String proxyPassword = config.getProxyPassword();
            String proxyDomain = config.getProxyDomain();
            String proxyWorkstation = config.getProxyWorkstation();
            if (proxyUsername != null && proxyPassword != null) {
                httpClient.getCredentialsProvider().setCredentials(new AuthScope(proxyHost, proxyPort), (Credentials)new NTCredentials(proxyUsername, proxyPassword, proxyWorkstation, proxyDomain));
            }
        }
        return httpClient;
    }

    private static class TrustingX509TrustManager
    implements X509TrustManager {
        private static final X509Certificate[] X509_CERTIFICATES = new X509Certificate[0];

        private TrustingX509TrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return X509_CERTIFICATES;
        }

        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }

        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        }
    }

    private static class TrustingSocketFactory
    implements SchemeSocketFactory,
    SchemeLayeredSocketFactory {
        private SSLContext sslcontext = null;

        private TrustingSocketFactory() {
        }

        private static SSLContext createSSLContext() throws IOException {
            try {
                SSLContext context = SSLContext.getInstance("TLS");
                context.init(null, new TrustManager[]{new TrustingX509TrustManager()}, null);
                return context;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage(), e);
            }
        }

        private SSLContext getSSLContext() throws IOException {
            if (this.sslcontext == null) {
                this.sslcontext = TrustingSocketFactory.createSSLContext();
            }
            return this.sslcontext;
        }

        public Socket createSocket(HttpParams params) throws IOException {
            return this.getSSLContext().getSocketFactory().createSocket();
        }

        public Socket connectSocket(Socket sock, InetSocketAddress remoteAddress, InetSocketAddress localAddress, HttpParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
            int connTimeout = HttpConnectionParams.getConnectionTimeout((HttpParams)params);
            int soTimeout = HttpConnectionParams.getSoTimeout((HttpParams)params);
            SSLSocket sslsock = (SSLSocket)(sock != null ? sock : this.createSocket(params));
            if (localAddress != null) {
                sslsock.bind(localAddress);
            }
            sslsock.connect(remoteAddress, connTimeout);
            sslsock.setSoTimeout(soTimeout);
            return sslsock;
        }

        public boolean isSecure(Socket sock) throws IllegalArgumentException {
            return true;
        }

        public Socket createLayeredSocket(Socket arg0, String arg1, int arg2, HttpParams arg3) throws IOException, UnknownHostException {
            return this.getSSLContext().getSocketFactory().createSocket(arg0, arg1, arg2, true);
        }
    }

    private static final class LocationHeaderNotRequiredRedirectStrategy
    extends DefaultRedirectStrategy {
        private LocationHeaderNotRequiredRedirectStrategy() {
        }

        public boolean isRedirected(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
            int statusCode = response.getStatusLine().getStatusCode();
            Header locationHeader = response.getFirstHeader("location");
            if (locationHeader == null && statusCode == 301) {
                return false;
            }
            return super.isRedirected(request, response, context);
        }
    }
}

