/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.http;

import com.sinacloud.scs.ClientConfiguration;
import com.sinacloud.scs.Request;
import com.sinacloud.scs.RequestClientOptions;
import com.sinacloud.scs.Response;
import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.SCSServiceException;
import com.sinacloud.scs.SCSWebServiceRequest;
import com.sinacloud.scs.SCSWebServiceResponse;
import com.sinacloud.scs.SDKGlobalConfiguration;
import com.sinacloud.scs.http.ExecutionContext;
import com.sinacloud.scs.http.HttpClientFactory;
import com.sinacloud.scs.http.HttpMethodReleaseInputStream;
import com.sinacloud.scs.http.HttpRequestFactory;
import com.sinacloud.scs.http.HttpResponse;
import com.sinacloud.scs.http.HttpResponseHandler;
import com.sinacloud.scs.http.IdleConnectionReaper;
import com.sinacloud.scs.retry.RetryPolicy;
import com.sinacloud.scs.retry.RetryUtils;
import com.sinacloud.scs.util.DateUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpConnect {
    private static final String HEADER_USER_AGENT = "User-Agent";
    private HttpClient httpClient;
    ClientConfiguration config;
    static final Log log = LogFactory.getLog((String)"com.sina.cloudstorage.request");
    HttpRequestBase httpRequest;
    private static final HttpRequestFactory httpRequestFactory = new HttpRequestFactory();
    private static final HttpClientFactory httpClientFactory = new HttpClientFactory();

    public HttpConnect(ClientConfiguration config) {
        this.config = config;
        this.httpClient = httpClientFactory.createHttpClient(config);
    }

    public <T> Response<T> execute(Request<?> request, HttpResponseHandler<SCSWebServiceResponse<T>> responseHandler, HttpResponseHandler<SCSServiceException> errorResponseHandler, ExecutionContext executionContext) throws SCSClientException, SCSServiceException {
        if (executionContext == null) {
            throw new SCSClientException("Internal SDK Error: No execution context parameter specified.");
        }
        Response<T> response = null;
        response = this.executeHelper(request, responseHandler, errorResponseHandler, executionContext);
        return response;
    }

    private <T> Response<T> executeHelper(Request<?> request, HttpResponseHandler<SCSWebServiceResponse<T>> responseHandler, HttpResponseHandler<SCSServiceException> errorResponseHandler, ExecutionContext executionContext) throws SCSClientException, SCSServiceException {
        boolean leaveHttpConnectionOpen = false;
        this.setUserAgent(request);
        int requestCount = 0;
        URI redirectedURI = null;
        HttpEntity entity = null;
        SCSClientException retriedException = null;
        HashMap<String, String> originalParameters = new HashMap<String, String>();
        originalParameters.putAll(request.getParameters());
        HashMap<String, String> originalHeaders = new HashMap<String, String>();
        originalHeaders.putAll(request.getHeaders());
        while (true) {
            if (++requestCount > 1) {
                request.setParameters(originalParameters);
                request.setHeaders(originalHeaders);
            }
            HttpRequestBase httpRequest = null;
            org.apache.http.HttpResponse apacheResponse = null;
            try {
                if (executionContext.getSigner() != null && executionContext.getCredentials() != null) {
                    executionContext.getSigner().sign(request, executionContext.getCredentials());
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Sending Request: " + request.toString()));
                }
                if ((httpRequest = httpRequestFactory.createHttpRequest(request, this.config, entity, executionContext)) instanceof HttpEntityEnclosingRequest) {
                    entity = ((HttpEntityEnclosingRequest)httpRequest).getEntity();
                }
                if (redirectedURI != null) {
                    httpRequest.setURI(redirectedURI);
                }
                if (requestCount > 1) {
                    this.pauseBeforeNextRetry(request.getOriginalRequest(), retriedException, requestCount, this.config.getRetryPolicy());
                }
                if (entity != null) {
                    InputStream content = entity.getContent();
                    if (requestCount > 1) {
                        if (content.markSupported()) {
                            content.reset();
                            content.mark(-1);
                        }
                    } else if (content.markSupported()) {
                        content.mark(-1);
                    }
                }
                BasicHttpContext httpContext = new BasicHttpContext();
                retriedException = null;
                apacheResponse = this.httpClient.execute((HttpUriRequest)httpRequest, (HttpContext)httpContext);
                if (this.isRequestSuccessful(apacheResponse)) {
                    leaveHttpConnectionOpen = responseHandler.needsConnectionLeftOpen();
                    HttpResponse httpResponse = this.createResponse(httpRequest, request, apacheResponse);
                    T response = this.handleResponse(request, responseHandler, httpRequest, httpResponse, apacheResponse, executionContext);
                    Response<T> response2 = new Response<T>(response, httpResponse);
                    return response2;
                }
                if (HttpConnect.isTemporaryRedirect(apacheResponse)) {
                    Header[] locationHeaders = apacheResponse.getHeaders("location");
                    String redirectedLocation = locationHeaders[0].getValue();
                    log.debug((Object)("Redirecting to: " + redirectedLocation));
                    redirectedURI = URI.create(redirectedLocation);
                    httpRequest.setURI(redirectedURI);
                    continue;
                }
                leaveHttpConnectionOpen = errorResponseHandler.needsConnectionLeftOpen();
                SCSServiceException ase = this.handleErrorResponse(request, errorResponseHandler, httpRequest, apacheResponse);
                if (!this.shouldRetry(request.getOriginalRequest(), httpRequest, ase, requestCount, this.config.getRetryPolicy())) {
                    throw ase;
                }
                retriedException = ase;
                if (RetryUtils.isClockSkewError(ase)) {
                    int timeOffset = this.parseClockSkewOffset(apacheResponse, ase);
                    SDKGlobalConfiguration.setGlobalTimeOffset(timeOffset);
                }
                this.resetRequestAfterError(request, ase);
                continue;
            }
            catch (IOException ioe) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("Unable to execute HTTP request: " + ioe.getMessage()), (Throwable)ioe);
                }
                SCSClientException ace = new SCSClientException("Unable to execute HTTP request: " + ioe.getMessage(), ioe);
                if (!this.shouldRetry(request.getOriginalRequest(), httpRequest, ace, requestCount, this.config.getRetryPolicy())) {
                    throw ace;
                }
                retriedException = ace;
                this.resetRequestAfterError(request, ioe);
                continue;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            finally {
                if (leaveHttpConnectionOpen) continue;
                try {
                    if (apacheResponse == null || apacheResponse.getEntity() == null || apacheResponse.getEntity().getContent() == null) continue;
                    apacheResponse.getEntity().getContent().close();
                }
                catch (IOException e) {
                    log.warn((Object)"Cannot close the response content.", (Throwable)e);
                }
                continue;
            }
            break;
        }
    }

    private void setUserAgent(Request<?> request) {
        String userAgentMarker;
        RequestClientOptions opts;
        SCSWebServiceRequest awsreq;
        String userAgent = this.config.getUserAgent();
        if (!userAgent.equals(ClientConfiguration.DEFAULT_USER_AGENT)) {
            userAgent = userAgent + ", " + ClientConfiguration.DEFAULT_USER_AGENT;
        }
        if (userAgent != null) {
            request.addHeader(HEADER_USER_AGENT, userAgent);
        }
        if ((awsreq = request.getOriginalRequest()) != null && (opts = awsreq.getRequestClientOptions()) != null && (userAgentMarker = opts.getClientMarker(RequestClientOptions.Marker.USER_AGENT)) != null) {
            request.addHeader(HEADER_USER_AGENT, HttpConnect.createUserAgentString(userAgent, userAgentMarker));
        }
    }

    private static String createUserAgentString(String existingUserAgentString, String userAgent) {
        if (existingUserAgentString.contains(userAgent)) {
            return existingUserAgentString;
        }
        return existingUserAgentString.trim() + " " + userAgent.trim();
    }

    private void pauseBeforeNextRetry(SCSWebServiceRequest originalRequest, SCSClientException previousException, int requestCount, RetryPolicy retryPolicy) {
        int retries = requestCount - 1 - 1;
        long delay = retryPolicy.getBackoffStrategy().delayBeforeNextRetry(originalRequest, previousException, retries);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retriable error detected, will retry in " + delay + "ms, attempt number: " + retries));
        }
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SCSClientException(e.getMessage(), e);
        }
    }

    private boolean isRequestSuccessful(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status / 100 == 2;
    }

    private HttpResponse createResponse(HttpRequestBase method, Request<?> request, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        HttpResponse httpResponse = new HttpResponse(request, method);
        if (apacheHttpResponse.getEntity() != null) {
            httpResponse.setContent(apacheHttpResponse.getEntity().getContent());
        }
        httpResponse.setStatusCode(apacheHttpResponse.getStatusLine().getStatusCode());
        httpResponse.setStatusText(apacheHttpResponse.getStatusLine().getReasonPhrase());
        for (Header header : apacheHttpResponse.getAllHeaders()) {
            httpResponse.addHeader(header.getName(), header.getValue());
        }
        return httpResponse;
    }

    private <T> T handleResponse(Request<?> request, HttpResponseHandler<SCSWebServiceResponse<T>> responseHandler, HttpRequestBase method, HttpResponse httpResponse, org.apache.http.HttpResponse apacheHttpResponse, ExecutionContext executionContext) throws IOException {
        if (responseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequest) {
            HttpEntityEnclosingRequest httpEntityEnclosingRequest = (HttpEntityEnclosingRequest)method;
            httpResponse.setContent(new HttpMethodReleaseInputStream(httpEntityEnclosingRequest));
        }
        try {
            SCSWebServiceResponse<T> awsResponse = responseHandler.handle(httpResponse);
            if (awsResponse == null) {
                throw new RuntimeException("Unable to unmarshall response metadata");
            }
            return awsResponse.getResult();
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = "Unable to unmarshall response (" + e.getMessage() + ")";
            throw new SCSClientException(errorMessage, e);
        }
    }

    private static boolean isTemporaryRedirect(org.apache.http.HttpResponse response) {
        int status = response.getStatusLine().getStatusCode();
        return status == 307 && response.getHeaders("Location") != null && response.getHeaders("Location").length > 0;
    }

    private SCSServiceException handleErrorResponse(Request<?> request, HttpResponseHandler<SCSServiceException> errorResponseHandler, HttpRequestBase method, org.apache.http.HttpResponse apacheHttpResponse) throws IOException {
        int status = apacheHttpResponse.getStatusLine().getStatusCode();
        HttpResponse response = this.createResponse(method, request, apacheHttpResponse);
        if (errorResponseHandler.needsConnectionLeftOpen() && method instanceof HttpEntityEnclosingRequestBase) {
            HttpEntityEnclosingRequestBase entityEnclosingRequest = (HttpEntityEnclosingRequestBase)method;
            response.setContent(new HttpMethodReleaseInputStream((HttpEntityEnclosingRequest)entityEnclosingRequest));
        }
        SCSServiceException exception = null;
        try {
            exception = errorResponseHandler.handle(response);
        }
        catch (Exception e) {
            if (status == 413) {
                exception = new SCSServiceException("Request entity too large");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(413);
                exception.setErrorType(SCSServiceException.ErrorType.Client);
                exception.setErrorCode("Request entity too large");
            }
            if (status == 503 && "Service Unavailable".equalsIgnoreCase(apacheHttpResponse.getStatusLine().getReasonPhrase())) {
                exception = new SCSServiceException("Service unavailable");
                exception.setServiceName(request.getServiceName());
                exception.setStatusCode(503);
                exception.setErrorType(SCSServiceException.ErrorType.Service);
                exception.setErrorCode("Service unavailable");
            }
            String errorMessage = "Unable to unmarshall error response (" + e.getMessage() + ")";
            throw new SCSClientException(errorMessage, e);
        }
        exception.setStatusCode(status);
        exception.setServiceName(request.getServiceName());
        exception.fillInStackTrace();
        return exception;
    }

    private boolean shouldRetry(SCSWebServiceRequest originalRequest, HttpRequestBase method, SCSClientException exception, int requestCount, RetryPolicy retryPolicy) {
        HttpEntity entity;
        int retries = requestCount - 1;
        int maxErrorRetry = this.config.getMaxErrorRetry();
        if (maxErrorRetry < 0 || !retryPolicy.isMaxErrorRetryInClientConfigHonored()) {
            maxErrorRetry = retryPolicy.getMaxErrorRetry();
        }
        if (retries >= maxErrorRetry) {
            return false;
        }
        if (method instanceof HttpEntityEnclosingRequest && (entity = ((HttpEntityEnclosingRequest)method).getEntity()) != null && !entity.isRepeatable()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Entity not repeatable");
            }
            return false;
        }
        return retryPolicy.getRetryCondition().shouldRetry(originalRequest, exception, retries);
    }

    private String getServerDateFromException(String body) {
        int startPos = body.indexOf("(");
        int endPos = 0;
        endPos = body.contains(" + 15") ? body.indexOf(" + 15") : body.indexOf(" - 15");
        String msg = body.substring(startPos + 1, endPos);
        return msg;
    }

    private int parseClockSkewOffset(org.apache.http.HttpResponse response, SCSServiceException exception) {
        DateUtils dateUtils = new DateUtils();
        Date deviceDate = new Date();
        Date serverDate = null;
        String serverDateStr = null;
        Header[] responseDateHeader = response.getHeaders("Date");
        try {
            if (responseDateHeader.length == 0) {
                serverDateStr = this.getServerDateFromException(exception.getMessage());
                serverDate = dateUtils.parseCompressedIso8601Date(serverDateStr);
            } else {
                serverDateStr = responseDateHeader[0].getValue();
                serverDate = dateUtils.parseRfc822Date(serverDateStr);
            }
        }
        catch (ParseException e) {
            log.warn((Object)("Unable to parse clock skew offset from response: " + serverDateStr), (Throwable)e);
            return 0;
        }
        catch (RuntimeException e) {
            log.warn((Object)("Unable to parse clock skew offset from response: " + serverDateStr), (Throwable)e);
            return 0;
        }
        long diff = deviceDate.getTime() - serverDate.getTime();
        return (int)(diff / 1000L);
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public void shutdown() {
        IdleConnectionReaper.removeConnectionManager(this.httpClient.getConnectionManager());
        this.httpClient.getConnectionManager().shutdown();
    }

    private void resetRequestAfterError(Request<?> request, Exception cause) throws SCSClientException {
        if (request.getContent() == null) {
            return;
        }
        if (!request.getContent().markSupported()) {
            throw new SCSClientException("Encountered an exception and stream is not resettable", cause);
        }
        try {
            request.getContent().reset();
        }
        catch (IOException e) {
            throw new SCSClientException("Encountered an exception and couldn't reset the stream to retry", cause);
        }
    }
}

