/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.internal;

import com.sinacloud.scs.Request;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestUtils {
    private static final List<String> SIGNED_PARAMETERS = Arrays.asList("acl", "torrent", "logging", "location", "policy", "requestPayment", "versioning", "versions", "versionId", "notification", "uploadId", "uploads", "partNumber", "website", "delete", "lifecycle", "tagging", "cors", "restore", "relax", "meta", "multipart", "part", "copy", "response-cache-control", "response-content-disposition", "response-content-encoding", "response-content-language", "response-content-type", "response-expires");

    public static <T> String makeS3CanonicalString(String method, String resource, Request<T> request, String expires) {
        StringBuilder buf = new StringBuilder();
        buf.append(method + "\n");
        Map<String, String> headersMap = request.getHeaders();
        TreeMap<String, String> interestingHeaders = new TreeMap<String, String>();
        if (headersMap != null && headersMap.size() > 0) {
            for (Map.Entry<String, String> entry : headersMap.entrySet()) {
                String lk;
                String string = entry.getKey();
                String value = entry.getValue();
                if (string == null || !(lk = string.toString().toLowerCase(Locale.getDefault())).equals("content-type") && !lk.equals("date") && !lk.equals("s-sina-sha1") && !lk.equals("content-md5") && !lk.startsWith("x-amz-") && !lk.startsWith("x-sina-")) continue;
                interestingHeaders.put(lk, value);
            }
        }
        if (interestingHeaders.containsKey("x-amz-date")) {
            interestingHeaders.put("date", "");
        }
        if (expires != null) {
            interestingHeaders.put("date", expires);
        }
        if (!interestingHeaders.containsKey("content-type")) {
            interestingHeaders.put("content-type", "");
        }
        String s_sina_sha1 = "";
        if (interestingHeaders.containsKey("s-sina-sha1")) {
            s_sina_sha1 = (String)interestingHeaders.get("s-sina-sha1");
            interestingHeaders.remove("s-sina-sha1");
        } else if (interestingHeaders.containsKey("content-md5")) {
            s_sina_sha1 = (String)interestingHeaders.get("content-md5");
            interestingHeaders.remove("content-md5");
        }
        buf.append(s_sina_sha1 + "\n");
        for (Map.Entry<String, String> entry : request.getParameters().entrySet()) {
            if (!entry.getKey().startsWith("x-amz-") && !entry.getKey().startsWith("x-sina-")) continue;
            interestingHeaders.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : interestingHeaders.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (key.startsWith("x-amz-") || key.startsWith("x-sina-")) {
                buf.append(key).append(':').append(value);
            } else {
                buf.append(value);
            }
            buf.append("\n");
        }
        buf.append(resource);
        Object[] objectArray = request.getParameters().keySet().toArray(new String[request.getParameters().size()]);
        Arrays.sort(objectArray);
        int n = 63;
        for (Object parameterName : objectArray) {
            int n2;
            if (!SIGNED_PARAMETERS.contains(parameterName)) continue;
            buf.append((char)n2);
            buf.append((String)parameterName);
            String parameterValue = request.getParameters().get(parameterName);
            if (parameterValue != null) {
                buf.append("=").append(parameterValue);
            }
            n2 = 38;
        }
        return buf.toString();
    }
}

