/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.internal;

import com.sinacloud.scs.Request;
import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.auth.AWSCredentials;
import com.sinacloud.scs.auth.AWSSessionCredentials;
import com.sinacloud.scs.auth.AbstractAWSSigner;
import com.sinacloud.scs.auth.SigningAlgorithm;
import com.sinacloud.scs.services.scs.internal.RestUtils;
import com.sinacloud.scs.services.scs.internal.ServiceUtils;
import com.sinacloud.scs.util.HttpUtils;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3Signer
extends AbstractAWSSigner {
    private static final Log log = LogFactory.getLog(S3Signer.class);
    private final String httpVerb;
    private final String resourcePath;

    public S3Signer(String httpVerb, String resourcePath) {
        this.httpVerb = httpVerb;
        this.resourcePath = resourcePath;
        if (resourcePath == null) {
            throw new IllegalArgumentException("Parameter resourcePath is empty");
        }
    }

    @Override
    public void sign(Request<?> request, AWSCredentials credentials) throws SCSClientException {
        if (credentials == null || credentials.getAWSSecretKey() == null) {
            log.debug((Object)"Canonical string will not be signed, as no AWS Secret Key was provided");
            return;
        }
        AWSCredentials sanitizedCredentials = this.sanitizeCredentials(credentials);
        if (sanitizedCredentials instanceof AWSSessionCredentials) {
            this.addSessionCredentials(request, (AWSSessionCredentials)sanitizedCredentials);
        }
        String encodedResourcePath = HttpUtils.appendUri(request.getEndpoint().getPath(), this.resourcePath, true);
        int timeOffset = this.getTimeOffset(request);
        Date date = this.getSignatureDate(timeOffset);
        request.addHeader("Date", ServiceUtils.formatRfc822Date(date));
        String canonicalString = RestUtils.makeS3CanonicalString(this.httpVerb, encodedResourcePath, request, null);
        log.debug((Object)("Calculated string to sign:\n" + canonicalString));
        String signature = super.signAndBase64Encode(canonicalString, sanitizedCredentials.getAWSSecretKey(), SigningAlgorithm.HmacSHA1);
        if (signature.length() >= 15) {
            signature = signature.substring(5, 15);
        }
        request.addHeader("Authorization", "SINA " + sanitizedCredentials.getAWSAccessKeyId() + ":" + signature);
    }

    @Override
    protected void addSessionCredentials(Request<?> request, AWSSessionCredentials credentials) {
        request.addHeader("x-amz-security-token", credentials.getSessionToken());
    }
}

