/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.util;

import com.sinacloud.scs.util.ClassLoaderHelper;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class VersionInfoUtils {
    static final String VERSION_INFO_FILE = "/com/sina/cloudstorage/sdk/versionInfo.properties";
    private static String version = null;
    private static String platform = null;
    private static String userAgent = null;
    private static Log log = LogFactory.getLog(VersionInfoUtils.class);

    public static String getVersion() {
        if (version == null) {
            VersionInfoUtils.initializeVersion();
        }
        return version;
    }

    public static String getPlatform() {
        if (platform == null) {
            VersionInfoUtils.initializeVersion();
        }
        return platform;
    }

    public static String getUserAgent() {
        if (userAgent == null) {
            VersionInfoUtils.initializeUserAgent();
        }
        return userAgent;
    }

    private static void initializeVersion() {
        InputStream inputStream = ClassLoaderHelper.getResourceAsStream(VERSION_INFO_FILE, true, VersionInfoUtils.class);
        Properties versionInfoProperties = new Properties();
        try {
            if (inputStream == null) {
                throw new Exception("/com/sina/cloudstorage/sdk/versionInfo.properties not found on classpath");
            }
            versionInfoProperties.load(inputStream);
            version = versionInfoProperties.getProperty("version");
            platform = versionInfoProperties.getProperty("platform");
        }
        catch (Exception e) {
            log.info((Object)("Unable to load version information for the running SDK: " + e.getMessage()));
            version = "unknown-version";
            platform = "java";
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
    }

    private static void initializeUserAgent() {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append("scs-sdk-");
        buffer.append(VersionInfoUtils.getPlatform().toLowerCase());
        buffer.append("/");
        buffer.append(VersionInfoUtils.getVersion());
        buffer.append(" ");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.name")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("os.version")));
        buffer.append(" ");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.name")));
        buffer.append("/");
        buffer.append(VersionInfoUtils.replaceSpaces(System.getProperty("java.vm.version")));
        String language = System.getProperty("user.language");
        String region = System.getProperty("user.region");
        if (language != null && region != null) {
            buffer.append(" ");
            buffer.append(VersionInfoUtils.replaceSpaces(language));
            buffer.append("_");
            buffer.append(VersionInfoUtils.replaceSpaces(region));
        }
        userAgent = buffer.toString();
    }

    private static String replaceSpaces(String input) {
        return input.replace(' ', '_');
    }
}

