/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.storage;

import com.sinacloud.storage.Storage;
import com.sinacloud.storage.StorageBase;
import com.sinacloud.storage.StorageUtils;
import com.sinacloud.storage.model.Bucket;
import com.sinacloud.storage.model.BucketList;
import com.sinacloud.storage.model.BucketResponseProcesser;
import com.sinacloud.storage.model.ObjectFile;
import com.sinacloud.storage.model.ObjectFileList;
import com.sinacloud.storage.model.ObjectResponseProcesser;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageClient
extends StorageBase
implements Storage {
    private static final String ERROR_MSG_101 = "the value of parameter  can not be empty!";
    private static final int ERROR_NUM_101 = -101;
    private static final String ERROR_MSG_102 = "URL exception";
    private static final int ERROR_NUM_102 = -102;
    private static final String ERROR_MSG_103 = "IOException";
    private static final int ERROR_NUM_103 = -103;
    private static final String ERROR_MSG_104 = "file does not exist";
    private static final int ERROR_NUM_104 = -104;
    private static final String ERROR_MSG_0 = "success!";
    private static final int ERROR_NUM_0 = 0;
    private static final String ERROR_MSG_201 = "the bucket has created";
    private static final int ERROR_NUM_201 = -201;
    private static final String ERROR_MSG_202 = "the bucket not found or has remove";
    private static final int ERROR_NUM_202 = -202;
    private static final String ERROR_MSG_203 = "the bucket is not null";
    private static final int ERROR_NUM_203 = -203;
    private static final String ERROR_MSG_204 = "reach the upper limit of creating buckets";
    private static final int ERROR_NUM_204 = -204;
    private static final String ERROR_MSG_301 = "object file does not exist in the bucket or has removed";
    private static final int ERROR_NUM_301 = -301;
    private static Logger logger = Logger.getLogger((String)StorageClient.class.getName());

    public StorageClient() {
        this.appName = System.getenv("APPNAME");
        this.accessKey = System.getenv("ACCESSKEY");
        this.secretKey = System.getenv("SECRETKEY");
        if (this.secretKey == null || "".equals(this.secretKey)) {
            throw new RuntimeException("secretkey is null,please invoke public StorageClient(String appName,String accessKey,String secertKey) method");
        }
        if (this.appName == null || "".equals(this.appName)) {
            throw new RuntimeException("appname is null,please invoke public StorageClient(String appName,String accessKey,String secertKey) method");
        }
        if (this.secretKey == null || "".equals(this.secretKey)) {
            throw new RuntimeException("secretKey is null,please invoke public StorageClient(String appName,String accessKey,String secertKey) method");
        }
    }

    public StorageClient(String appName, String accessKey, String secertKey) {
        if (!(StorageUtils.isEmpty(appName) && StorageUtils.isEmpty(accessKey) && StorageUtils.isEmpty(secertKey))) {
            throw new RuntimeException("please check your param, at least one param,At least one parameter is missing!");
        }
        this.appName = appName;
        this.accessKey = accessKey;
        this.secretKey = secertKey;
    }

    private boolean checkParameter(String parm1, String parm2) {
        if (parm1 == null | parm2 == null) {
            throw new RuntimeException(ERROR_MSG_101);
        }
        return true;
    }

    private boolean checkParameter(String parm) {
        if (parm == null) {
            throw new RuntimeException(ERROR_MSG_101);
        }
        return true;
    }

    private String getPath(String url) {
        int _index = url.indexOf("_");
        return "/" + url.substring(_index + 1);
    }

    private HttpURLConnection getConnection(String url, int timeout, String method, String path, Map<String, String> propMap) {
        HttpURLConnection conn = null;
        URL _url = null;
        boolean code = false;
        try {
            _url = new URL(url);
            conn = (HttpURLConnection)_url.openConnection();
            conn.setConnectTimeout(timeout);
            conn.setRequestMethod(method);
            if (propMap != null && propMap.size() != 0) {
                for (String k : propMap.keySet()) {
                    conn.setRequestProperty(k, propMap.get(k).toString());
                }
            }
            String date = StorageUtils.getTimeStamp();
            conn.setRequestProperty("Date", date);
            conn.setRequestProperty("Accept", "*/*");
            Map<String, List<String>> map = conn.getRequestProperties();
            StringBuffer headerbuf = new StringBuffer();
            for (String key : map.keySet()) {
                if (key == null || !key.toLowerCase().startsWith("x-sws")) continue;
                headerbuf.append(key.toLowerCase()).append(":").append(map.get(key)).append("\n");
            }
            String headerstr = headerbuf.toString();
            String signheader = method + "\n" + date + "\n" + headerstr + URLDecoder.decode(path, "utf-8");
            String ssig = StorageUtils.calcSignature(signheader, this.secretKey);
            conn.setRequestProperty("Authorization", "SWS " + this.accessKey + ":" + ssig);
        }
        catch (MalformedURLException e) {
            logger.error((Object)ERROR_MSG_102, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_102);
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_103, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_103);
        }
        return conn;
    }

    private BucketResponseProcesser doBucketOperation(HttpURLConnection conn) throws IOException {
        return this.doBucketOperation(conn, null);
    }

    private BucketResponseProcesser doBucketOperation(HttpURLConnection conn, String bucketName) throws IOException {
        BucketResponseProcesser bucketResponseProcesser = new BucketResponseProcesser();
        conn.connect();
        if (conn.getRequestMethod() != "PUT" && conn.getRequestMethod() != "DELETE") {
            bucketResponseProcesser.setBodyContent(StorageUtils.toByteArray(conn.getInputStream()));
        }
        bucketResponseProcesser.setResponseCode(conn.getResponseCode());
        bucketResponseProcesser.setResponseMessage(conn.getResponseMessage());
        bucketResponseProcesser.setResponseHeaders(conn.getHeaderFields());
        if (bucketName != null) {
            Bucket bucket = new Bucket();
            bucket.setBucketName(bucketName);
            bucket.setBucketSize(Integer.parseInt(bucketResponseProcesser.getResponseHeaders().containsKey("X-Container-Bytes-Used") ? bucketResponseProcesser.getResponseHeaders().get("X-Container-Bytes-Used").get(0).toString() : "0"));
            bucket.setObjectFilecount(Integer.parseInt(bucketResponseProcesser.getResponseHeaders().containsKey("X-Container-Object-Count") ? bucketResponseProcesser.getResponseHeaders().get("X-Container-Object-Count").get(0).toString() : "0"));
            bucket.setTimestamp(bucketResponseProcesser.getResponseHeaders().containsKey("X-Timestamp") ? bucketResponseProcesser.getResponseHeaders().get("X-Timestamp").get(0).toString() : "0");
            ArrayList<Bucket> list = new ArrayList<Bucket>();
            list.add(bucket);
            bucketResponseProcesser.setBucketList(list);
        }
        return bucketResponseProcesser;
    }

    private ObjectResponseProcesser doObjectOperation(HttpURLConnection conn) throws IOException {
        return this.doObjectOperation(conn, null);
    }

    private ObjectResponseProcesser doObjectOperation(HttpURLConnection conn, byte[] content) throws IOException {
        ObjectResponseProcesser objectResponseProcesser = new ObjectResponseProcesser();
        if (content != null) {
            String BOUNDARY = Long.toHexString(System.currentTimeMillis());
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setUseCaches(false);
            DataOutputStream out = new DataOutputStream(conn.getOutputStream());
            ((OutputStream)out).write(content);
            ((OutputStream)out).close();
            conn.disconnect();
        }
        conn.connect();
        if (conn.getRequestMethod() != "PUT" && conn.getRequestMethod() != "DELETE") {
            objectResponseProcesser.setBodyContent(StorageUtils.toByteArray(conn.getInputStream()));
        }
        objectResponseProcesser.setResponseCode(conn.getResponseCode());
        objectResponseProcesser.setResponseMessage(conn.getResponseMessage());
        objectResponseProcesser.setResponseHeaders(conn.getHeaderFields());
        return objectResponseProcesser;
    }

    @Override
    public boolean createBucket(String bucketName) {
        this.checkParameter(bucketName);
        String url = baseurl + this.appName + "/" + bucketName + "/";
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "PUT", this.getPath(url), null);
        BucketResponseProcesser responseProcesser = null;
        try {
            responseProcesser = this.doBucketOperation(conn, bucketName);
            if (responseProcesser.getResponseCode() == 201) {
                return true;
            }
            if (responseProcesser.getResponseCode() == 202) {
                throw new RuntimeException(ERROR_MSG_201);
            }
            if (responseProcesser.getResponseCode() == 413) {
                throw new RuntimeException(ERROR_MSG_204);
            }
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_103, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_103);
        }
        return false;
    }

    @Override
    public Bucket getBucketInfo(String bucketName) {
        this.checkParameter(bucketName);
        String url = baseurl + this.appName + "/" + bucketName + "/";
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "HEAD", this.getPath(url), null);
        BucketResponseProcesser bucketResponseProcesser = null;
        try {
            bucketResponseProcesser = this.doBucketOperation(conn, bucketName);
            return bucketResponseProcesser.getBucketList().get(0);
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_202, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_202);
        }
    }

    @Override
    public BucketList listBuckets() {
        String url = baseurl + this.appName + "/";
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "GET", this.getPath(url), null);
        BucketResponseProcesser bucketResponseProcesser = null;
        BucketList bl = new BucketList();
        try {
            bucketResponseProcesser = this.doBucketOperation(conn);
            List<String> list = Arrays.asList(new String(bucketResponseProcesser.getBodyContent()).split("\n"));
            bl.setBuckets(list);
            bl.setBucketsCount(Integer.parseInt(bucketResponseProcesser.getResponseHeaders().get("X-Account-Container-Count").get(0).toString()));
            bl.setBucketsTotalObjectCount(Integer.parseInt(bucketResponseProcesser.getResponseHeaders().get("X-Account-Object-Count").get(0).toString()));
            bl.setBucketsUsedSize(Integer.parseInt(bucketResponseProcesser.getResponseHeaders().get("X-Account-Bytes-Used").get(0).toString()));
            bl.setTimestamp(bucketResponseProcesser.getResponseHeaders().get("X-Timestamp").get(0).toString().trim());
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_103, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_103);
        }
        return bl;
    }

    @Override
    public ObjectFileList getBucket(String bucketName) {
        return this.getBucket(bucketName, null);
    }

    @Override
    public ObjectFileList getBucket(String bucketName, String prefix) {
        this.checkParameter(bucketName);
        String url = baseurl + this.appName + "/" + bucketName + "/";
        if (prefix != null && !"".equals(prefix)) {
            url = url + "?prefix=" + prefix;
        }
        ObjectResponseProcesser objectResponseProcesser = null;
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "GET", this.getPath(url), null);
        ObjectFileList ofl = new ObjectFileList();
        try {
            objectResponseProcesser = this.doObjectOperation(conn);
            ofl.setObjectCount(Integer.parseInt(objectResponseProcesser.getResponseHeaders().get("X-Container-Object-Count").get(0)));
            ofl.setTimestamp(objectResponseProcesser.getResponseHeaders().get("X-Timestamp").get(0).toString().trim());
            ofl.setTotalObjectUsedSize(Integer.parseInt(objectResponseProcesser.getResponseHeaders().get("X-Container-Bytes-Used").get(0)));
            List<String> list = Arrays.asList(new String(objectResponseProcesser.getBodyContent()).split("\n"));
            ofl.setObjectList(list);
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_103, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_103);
        }
        return ofl;
    }

    @Override
    public boolean deleteBucket(String bucketName) {
        this.checkParameter(bucketName);
        String url = baseurl + this.appName + "/" + bucketName + "/";
        BucketResponseProcesser bucketResponseProcesser = null;
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "DELETE", this.getPath(url), null);
        try {
            bucketResponseProcesser = this.doBucketOperation(conn);
            if (bucketResponseProcesser.getResponseCode() == 204) {
                return true;
            }
            if (bucketResponseProcesser.getResponseCode() == 404) {
                throw new RuntimeException(ERROR_MSG_203);
            }
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_202, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_202);
        }
        return false;
    }

    @Override
    public boolean putObjectFile(String bucketName, String fileName, byte[] content, Map<String, String> map) {
        this.checkParameter(bucketName, fileName);
        String url = baseurl + this.appName + "/" + bucketName + "/" + fileName;
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "PUT", this.getPath(url), map);
        ObjectResponseProcesser objectResponseProcesser = null;
        try {
            objectResponseProcesser = this.doObjectOperation(conn, content);
            if (objectResponseProcesser.getResponseCode() == 201) {
                return true;
            }
            if (objectResponseProcesser.getResponseCode() == 404) {
                throw new RuntimeException(ERROR_MSG_202);
            }
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_202, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_202);
        }
        return false;
    }

    @Override
    public boolean putObjectFile(String bucketName, String fileName, File file, Map<String, String> map) {
        this.checkParameter(bucketName, fileName);
        if (!file.exists()) {
            throw new RuntimeException(ERROR_MSG_104);
        }
        try {
            int n;
            FileInputStream fis = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] b = new byte[1024];
            while ((n = fis.read(b)) != -1) {
                bos.write(b);
            }
            fis.close();
            bos.close();
            byte[] content = bos.toByteArray();
            return this.putObjectFile(bucketName.trim(), fileName, content, map);
        }
        catch (FileNotFoundException e) {
            logger.error((Object)ERROR_MSG_301);
            throw new RuntimeException(ERROR_MSG_301);
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_202, (Throwable)e);
            throw new RuntimeException(ERROR_MSG_202);
        }
    }

    @Override
    public ObjectFile getObject(String bucketName, String objectFileName) {
        ObjectFile of = new ObjectFile();
        this.checkParameter(bucketName, objectFileName);
        String url = baseurl + this.appName + "/" + bucketName + "/" + objectFileName;
        ObjectResponseProcesser objectResponseProcesser = null;
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "GET", this.getPath(url), null);
        try {
            objectResponseProcesser = this.doObjectOperation(conn);
            of.setFileName(objectFileName);
            of.setContent(objectResponseProcesser.getBodyContent());
            of.setFileSize(Integer.parseInt(objectResponseProcesser.getResponseHeaders().get("Content-Length").get(0)));
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_301);
            throw new RuntimeException(ERROR_MSG_301);
        }
        return of;
    }

    @Override
    public boolean deleteObject(String bucketName, String objectFileName) {
        this.checkParameter(bucketName, objectFileName);
        String url = baseurl + this.appName + "/" + bucketName + "/" + objectFileName;
        ObjectResponseProcesser objectResponseProcesser = null;
        HttpURLConnection conn = this.getConnection(url, internal_timeout, "DELETE", this.getPath(url), null);
        try {
            objectResponseProcesser = this.doObjectOperation(conn);
            if (objectResponseProcesser.getResponseCode() == 204) {
                return true;
            }
            if (objectResponseProcesser.getResponseCode() == 404) {
                throw new RuntimeException(ERROR_MSG_301);
            }
        }
        catch (IOException e) {
            logger.error((Object)ERROR_MSG_301);
            throw new RuntimeException(ERROR_MSG_301);
        }
        return false;
    }

    public String getTempUrl(String bucketName, String method, String objectName, int seconds) {
        TimeZone.setDefault(TimeZone.getTimeZone("Asia/Shanghai"));
        long expires = new Date().getTime() / 1000L + (long)seconds;
        String path = "/v1/SAE_" + this.appName + "/" + bucketName + "/" + objectName;
        String sig_context = method + "\n" + expires + "\n" + URLDecoder.decode(path);
        String sig = StorageUtils.calcSignatureNotBase64("HmacSHA1", sig_context, this.secretKey);
        return "http://" + this.appName + "-" + bucketName + ".stor.sinaapp.com/" + objectName + "?" + "temp_url_sig=" + sig + "&" + "temp_url_expires=" + expires;
    }
}

