/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.storage;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONObject;
import sun.misc.BASE64Encoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StorageUtils {
    public static final String DATE_FORMAT = "EEE',' d MMM yyyy HH:mm:ss 'GMT'";
    private static Logger logger = Logger.getLogger((String)StorageUtils.class.getName());

    public static String getTimeStamp() {
        long time = System.currentTimeMillis();
        Date date = new Date(time);
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT, Locale.US);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        return sdf.format(date);
    }

    public static String calcSignature(String content, String secretKey) {
        return StorageUtils.calcSignature("HmacSHA1", content, secretKey);
    }

    public static String calcSignature(String cryptoType, String content, String secretKey) {
        try {
            Mac mac = Mac.getInstance(cryptoType);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getBytes(), cryptoType);
            mac.init(secret);
            byte[] digest = mac.doFinal(content.getBytes());
            BASE64Encoder encode = new BASE64Encoder();
            return encode.encode(digest);
        }
        catch (Exception e) {
            logger.error((Object)"calc signature failure.", (Throwable)e);
            return "";
        }
    }

    public static String calcSignatureNotBase64(String cryptoType, String content, String secretKey) {
        try {
            Mac mac = Mac.getInstance(cryptoType);
            SecretKeySpec secret = new SecretKeySpec(secretKey.getBytes(), cryptoType);
            mac.init(secret);
            byte[] digest = mac.doFinal(content.getBytes());
            return StorageUtils.byte2hex(digest);
        }
        catch (Exception e) {
            logger.error((Object)"calc signature failure.", (Throwable)e);
            return "";
        }
    }

    private static String byte2hex(byte[] b) {
        String hs = "";
        String stmp = "";
        for (int n = 0; n < b.length; ++n) {
            stmp = Integer.toHexString(b[n] & 0xFF);
            hs = stmp.length() == 1 ? hs + "0" + stmp : hs + stmp;
        }
        return hs;
    }

    public static String encodeBase64(String encodeContent) {
        BASE64Encoder encode = new BASE64Encoder();
        return encode.encode(encodeContent.getBytes());
    }

    public static String trimUrl(String url) {
        if (url == null || "".equals(url)) {
            throw new IllegalArgumentException("url is null");
        }
        return url.trim();
    }

    public static boolean isEmpty(String str) {
        return str != "" && str != null;
    }

    public static String formatFileName(String fileName) {
        try {
            String name = fileName.trim();
            String encodeName = new String(name.getBytes(), "UTF-8");
            encodeName = encodeName.replaceAll("/+", "/");
            if (encodeName.indexOf("/") == 0) {
                encodeName = encodeName.substring(1, encodeName.length());
            }
            return URLEncoder.encode(encodeName, "utf-8").replaceAll("%2F", "/");
        }
        catch (Exception e) {
            logger.error((Object)"format file name failure.", (Throwable)e);
            return "";
        }
    }

    public static String writeFile(String path, byte[] content, int size) {
        StorageUtils.createDirIfNotExist(path);
        File file = new File(path);
        String childFile = Integer.toString(new Random().nextInt());
        File f = new File(file, childFile);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            if (size > -1) {
                byte[] newBuf = new byte[size];
                if (size > content.length) {
                    size = content.length;
                }
                System.arraycopy(content, 0, newBuf, 0, size);
                content = newBuf;
            }
            baos.write(content);
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            baos.close();
            fos.close();
        }
        catch (Exception e) {
            logger.error((Object)"write file failure.", (Throwable)e);
        }
        return f.getAbsolutePath();
    }

    public static String writeFileWithCompress(String path, byte[] content, int size) {
        StorageUtils.createDirIfNotExist(path);
        File file = new File(path);
        String childFile = Integer.toString(new Random().nextInt());
        File f = new File(file, childFile);
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            if (size > -1) {
                byte[] newBuf = new byte[size];
                if (size > content.length) {
                    size = content.length;
                }
                System.arraycopy(content, 0, newBuf, 0, size);
                content = newBuf;
            }
            gos.write(content);
            gos.finish();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            baos.close();
            gos.close();
            fos.close();
        }
        catch (Exception e) {
            logger.error((Object)"write file(compress) failure.", (Throwable)e);
        }
        return f.getAbsolutePath();
    }

    public static void createDirIfNotExist(String dir) {
        File file = new File(dir);
        if (!file.exists()) {
            file.mkdirs();
        }
    }

    public static String jsonEncodeforObjectMap(Map<String, Object> map) {
        JSONObject json = new JSONObject(map);
        return json.toString();
    }

    public static String jsonEncode(List<String> list) {
        JSONArray result = new JSONArray(list);
        return result.toString();
    }

    public static Map<String, Object> domainAttrToHeader(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (!((Boolean)map.get("private")).booleanValue()) {
            newMap.put("X-Container-Read", ".r:*");
            newMap.put("X-Container-Meta-Web-Listings", "false");
        } else {
            newMap.put("X-Container-Read", "0");
            newMap.put("X-Container-Meta-Web-Listings", "true");
        }
        for (String key : map.keySet()) {
            Map map_refer;
            List hosts;
            if (key.equals("quotaLevel")) {
                newMap.put("X-Container-Meta-Quota", map.get(key));
            }
            if (key.equals("404Redirect")) {
                newMap.put("X-Container-Meta-Web-Error", map.get(key));
            }
            if (key.equals("expires")) {
                if (map.get(key) != null) {
                    Map map_expires = (Map)map.get("expires");
                    int num = (Integer)map_expires.get("active");
                    if (num == 1) {
                        String expiresStr = "";
                        String expire_type = (String)map_expires.get("default");
                        if (expire_type != null && expire_type != "") {
                            if (expire_type.equals("access")) {
                                expiresStr = "";
                            } else if (expire_type.equals("modified")) {
                                expiresStr = "modified ";
                            }
                            if (map_expires.get("expires_time") != null) {
                                expiresStr = expiresStr + map_expires.get("expires_time");
                            }
                        }
                        newMap.put("X-Container-Meta-Expires", expiresStr);
                    } else {
                        newMap.put("X-Container-Meta-Expires", "off");
                    }
                } else {
                    newMap.put("X-Container-Meta-Expires", "off");
                }
            }
            if (key.equals("allowReferer") && (hosts = (List)(map_refer = (Map)map.get("allowReferer")).get("hosts")) != null) {
                String strtem = "";
                ArrayList<String> temlist = new ArrayList<String>();
                for (int i = 0; i < hosts.size(); ++i) {
                    if (hosts.get(i) == null) continue;
                    String tem = ".r:" + (String)hosts.get(i);
                    temlist.add(tem);
                }
                if (map_refer.get("redirect") != null) {
                    String tem2 = ".r:" + map_refer.get("redirect");
                    temlist.add(tem2);
                }
                for (int j = 0; j < temlist.size(); ++j) {
                    strtem = j < temlist.size() - 1 ? strtem + (String)temlist.get(j) + "," : strtem + (String)temlist.get(j);
                }
                newMap.put("X-Container-Read", strtem);
            }
            if (!key.equals("tag")) continue;
            List list = (List)map.get(key);
            newMap.put("X-Container-Meta-Tags", list.toString());
        }
        return newMap;
    }

    public static Map<String, Object> parseFileAttr(Map<String, String> map) {
        Set<Map.Entry<String, String>> entry = map.entrySet();
        Iterator<Map.Entry<String, String>> iter = entry.iterator();
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        LinkedHashMap<String, String> expires = new LinkedHashMap<String, String>();
        while (iter.hasNext()) {
            Map.Entry<String, String> entryValue = iter.next();
            String key = entryValue.getKey().toLowerCase();
            if ("expires_type".equals(key)) {
                expires.put("expires_type", entryValue.getValue());
            }
            if ("expires_time".equals(key)) {
                expires.put("expires_time", entryValue.getValue());
                continue;
            }
            if ("encoding".equals(key)) {
                newMap.put("encoding", entryValue.getValue());
                continue;
            }
            if ("type".equals(key)) {
                newMap.put("type", entryValue.getValue());
                continue;
            }
            if (!"private".equals(key)) continue;
            newMap.put("private", entryValue.getValue());
        }
        if (expires != null) {
            newMap.put("expires", expires);
        }
        return newMap;
    }

    public static Map<String, String> fileAttrToHeader(Map<String, Object> map) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey().toLowerCase();
            if ("expires".equals(key)) {
                Map expiresMap = (Map)entry.getValue();
                String expires = "";
                if (null != expiresMap) {
                    String type = (String)expiresMap.get("expires_type");
                    if (type != null && type.equals("modified")) {
                        expires = "modified ";
                    } else if (type != null && type.equals("access")) {
                        expires = "";
                    }
                    if (expiresMap.get("expires_time") != null) {
                        expires = expires + expiresMap.get("expires_time");
                    }
                }
                newMap.put("X-Object-Meta-Expires", expires);
                continue;
            }
            if ("encoding".equals(key)) {
                newMap.put("Content-Encoding", (String)entry.getValue());
                continue;
            }
            if (!"type".equals(key)) continue;
            newMap.put("Content-Type", (String)entry.getValue());
        }
        return newMap;
    }

    public static byte[] uncompress(byte[] str) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ByteArrayInputStream in = new ByteArrayInputStream(str);
        try {
            int n;
            GZIPInputStream gunzip = new GZIPInputStream(in);
            byte[] buffer = new byte[256];
            while ((n = gunzip.read(buffer)) >= 0) {
                out.write(buffer, 0, n);
            }
            return out.toByteArray();
        }
        catch (IOException e) {
            logger.error((Object)"uncompress failure", (Throwable)e);
            return new byte[10];
        }
    }

    public static String uploadFileWithCompress(String parentFile, String srcFile) {
        File file = new File(parentFile);
        String childFile = Integer.toString(new Random().nextInt());
        File f = new File(file, childFile);
        try {
            File src = new File(srcFile);
            FileInputStream fis = new FileInputStream(src);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            GZIPOutputStream gos = new GZIPOutputStream(baos);
            byte[] buf = new byte[1024];
            int len = -1;
            while ((len = fis.read(buf)) != -1) {
                gos.write(buf, 0, len);
            }
            gos.finish();
            FileOutputStream fos = new FileOutputStream(f);
            fos.write(baos.toByteArray());
            fos.close();
            baos.close();
            gos.close();
            fis.close();
        }
        catch (Exception e) {
            logger.error((Object)"upload file failure.", (Throwable)e);
        }
        return f.getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public static String printResponseHeader(HttpURLConnection http) {
        try {
            Map<String, String> header = StorageUtils.getHttpResponseHeader(http);
            StringBuffer jbsb = new StringBuffer();
            for (Map.Entry<String, String> entry : header.entrySet()) {
                String key = entry.getKey() != null ? entry.getKey() + ":" : "";
                jbsb.append(key + entry.getValue());
                System.out.println(key + entry.getValue());
            }
            return jbsb.toString();
        }
        catch (UnsupportedEncodingException e) {
            logger.error((Object)"printResponseHeader failure", (Throwable)e);
            return "";
        }
    }

    public static Map<String, String> getHttpResponseHeader(HttpURLConnection http) throws UnsupportedEncodingException {
        String mine;
        LinkedHashMap<String, String> header = new LinkedHashMap<String, String>();
        int i = 0;
        while ((mine = http.getHeaderField(i)) != null) {
            header.put(http.getHeaderFieldKey(i), mine);
            ++i;
        }
        return header;
    }

    public static byte[] toByteArray(InputStream input) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        int n = 0;
        try {
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            return output.toByteArray();
        }
        catch (IOException e) {
            logger.error((Object)"toByteArray(InputStream input) failure", (Throwable)e);
            return new byte[10];
        }
    }
}

