/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.retry;

import com.sinacloud.scs.SCSClientException;
import com.sinacloud.scs.SCSServiceException;
import com.sinacloud.scs.SCSWebServiceRequest;
import com.sinacloud.scs.retry.RetryHandler;
import com.sinacloud.scs.retry.RetryPolicy;
import com.sinacloud.scs.retry.RetryUtils;
import java.io.IOException;
import java.util.Random;
import org.apache.http.client.HttpRequestRetryHandler;

public class PredefinedRetryPolicies {
    public static int DEFAULT_MAX_ERROR_RETRY = 3;
    public static final RetryPolicy DEFAULT;
    public static final RetryPolicy.BackoffStrategy DEFAULT_BACKOFF_STRATEGY;
    public static final RetryPolicy.RetryCondition DEFAULT_RETRY_CONDITION;

    public static RetryPolicy getDefaultRetryPolicy() {
        return new RetryPolicy(DEFAULT_RETRY_CONDITION, DEFAULT_BACKOFF_STRATEGY, DEFAULT_MAX_ERROR_RETRY, true);
    }

    public static HttpRequestRetryHandler getDefaultRetryPolicyWithCustomMaxRetries(int maxErrorRetry) {
        return new RetryHandler(maxErrorRetry);
    }

    static {
        DEFAULT_BACKOFF_STRATEGY = new SDKDefaultBackoffStrategy();
        DEFAULT_RETRY_CONDITION = new SDKDefaultRetryCondition();
        DEFAULT = PredefinedRetryPolicies.getDefaultRetryPolicy();
    }

    public static class SDKDefaultRetryCondition
    implements RetryPolicy.RetryCondition {
        public boolean shouldRetry(SCSWebServiceRequest originalRequest, SCSClientException exception, int retriesAttempted) {
            if (exception.getCause() instanceof IOException) {
                return true;
            }
            if (exception instanceof SCSServiceException) {
                SCSServiceException ase = (SCSServiceException)exception;
                if (ase.getStatusCode() == 500 || ase.getStatusCode() == 503) {
                    return true;
                }
                if (RetryUtils.isThrottlingException(ase)) {
                    return true;
                }
                if (RetryUtils.isClockSkewError(ase)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class SDKDefaultBackoffStrategy
    implements RetryPolicy.BackoffStrategy {
        private static final int SCALE_FACTOR = 300;
        private static final int THROTTLING_SCALE_FACTOR = 500;
        private static final int THROTTLING_SCALE_FACTOR_RANDOM_RANGE = 125;
        private static final int MAX_BACKOFF_IN_MILLISECONDS = 20000;
        private final Random random = new Random();

        private SDKDefaultBackoffStrategy() {
        }

        public final long delayBeforeNextRetry(SCSWebServiceRequest originalRequest, SCSClientException exception, int retries) {
            if (retries <= 0) {
                return 0L;
            }
            int scaleFactor = exception instanceof SCSServiceException && RetryUtils.isThrottlingException((SCSServiceException)exception) ? 500 + this.random.nextInt(125) : 300;
            long delay = (1 << retries) * scaleFactor;
            delay = Math.min(delay, 20000L);
            return delay;
        }
    }
}

