/*
 * Decompiled with CFR 0.152.
 */
package com.sinacloud.scs.services.scs.internal;

import com.sinacloud.scs.SCSWebServiceResponse;
import com.sinacloud.scs.http.HttpResponse;
import com.sinacloud.scs.services.scs.internal.AbstractS3ResponseHandler;
import com.sinacloud.scs.services.scs.model.ObjectMetadata;
import com.sinacloud.scs.services.scs.model.S3Object;
import com.sinacloud.scs.services.scs.model.S3ObjectInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class S3ObjectResponseHandler
extends AbstractS3ResponseHandler<S3Object> {
    @Override
    public SCSWebServiceResponse<S3Object> handle(HttpResponse response) throws Exception {
        S3Object object = new S3Object();
        SCSWebServiceResponse<S3Object> awsResponse = this.parseResponseMetadata(response);
        if (response.getHeaders().get("x-amz-website-redirect-location") != null) {
            object.setRedirectLocation(response.getHeaders().get("x-amz-website-redirect-location"));
        }
        ObjectMetadata metadata = object.getObjectMetadata();
        this.populateObjectMetadata(response, metadata);
        object.setObjectContent(new S3ObjectInputStream(response.getContent(), response.getHttpRequest()));
        awsResponse.setResult(object);
        return awsResponse;
    }

    @Override
    public boolean needsConnectionLeftOpen() {
        return true;
    }
}

