/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.session;

import com.sobercoding.loopauth.context.LoopAuthContext;
import com.sobercoding.loopauth.context.LoopAuthContextDefaultImpl;
import com.sobercoding.loopauth.function.LrFunction;
import com.sobercoding.loopauth.session.carryout.component.LoopAuthLogin;
import com.sobercoding.loopauth.session.carryout.component.LoopAuthToken;
import com.sobercoding.loopauth.session.config.CookieConfig;
import com.sobercoding.loopauth.session.config.RedisConfig;
import com.sobercoding.loopauth.session.config.SessionConfig;
import com.sobercoding.loopauth.session.dao.LoopAuthDao;
import com.sobercoding.loopauth.session.dao.LoopAuthDaoImpl;
import com.sobercoding.loopauth.session.model.TokenModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class SessionStrategy {
    private static volatile SessionConfig sessionConfig;
    private static volatile RedisConfig redisConfig;
    private static volatile CookieConfig cookieConfig;
    private static volatile LoopAuthToken loopAuthToken;
    private static volatile LoopAuthLogin loopAuthLogin;
    private static volatile LoopAuthDao loopAuthDao;
    private static volatile LoopAuthContext loopAuthContext;
    public static Function<String, String> getSecretKey;
    public static LrFunction<Set<TokenModel>, TokenModel> loginRulesMatching;

    public static void setSessionConfig(SessionConfig sessionConfig) {
        SessionStrategy.sessionConfig = sessionConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SessionConfig getSessionConfig() {
        if (sessionConfig != null) return sessionConfig;
        Class<SessionStrategy> clazz = SessionStrategy.class;
        synchronized (SessionStrategy.class) {
            if (sessionConfig != null) return sessionConfig;
            SessionStrategy.setSessionConfig(new SessionConfig());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sessionConfig;
        }
    }

    public static void setRedisConfig(RedisConfig redisConfig) {
        SessionStrategy.redisConfig = redisConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RedisConfig getRedisConfig() {
        if (redisConfig != null) return redisConfig;
        Class<SessionStrategy> clazz = SessionStrategy.class;
        synchronized (SessionStrategy.class) {
            if (redisConfig != null) return redisConfig;
            SessionStrategy.setRedisConfig(new RedisConfig());
            // ** MonitorExit[var0] (shouldn't be in output)
            return redisConfig;
        }
    }

    public static void setCookieConfig(CookieConfig cookieConfig) {
        SessionStrategy.cookieConfig = cookieConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CookieConfig getCookieConfig() {
        if (cookieConfig != null) return cookieConfig;
        Class<SessionStrategy> clazz = SessionStrategy.class;
        synchronized (SessionStrategy.class) {
            if (cookieConfig != null) return cookieConfig;
            SessionStrategy.setCookieConfig(new CookieConfig());
            // ** MonitorExit[var0] (shouldn't be in output)
            return cookieConfig;
        }
    }

    public static void setLoopAuthToken(LoopAuthToken loopAuthToken) {
        SessionStrategy.loopAuthToken = loopAuthToken;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoopAuthToken getLoopAuthToken() {
        if (loopAuthToken != null) return loopAuthToken;
        Class<SessionStrategy> clazz = SessionStrategy.class;
        synchronized (SessionStrategy.class) {
            if (loopAuthToken != null) return loopAuthToken;
            SessionStrategy.setLoopAuthToken(new LoopAuthToken());
            // ** MonitorExit[var0] (shouldn't be in output)
            return loopAuthToken;
        }
    }

    public static void setLoopAuthLogin(LoopAuthLogin loopAuthLogin) {
        SessionStrategy.loopAuthLogin = loopAuthLogin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoopAuthLogin getLoopAuthLogin() {
        if (loopAuthLogin != null) return loopAuthLogin;
        Class<SessionStrategy> clazz = SessionStrategy.class;
        synchronized (SessionStrategy.class) {
            if (loopAuthLogin != null) return loopAuthLogin;
            SessionStrategy.setLoopAuthLogin(new LoopAuthLogin());
            // ** MonitorExit[var0] (shouldn't be in output)
            return loopAuthLogin;
        }
    }

    public static void setLoopAuthDao(LoopAuthDao loopAuthDao) {
        SessionStrategy.loopAuthDao = loopAuthDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoopAuthDao getLoopAuthDao() {
        if (loopAuthDao != null) return loopAuthDao;
        Class<SessionStrategy> clazz = SessionStrategy.class;
        synchronized (SessionStrategy.class) {
            if (loopAuthDao != null) return loopAuthDao;
            SessionStrategy.setLoopAuthDao(new LoopAuthDaoImpl());
            // ** MonitorExit[var0] (shouldn't be in output)
            return loopAuthDao;
        }
    }

    public static void setLoopAuthContext(LoopAuthContext loopAuthContext) {
        SessionStrategy.loopAuthContext = loopAuthContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LoopAuthContext getLoopAuthContext() {
        if (loopAuthContext != null) return loopAuthContext;
        Class<SessionStrategy> clazz = SessionStrategy.class;
        synchronized (SessionStrategy.class) {
            if (loopAuthContext != null) return loopAuthContext;
            SessionStrategy.setLoopAuthContext((LoopAuthContext)new LoopAuthContextDefaultImpl());
            // ** MonitorExit[var0] (shouldn't be in output)
            return loopAuthContext;
        }
    }

    static {
        getSecretKey = userId -> SessionStrategy.getSessionConfig().getSecretKey();
        loginRulesMatching = (tokenModels, tokenModel) -> {
            if (tokenModels.contains(tokenModel)) {
                return new HashSet();
            }
            HashSet<Object> removeTokenModels = new HashSet<Object>();
            if (SessionStrategy.getSessionConfig().getMutualism().booleanValue()) {
                int maxLoginCount;
                Optional<TokenModel> optionalTokenModel;
                if (SessionStrategy.getSessionConfig().getExclusion().booleanValue() && (optionalTokenModel = tokenModels.stream().filter(item -> item.getFacility().equals(tokenModel.getFacility())).findAny()).isPresent()) {
                    tokenModels.remove(optionalTokenModel.get());
                    removeTokenModels.add(optionalTokenModel.get());
                }
                if ((maxLoginCount = SessionStrategy.getSessionConfig().getMaxLoginCount()) != -1 && tokenModels.size() >= maxLoginCount) {
                    List<Object> tokenModelList = new ArrayList(tokenModels);
                    tokenModelList = tokenModelList.stream().sorted(Comparator.comparing(TokenModel::getCreateTime)).collect(Collectors.toList());
                    tokenModelList = tokenModelList.stream().limit(tokenModels.size() - maxLoginCount + 1).collect(Collectors.toList());
                    tokenModelList.forEach(tokenModels::remove);
                    removeTokenModels.addAll(tokenModelList);
                }
            } else {
                removeTokenModels.addAll((Collection<Object>)tokenModels);
            }
            tokenModels.add(tokenModel);
            return removeTokenModels;
        };
    }
}

