/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.session.carryout.component;

import com.sobercoding.loopauth.exception.LoopAuthExceptionEnum;
import com.sobercoding.loopauth.exception.LoopAuthLoginException;
import com.sobercoding.loopauth.session.SessionStrategy;
import com.sobercoding.loopauth.session.context.LoopAuthCookie;
import com.sobercoding.loopauth.session.model.TokenAccessMode;
import com.sobercoding.loopauth.session.model.TokenModel;
import com.sobercoding.loopauth.session.model.UserSession;
import com.sobercoding.loopauth.util.LoopAuthUtil;
import java.util.Optional;

public class LoopAuthLogin {
    public void login(TokenModel tokenModel) {
        UserSession userSession = this.creationSession(tokenModel);
        this.setContext(tokenModel);
        SessionStrategy.getLoopAuthContext().getStorage().set("userSession", (Object)userSession);
        SessionStrategy.getLoopAuthContext().getStorage().set("isLogin", (Object)true);
    }

    public void loginRenew() {
        TokenModel tokenModel = this.getTokenModel().setCreateTime(System.currentTimeMillis()).setTimeOut(SessionStrategy.getSessionConfig().getTimeOut());
        if (SessionStrategy.getSessionConfig().getTokenPersistence().booleanValue()) {
            this.getUserSession().setToken(tokenModel);
        } else {
            this.creationToken(tokenModel);
        }
        this.setContext(tokenModel);
    }

    public void logout() {
        if (SessionStrategy.getSessionConfig().getTokenPersistence().booleanValue()) {
            this.getUserSession().removeToken(this.getTokenModel().getValue());
        }
        SessionStrategy.getLoopAuthContext().getStorage().delete("userSession");
        SessionStrategy.getLoopAuthContext().getStorage().delete("isLogin");
        this.delCookie(SessionStrategy.getSessionConfig().getTokenName());
    }

    public void logoutAll() {
        if (SessionStrategy.getSessionConfig().getTokenPersistence().booleanValue()) {
            this.getUserSession().remove();
        }
        SessionStrategy.getLoopAuthContext().getStorage().delete("userSession");
        SessionStrategy.getLoopAuthContext().getStorage().delete("isLogin");
        this.delCookie(SessionStrategy.getSessionConfig().getTokenName());
    }

    public void isLogin() {
        if (SessionStrategy.getLoopAuthContext().getStorage().get("isLogin") == null) {
            this.loadUserSession();
            if (SessionStrategy.getSessionConfig().getRenew().booleanValue()) {
                this.loginRenew();
            }
        }
    }

    public UserSession getUserSession() {
        return (UserSession)SessionStrategy.getLoopAuthContext().getStorage().get("userSession");
    }

    public UserSession getUserSessionByLoginId(String loginId) {
        return new UserSession().setLoginId(loginId).gainUserSession();
    }

    public TokenModel getTokenModel() {
        return this.getUserSession().getTokenModelNow();
    }

    public TokenModel getTokenModelByTokenValue(String token) {
        return new UserSession().setTokenModelNow(new TokenModel().setValue(token)).gainUserSession().getTokenModelNow();
    }

    public void forcedOfflineByToken(String ... tokens) {
        new UserSession().setTokenModelNow(new TokenModel().setValue(tokens[0])).gainUserSession().removeToken(tokens);
    }

    public void forcedOfflineByLoginId(String loginId) {
        new UserSession().setLoginId(loginId).gainUserSession().remove();
    }

    private UserSession creationSession(TokenModel tokenModel) {
        UserSession userSession = new UserSession();
        this.creationToken(tokenModel);
        if (SessionStrategy.getSessionConfig().getTokenPersistence().booleanValue()) {
            userSession = this.getUserSessionByLoginId(tokenModel.getLoginId());
            userSession.setToken(tokenModel);
        }
        userSession.setTokenModelNow(tokenModel);
        return userSession;
    }

    private void creationToken(TokenModel tokenModel) {
        String token = SessionStrategy.getLoopAuthToken().createToken(tokenModel, SessionStrategy.getSecretKey.apply(tokenModel.getLoginId()));
        tokenModel.setValue(token);
    }

    private void loadUserSession() {
        String token = null;
        for (TokenAccessMode tokenAccessMode : SessionStrategy.getSessionConfig().getAccessModes()) {
            switch (tokenAccessMode) {
                case COOKIE: {
                    token = SessionStrategy.getLoopAuthContext().getRequest().getCookieValue(SessionStrategy.getSessionConfig().getTokenName());
                    break;
                }
                case HEADER: {
                    token = SessionStrategy.getLoopAuthContext().getRequest().getHeader(SessionStrategy.getSessionConfig().getTokenName());
                    break;
                }
            }
            if (!LoopAuthUtil.isNotEmpty(token)) continue;
            break;
        }
        LoopAuthLoginException.isEmpty(token, (LoopAuthExceptionEnum)LoopAuthExceptionEnum.LOGIN_NOT_EXIST_F, (String)"Failed to obtain Token");
        TokenModel tokenBodyModel = SessionStrategy.getLoopAuthToken().getInfo(token);
        LoopAuthLoginException.isEmpty((Object)tokenBodyModel, (LoopAuthExceptionEnum)LoopAuthExceptionEnum.LOGIN_NOT_EXIST_F, (String)"Token illegal");
        LoopAuthLoginException.isTrue((boolean)SessionStrategy.getLoopAuthToken().verify(token, SessionStrategy.getSecretKey.apply(tokenBodyModel.getLoginId())), (LoopAuthExceptionEnum)LoopAuthExceptionEnum.LOGIN_NOT_EXIST_F, (String)"Token illegal");
        UserSession userSession = new UserSession().setTokenModelNow(tokenBodyModel);
        if (SessionStrategy.getSessionConfig().getTokenPersistence().booleanValue()) {
            userSession.gainUserSession();
            Optional.ofNullable(userSession.getTokenModelNow()).orElseThrow(() -> new LoopAuthLoginException(LoopAuthExceptionEnum.LOGIN_NOT_EXIST));
            if (this.isExpire(userSession.getTokenModelNow())) {
                this.getUserSession().removeToken(userSession.getTokenModelNow().getValue());
                this.delCookie(SessionStrategy.getSessionConfig().getTokenName());
                throw new LoopAuthLoginException(LoopAuthExceptionEnum.LOGIN_NOT_EXIST_F, "The token is due");
            }
        }
        SessionStrategy.getLoopAuthContext().getStorage().set("userSession", (Object)userSession);
        SessionStrategy.getLoopAuthContext().getStorage().set("isLogin", (Object)true);
    }

    private boolean isExpire(TokenModel tokenModel) {
        if (SessionStrategy.getSessionConfig().getTimeOut() != -1L) {
            return tokenModel.getCreateTime() + tokenModel.getTimeOut() < System.currentTimeMillis();
        }
        return false;
    }

    private void setContext(TokenModel tokenModel) {
        if (SessionStrategy.getSessionConfig().getAccessModes().stream().anyMatch(tokenAccessMode -> tokenAccessMode == TokenAccessMode.COOKIE)) {
            LoopAuthCookie cookie = new LoopAuthCookie().setName(SessionStrategy.getSessionConfig().getTokenName()).setValue(tokenModel.getValue());
            SessionStrategy.getLoopAuthContext().getResponse().addHeader("Set-Cookie", cookie.toCookieString());
        }
        if (SessionStrategy.getSessionConfig().getAccessModes().stream().anyMatch(tokenAccessMode -> tokenAccessMode == TokenAccessMode.HEADER)) {
            SessionStrategy.getLoopAuthContext().getResponse().setHeader(SessionStrategy.getSessionConfig().getTokenName(), tokenModel.getValue());
        }
    }

    private void delCookie(String name) {
        if (SessionStrategy.getSessionConfig().getAccessModes().stream().anyMatch(tokenAccessMode -> tokenAccessMode == TokenAccessMode.COOKIE)) {
            LoopAuthCookie cookie = new LoopAuthCookie().setName(name).setValue("None").setMaxAge(0L);
            SessionStrategy.getLoopAuthContext().getResponse().addHeader("Set-Cookie", cookie.toCookieString());
        }
    }
}

