/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.session.carryout.component;

import com.sobercoding.loopauth.exception.LoopAuthExceptionEnum;
import com.sobercoding.loopauth.exception.LoopAuthLoginException;
import com.sobercoding.loopauth.session.SessionStrategy;
import com.sobercoding.loopauth.session.model.TokenModel;
import com.sobercoding.loopauth.util.AesUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class LoopAuthToken {
    public String createToken(TokenModel tokenModel, String secretKey) {
        String original = tokenModel.getLoginId() + "," + tokenModel.getCreateTime() + "," + tokenModel.getTimeOut() + "," + tokenModel.getFacility() + "," + tokenModel.getFacilityName();
        return this.getBase64(original) + "_" + AesUtil.encrypted((String)original, (String)secretKey);
    }

    public boolean verify(String token, String secretKey) {
        try {
            String[] tokens = token.split("_");
            String info = this.getFromBase64(tokens[0]);
            String originalText = AesUtil.decode((String)tokens[1], (String)secretKey);
            TokenModel tokenModel = this.getInfo(token);
            if (!SessionStrategy.getSessionConfig().getTokenPersistence().booleanValue() && SessionStrategy.getSessionConfig().getTimeOut() != -1L && tokenModel.getCreateTime() + tokenModel.getTimeOut() < System.currentTimeMillis()) {
                throw new LoopAuthLoginException(LoopAuthExceptionEnum.LOGIN_NOT_EXIST_F, "The token is due");
            }
            return info.equals(originalText);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public TokenModel getInfo(String token) {
        try {
            String[] tokens = token.split("_");
            String[] infos = this.getFromBase64(tokens[0]).split(",");
            return new TokenModel().setValue(token).setLoginId(infos[0]).setCreateTime(Long.parseLong(infos[1])).setTimeOut(Long.parseLong(infos[2])).setFacility(infos[3]).setFacilityName(infos[4]);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getBase64(String str) {
        byte[] b = str.getBytes(StandardCharsets.UTF_8);
        return new String(Base64.getEncoder().encode(b));
    }

    private String getFromBase64(String str) {
        String result = null;
        if (str != null) {
            try {
                byte[] b = Base64.getDecoder().decode(str);
                result = new String(b, StandardCharsets.UTF_8);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return result;
    }
}

