/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.session.config;

import com.sobercoding.loopauth.session.model.TokenAccessMode;
import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;

public class SessionConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String tokenName = "LoopAuth";
    private long timeOut = 86400000L;
    private Boolean isMutualism = false;
    private Boolean isExclusion = false;
    private Boolean isTokenPersistence = false;
    private int maxLoginCount = 1;
    private Boolean isRenew = true;
    private ConcurrentSkipListSet<TokenAccessMode> accessModes = new ConcurrentSkipListSet<TokenAccessMode>(Collections.singletonList(TokenAccessMode.COOKIE));
    private String secretKey = "LoopAuth";
    private String tokenPersistencePrefix = "LoopAuthToken";
    private String loginIdPersistencePrefix = "LoopAuthLoginId";

    public Boolean getTokenPersistence() {
        return this.isTokenPersistence;
    }

    public SessionConfig setTokenPersistence(Boolean tokenPersistence) {
        this.isTokenPersistence = tokenPersistence;
        return this;
    }

    public String getTokenPersistencePrefix() {
        return this.tokenPersistencePrefix;
    }

    public SessionConfig setTokenPersistencePrefix(String tokenPersistencePrefix) {
        this.tokenPersistencePrefix = tokenPersistencePrefix;
        return this;
    }

    public String getLoginIdPersistencePrefix() {
        return this.loginIdPersistencePrefix;
    }

    public SessionConfig setLoginIdPersistencePrefix(String loginIdPersistencePrefix) {
        this.loginIdPersistencePrefix = loginIdPersistencePrefix;
        return this;
    }

    public SessionConfig setTokenName(String tokenName) {
        this.tokenName = tokenName;
        return this;
    }

    public SessionConfig setTimeOut(long timeOut) {
        this.timeOut = timeOut * 1000L;
        return this;
    }

    public SessionConfig setMutualism(Boolean mutualism) {
        this.isMutualism = mutualism;
        return this;
    }

    public SessionConfig setExclusion(Boolean exclusion) {
        this.isExclusion = exclusion;
        return this;
    }

    public SessionConfig setRenew(Boolean renew) {
        this.isRenew = renew;
        return this;
    }

    public SessionConfig setMaxLoginCount(int maxLoginCount) {
        this.maxLoginCount = maxLoginCount;
        return this;
    }

    public SessionConfig setAccessModes(ConcurrentSkipListSet<TokenAccessMode> accessModes) {
        this.accessModes = accessModes;
        return this;
    }

    public SessionConfig setSecretKey(String secretKey) {
        this.secretKey = secretKey;
        return this;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public Boolean getMutualism() {
        return this.isMutualism;
    }

    public Boolean getExclusion() {
        return this.isExclusion;
    }

    public Boolean getRenew() {
        return this.isRenew;
    }

    public int getMaxLoginCount() {
        return this.maxLoginCount;
    }

    public Set<TokenAccessMode> getAccessModes() {
        return this.accessModes;
    }

    public String toString() {
        return "LoopAuthConfig{tokenName='" + this.tokenName + '\'' + ", timeOut=" + this.timeOut + ", isMutualism=" + this.isMutualism + ", isExclusion=" + this.isExclusion + ", isTokenPersistence=" + this.isTokenPersistence + ", maxLoginCount=" + this.maxLoginCount + ", isRenew=" + this.isRenew + ", accessModes=" + this.accessModes + ", secretKey='" + this.secretKey + '\'' + ", tokenPersistencePrefix='" + this.tokenPersistencePrefix + '\'' + ", loginIdPersistencePrefix='" + this.loginIdPersistencePrefix + '\'' + '}';
    }
}

