/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.session.context;

import com.sobercoding.loopauth.exception.LoopAuthExceptionEnum;
import com.sobercoding.loopauth.exception.LoopAuthParamException;
import com.sobercoding.loopauth.session.SessionStrategy;
import com.sobercoding.loopauth.util.LoopAuthUtil;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LoopAuthCookie {
    private String name;
    private String value;
    private long maxAge = SessionStrategy.getSessionConfig().getTimeOut() / 1000L;
    private String domain = SessionStrategy.getCookieConfig().getDomain();
    private String path = SessionStrategy.getCookieConfig().getPath();
    private boolean httpOnly = SessionStrategy.getCookieConfig().isHttpOnly();
    private boolean secure = SessionStrategy.getCookieConfig().isSecure();
    private String sameSite = SessionStrategy.getCookieConfig().getSameSite();

    public String getName() {
        return this.name;
    }

    public LoopAuthCookie setName(String name) {
        this.name = name;
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public LoopAuthCookie setValue(String value) {
        this.value = value;
        return this;
    }

    public String getDomain() {
        return this.domain;
    }

    public LoopAuthCookie setDomain(String domain) {
        this.domain = domain;
        return this;
    }

    public long getMaxAge() {
        return this.maxAge;
    }

    public LoopAuthCookie setMaxAge(long maxAge) {
        this.maxAge = maxAge;
        return this;
    }

    public String getPath() {
        return this.path;
    }

    public LoopAuthCookie setPath(String path) {
        this.path = path;
        return this;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public LoopAuthCookie setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
        return this;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public LoopAuthCookie setSecure(boolean secure) {
        this.secure = secure;
        return this;
    }

    public String getSameSite() {
        return this.sameSite;
    }

    public LoopAuthCookie setSameSite(String sameSite) {
        this.sameSite = sameSite;
        return this;
    }

    public String toCookieString() {
        LoopAuthParamException.isNotEmpty((Object)this.name, (LoopAuthExceptionEnum)LoopAuthExceptionEnum.PARAM_IS_NULL, (String)"Cookie Name");
        LoopAuthParamException.isNotEmpty((Object)this.value, (LoopAuthExceptionEnum)LoopAuthExceptionEnum.PARAM_IS_NULL, (String)"Cookie Value");
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.name).append("=").append(this.value);
        if (SessionStrategy.getCookieConfig().isRemember() && this.maxAge >= 0L) {
            stringBuilder.append("; Max-Age=").append(this.maxAge);
            String expires = this.maxAge == 0L ? Instant.EPOCH.atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME) : Instant.ofEpochMilli(System.currentTimeMillis()).plusSeconds(this.maxAge).atOffset(ZoneOffset.UTC).format(DateTimeFormatter.RFC_1123_DATE_TIME);
            stringBuilder.append("; Expires=").append(expires);
        }
        if (LoopAuthUtil.isNotEmpty((Object)this.domain)) {
            stringBuilder.append("; Domain=").append(this.domain);
        }
        if (LoopAuthUtil.isNotEmpty((Object)this.path)) {
            stringBuilder.append("; Path=").append(this.path);
        }
        if (this.secure) {
            stringBuilder.append("; Secure");
        }
        if (this.httpOnly) {
            stringBuilder.append("; HttpOnly");
        }
        if (LoopAuthUtil.isNotEmpty((Object)this.sameSite)) {
            stringBuilder.append("; sameSite=").append(this.sameSite);
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return "LoopAuthCookie{name='" + this.name + '\'' + ", value='" + this.value + '\'' + ", domain='" + this.domain + '\'' + ", maxAge=" + this.maxAge + ", path='" + this.path + '\'' + ", httpOnly=" + this.httpOnly + ", secure=" + this.secure + ", sameSite='" + this.sameSite + '\'' + '}';
    }
}

