/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.session.dao;

import com.sobercoding.loopauth.session.dao.LoopAuthDao;
import com.sobercoding.loopauth.util.LoopAuthUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoopAuthDaoImpl
implements LoopAuthDao {
    public Map<String, Object> dataPersistenceMap = new ConcurrentHashMap<String, Object>();
    public Map<String, String> expirationTime = new ConcurrentHashMap<String, String>();

    @Override
    public Object get(String key) {
        String expirationTime = this.expirationTime.get(key);
        if (LoopAuthUtil.isEmpty((Object)expirationTime)) {
            return null;
        }
        long nowTime = System.currentTimeMillis();
        if (nowTime < Long.parseLong(expirationTime)) {
            return this.dataPersistenceMap.get(key);
        }
        this.remove(key);
        return null;
    }

    @Override
    public boolean containsKey(String key) {
        long expirationTime = Long.parseLong(this.expirationTime.get(key));
        if (LoopAuthUtil.isEmpty((Object)expirationTime)) {
            return false;
        }
        long nowTime = System.currentTimeMillis();
        if (nowTime < expirationTime) {
            return this.dataPersistenceMap.containsKey(key);
        }
        this.remove(key);
        return false;
    }

    @Override
    public void set(String key, Object value, long expirationTime) {
        this.dataPersistenceMap.put(key, value);
        this.expirationTime.put(key, String.valueOf(System.currentTimeMillis() + expirationTime));
    }

    @Override
    public void remove(String key) {
        this.dataPersistenceMap.remove(key);
        this.expirationTime.remove(key);
    }
}

