/*
 * Decompiled with CFR 0.152.
 */
package com.sobercoding.loopauth.session.model;

import com.sobercoding.loopauth.session.SessionStrategy;
import com.sobercoding.loopauth.session.model.TokenModel;
import com.sobercoding.loopauth.util.LoopAuthUtil;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class UserSession
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String loginId;
    private Set<TokenModel> tokens = new HashSet<TokenModel>();
    private TokenModel tokenModelNow;

    public TokenModel getTokenModelNow() {
        if (LoopAuthUtil.isNotEmpty((Object)this.tokenModelNow)) {
            this.tokenModelNow = this.tokens.stream().filter(item -> this.tokenModelNow.getValue().equals(item.getValue())).findAny().orElse(this.tokenModelNow);
        }
        return this.tokenModelNow;
    }

    public UserSession setTokenModelNow(TokenModel tokenModelNow) {
        if (SessionStrategy.getSessionConfig().getTokenPersistence().booleanValue()) {
            this.setLoginId(this.gainLongId(tokenModelNow));
        } else {
            this.setLoginId(tokenModelNow.getLoginId());
        }
        this.tokenModelNow = tokenModelNow;
        return this;
    }

    public UserSession setLoginId(String loginId) {
        this.loginId = loginId;
        return this;
    }

    public String getLoginId() {
        return this.loginId;
    }

    public Set<TokenModel> getTokens() {
        return this.tokens;
    }

    public UserSession setToken(TokenModel tokenModel) {
        Set removeTokenModels = (Set)SessionStrategy.loginRulesMatching.exe(this.tokens, (Object)tokenModel);
        removeTokenModels.forEach(this::removeTokenModel);
        this.depositTokenModel(tokenModel);
        this.tokens.add(tokenModel);
        this.depositUserSession();
        return this;
    }

    public UserSession gainUserSession() {
        this.tokens = (Set)SessionStrategy.getLoopAuthDao().get(SessionStrategy.getSessionConfig().getLoginIdPersistencePrefix() + ":" + this.loginId);
        if (Optional.ofNullable(this.tokens).isPresent()) {
            long timeMillis = System.currentTimeMillis();
            this.tokens = this.tokens.stream().filter(item -> item.getCreateTime() + item.getTimeOut() > timeMillis).collect(Collectors.toSet());
        } else {
            this.tokens = new HashSet<TokenModel>();
        }
        this.getTokenModelNow();
        return this;
    }

    public void remove() {
        SessionStrategy.getLoopAuthDao().remove(SessionStrategy.getSessionConfig().getLoginIdPersistencePrefix() + ":" + this.loginId);
        this.getTokens().forEach(this::removeTokenModel);
        this.loginId = null;
        this.tokens = null;
    }

    public UserSession removeToken(String ... tokenModelValues) {
        if (tokenModelValues.length <= 0) {
            return this;
        }
        HashSet<String> tokenSet = new HashSet<String>(Arrays.asList(tokenModelValues));
        this.tokens.stream().filter(tokenModel -> tokenSet.contains(tokenModel.getValue())).forEach(this::removeTokenModel);
        this.tokens = this.tokens.stream().filter(tokenModel -> !tokenSet.contains(tokenModel.getValue())).collect(Collectors.toSet());
        this.depositUserSession();
        return this;
    }

    private void depositUserSession() {
        if (this.tokens.size() <= 0) {
            this.remove();
        } else {
            AtomicLong maxExpirationTime = new AtomicLong(0L);
            this.tokens.forEach(tokenModel -> {
                long expirationTime = tokenModel.getTimeOut() + tokenModel.getCreateTime() - System.currentTimeMillis();
                if (expirationTime > maxExpirationTime.get()) {
                    maxExpirationTime.set(expirationTime);
                }
            });
            SessionStrategy.getLoopAuthDao().set(SessionStrategy.getSessionConfig().getLoginIdPersistencePrefix() + ":" + this.loginId, this.tokens, maxExpirationTime.get());
        }
    }

    private void depositTokenModel(TokenModel tokenModel) {
        SessionStrategy.getLoopAuthDao().set(SessionStrategy.getSessionConfig().getTokenPersistencePrefix() + ":" + tokenModel.getValue(), this.loginId, tokenModel.getTimeOut());
    }

    private void removeTokenModel(TokenModel tokenModel) {
        SessionStrategy.getLoopAuthDao().remove(SessionStrategy.getSessionConfig().getTokenPersistencePrefix() + ":" + tokenModel.getValue());
    }

    private String gainLongId(TokenModel tokenModel) {
        return (String)SessionStrategy.getLoopAuthDao().get(SessionStrategy.getSessionConfig().getTokenPersistencePrefix() + ":" + tokenModel.getValue());
    }

    public String toString() {
        return "UserSession{loginId='" + this.loginId + '\'' + ", tokens=" + this.tokens + ", tokenModelNow=" + this.tokenModelNow + '}';
    }
}

