/*
 * Decompiled with CFR 0.152.
 */
package com.solidfire.jsvcgen.serialization;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.Duration;

public class DurationAdapter
extends TypeAdapter<Duration> {
    private static final Pattern inputRegex = Pattern.compile("(-?)(?:(?:([0-9]+):)?([0-9]+):)?([0-9]+)(?:\\.([0-9]+))?");

    public static Class<Duration> serializingClass() {
        return Duration.class;
    }

    public Duration read(JsonReader jsonReader) throws IOException {
        String string = jsonReader.nextString();
        Matcher matcher = inputRegex.matcher(string);
        if (matcher.matches()) {
            String string2;
            long l = matcher.group(2) != null ? Long.parseLong(matcher.group(2)) : 0L;
            long l2 = matcher.group(3) != null ? Long.parseLong(matcher.group(3)) : 0L;
            long l3 = matcher.group(4) != null ? Long.parseLong(matcher.group(4)) : 0L;
            String string3 = string2 = matcher.group(5) != null ? matcher.group(5) : "000";
            while (string2.length() < 3) {
                string2 = string2 + '0';
            }
            string2 = string2.substring(0, 3);
            long l4 = Long.parseLong(string2);
            long l5 = ((l * 60L + l2) * 60L + l3) * 1000L + l4;
            if (matcher.group(1).equals("-")) {
                l5 = -l5;
            }
            return Duration.millis((long)l5);
        }
        throw new RuntimeException("Could not extract duration from \"" + string + "\"");
    }

    public void write(JsonWriter jsonWriter, Duration duration) throws IOException {
        String string;
        long l = duration.getMillis();
        String string2 = string = l < 0L ? "-" : "";
        if (l < 0L) {
            l = -l;
        }
        long l2 = l % 1000L;
        long l3 = (l /= 1000L) % 60L;
        long l4 = (l /= 60L) % 60L;
        long l5 = l /= 60L;
        jsonWriter.value(String.format("%s%02d:%02d:%02d.%03d000", string, l5, l4, l3, l2));
    }
}

