/*
 * Decompiled with CFR 0.152.
 */
package com.sovren;

import com.sovren.ApiEndpoints;
import com.sovren.DataCenter;
import com.sovren.SovrenUIClient;
import com.sovren.exceptions.SovrenException;
import com.sovren.exceptions.SovrenGeocodeJobException;
import com.sovren.exceptions.SovrenGeocodeResumeException;
import com.sovren.exceptions.SovrenIndexJobException;
import com.sovren.exceptions.SovrenIndexResumeException;
import com.sovren.http.HttpResponse;
import com.sovren.models.GeoCoordinates;
import com.sovren.models.api.ApiResponse;
import com.sovren.models.api.ApiResponseInfoLite;
import com.sovren.models.api.account.GetAccountInfoResponse;
import com.sovren.models.api.bimetricscoring.BimetricScoreJobRequest;
import com.sovren.models.api.bimetricscoring.BimetricScoreResponse;
import com.sovren.models.api.bimetricscoring.BimetricScoreResumeRequest;
import com.sovren.models.api.bimetricscoring.IParsedDocWithId;
import com.sovren.models.api.bimetricscoring.ParsedJobWithId;
import com.sovren.models.api.bimetricscoring.ParsedResumeWithId;
import com.sovren.models.api.geocoding.Address;
import com.sovren.models.api.geocoding.GeocodeAndIndexJobRequest;
import com.sovren.models.api.geocoding.GeocodeAndIndexJobResponse;
import com.sovren.models.api.geocoding.GeocodeAndIndexJobResponseValue;
import com.sovren.models.api.geocoding.GeocodeAndIndexResumeRequest;
import com.sovren.models.api.geocoding.GeocodeAndIndexResumeResponse;
import com.sovren.models.api.geocoding.GeocodeAndIndexResumeResponseValue;
import com.sovren.models.api.geocoding.GeocodeCredentials;
import com.sovren.models.api.geocoding.GeocodeJobRequest;
import com.sovren.models.api.geocoding.GeocodeJobResponse;
import com.sovren.models.api.geocoding.GeocodeOptionsBase;
import com.sovren.models.api.geocoding.GeocodeProvider;
import com.sovren.models.api.geocoding.GeocodeResumeRequest;
import com.sovren.models.api.geocoding.GeocodeResumeResponse;
import com.sovren.models.api.indexes.CreateIndexRequest;
import com.sovren.models.api.indexes.CreateIndexResponse;
import com.sovren.models.api.indexes.DeleteDocumentResponse;
import com.sovren.models.api.indexes.DeleteIndexResponse;
import com.sovren.models.api.indexes.DeleteMultipleDocumentsResponse;
import com.sovren.models.api.indexes.GetAllIndexesResponse;
import com.sovren.models.api.indexes.GetJobResponse;
import com.sovren.models.api.indexes.GetResumeResponse;
import com.sovren.models.api.indexes.IndexDocumentResponse;
import com.sovren.models.api.indexes.IndexJobInfo;
import com.sovren.models.api.indexes.IndexJobRequest;
import com.sovren.models.api.indexes.IndexMultipleDocumentsResponse;
import com.sovren.models.api.indexes.IndexMultipleJobsRequest;
import com.sovren.models.api.indexes.IndexMultipleResumesRequest;
import com.sovren.models.api.indexes.IndexResumeInfo;
import com.sovren.models.api.indexes.IndexResumeRequest;
import com.sovren.models.api.indexes.IndexSingleDocumentInfo;
import com.sovren.models.api.indexes.UpdateUserDefinedTagsRequest;
import com.sovren.models.api.indexes.UpdateUserDefinedTagsResponse;
import com.sovren.models.api.indexes.UserDefinedTagsMethod;
import com.sovren.models.api.matching.CategoryWeights;
import com.sovren.models.api.matching.MatchJobRequest;
import com.sovren.models.api.matching.MatchResponse;
import com.sovren.models.api.matching.MatchResumeRequest;
import com.sovren.models.api.matching.SearchRequest;
import com.sovren.models.api.matching.SearchResponse;
import com.sovren.models.api.matching.request.FilterCriteria;
import com.sovren.models.api.matching.request.MatchByDocumentIdOptions;
import com.sovren.models.api.matching.request.PaginationSettings;
import com.sovren.models.api.matching.request.SearchMatchSettings;
import com.sovren.models.api.matching.ui.GenerateUIResponse;
import com.sovren.models.api.matching.ui.request.MatchUISettings;
import com.sovren.models.api.matching.ui.request.UIBimetricScoreJobRequest;
import com.sovren.models.api.matching.ui.request.UIBimetricScoreResumeRequest;
import com.sovren.models.api.matching.ui.request.UIMatchByDocumentIdOptions;
import com.sovren.models.api.matching.ui.request.UIMatchJobRequest;
import com.sovren.models.api.matching.ui.request.UIMatchResumeRequest;
import com.sovren.models.api.matching.ui.request.UISearchRequest;
import com.sovren.models.api.parsing.ParseJobResponse;
import com.sovren.models.api.parsing.ParseJobResponseValue;
import com.sovren.models.api.parsing.ParseRequest;
import com.sovren.models.api.parsing.ParseResumeResponse;
import com.sovren.models.api.parsing.ParseResumeResponseValue;
import com.sovren.models.job.ParsedJob;
import com.sovren.models.matching.IndexType;
import com.sovren.models.resume.ParsedResume;
import com.sovren.utilities.SovrenJsonSerializer;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okio.Buffer;
import okio.BufferedSink;

public class SovrenClient {
    private ApiEndpoints _endpoints;
    private OkHttpClient _client;
    private static final MediaType JSON = MediaType.get((String)"application/json; charset=utf-8");
    private static final String _sdkVersion = SovrenClient.class.getPackage().getImplementationVersion();
    public boolean ShowFullRequestBodyInExceptions = false;

    public SovrenClient(String accountId, String serviceKey, DataCenter dataCenter) {
        this(accountId, serviceKey, dataCenter, null);
    }

    public SovrenClient(final String accountId, final String serviceKey, DataCenter dataCenter, List<String> trackingTags) {
        String trackingTagsHeaderValue;
        if (accountId == null || accountId.length() == 0) {
            throw new IllegalArgumentException("'accountId' must have a valid value");
        }
        if (serviceKey == null || serviceKey.length() == 0) {
            throw new IllegalArgumentException("'serviceKey' must have a valid value");
        }
        if (dataCenter == null) {
            throw new IllegalArgumentException("'dataCenter' must not be null");
        }
        this._endpoints = new ApiEndpoints(dataCenter);
        if (trackingTags != null && trackingTags.size() > 0) {
            trackingTagsHeaderValue = String.join((CharSequence)", ", trackingTags);
            if (trackingTagsHeaderValue.length() >= 75) {
                throw new IllegalArgumentException("'trackingTags' has too many values or the values are too long");
            }
        } else {
            trackingTagsHeaderValue = null;
        }
        this._client = new OkHttpClient.Builder().addInterceptor(new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder builder = original.newBuilder();
                builder.header("Sovren-AccountId", accountId);
                builder.header("Sovren-ServiceKey", serviceKey);
                builder.header("User-Agent", "sovren-java-" + _sdkVersion);
                if (trackingTagsHeaderValue != null && !trackingTagsHeaderValue.isEmpty()) {
                    builder.header("Sovren-TrackingTag", trackingTagsHeaderValue);
                }
                Request request = builder.build();
                return chain.proceed(request);
            }
        }).build();
    }

    private RequestBody createJsonBody(Object body) {
        return RequestBody.create((MediaType)JSON, (String)SovrenJsonSerializer.serialize(body));
    }

    private <T extends ApiResponse<?>> HttpResponse<T> executeRequest(Request apiRequest, Class<T> classOfT, String requestBody) throws SovrenException {
        ApiResponseInfoLite errorInfo = new ApiResponseInfoLite();
        errorInfo.Code = "Error";
        errorInfo.Message = "Unknown API error.";
        HttpResponse<T> apiResponse = null;
        Response rawResponse = null;
        try {
            rawResponse = this._client.newCall(apiRequest).execute();
            apiResponse = new HttpResponse<T>(rawResponse, classOfT);
            if (rawResponse != null && rawResponse.code() == 413) {
                errorInfo.Message = "Request body was too large.";
                throw new SovrenException(requestBody, rawResponse, errorInfo, null);
            }
            if (rawResponse != null && apiResponse.getData() == null && rawResponse.code() != 200) {
                errorInfo.Message = rawResponse.code() + " - " + rawResponse.message();
            }
            if (apiResponse == null || apiResponse.getData() == null) {
                throw new SovrenException(requestBody, rawResponse, errorInfo, null);
            }
        }
        catch (IOException e) {
            errorInfo.Message = e.getMessage();
            SovrenException newEx = new SovrenException(requestBody, rawResponse, errorInfo, null);
            newEx.InnerException = e;
            throw newEx;
        }
        if (!rawResponse.isSuccessful()) {
            throw new SovrenException(requestBody, rawResponse, ((ApiResponse)apiResponse.getData()).Info);
        }
        return apiResponse;
    }

    private GenerateUIResponse executeUIRequest(Request apiRequest, String requestBody) throws SovrenException {
        ApiResponseInfoLite errorInfo = new ApiResponseInfoLite();
        errorInfo.Code = "Error";
        errorInfo.Message = "Unknown API error.";
        GenerateUIResponse apiResponse = null;
        Response rawResponse = null;
        String transId = "matchui-" + Instant.now().toString();
        try {
            rawResponse = this._client.newCall(apiRequest).execute();
            if (!rawResponse.isSuccessful()) {
                errorInfo.Message = rawResponse.body().string();
                throw new SovrenException(requestBody, rawResponse, errorInfo, transId);
            }
            String responseBodyStr = rawResponse.body().string();
            apiResponse = SovrenJsonSerializer.deserialize(responseBodyStr, GenerateUIResponse.class);
            if (apiResponse == null) {
                throw new SovrenException(requestBody, rawResponse, errorInfo, transId);
            }
        }
        catch (IOException e) {
            errorInfo.Message = e.getMessage();
            SovrenException newEx = new SovrenException(requestBody, rawResponse, errorInfo, transId);
            newEx.InnerException = e;
            throw newEx;
        }
        return apiResponse;
    }

    private String getBodyIfDebug(Request request) {
        if (this.ShowFullRequestBodyInExceptions) {
            try {
                Request copy = request.newBuilder().build();
                Buffer buffer = new Buffer();
                copy.body().writeTo((BufferedSink)buffer);
                return buffer.readUtf8();
            }
            catch (IOException e) {
                return null;
            }
        }
        return null;
    }

    public GetAccountInfoResponse getAccountInfo() throws SovrenException {
        Request apiRequest = new Request.Builder().url(this._endpoints.account()).build();
        HttpResponse<GetAccountInfoResponse> response = this.executeRequest(apiRequest, GetAccountInfoResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public ParseResumeResponse parseResume(ParseRequest request) throws SovrenException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.parseResume()).post(body).build();
        HttpResponse<ParseResumeResponse> response = this.executeRequest(apiRequest, ParseResumeResponse.class, this.getBodyIfDebug(apiRequest));
        if (((ParseResumeResponseValue)response.getData().Value).ParsingResponse != null && !((ParseResumeResponseValue)response.getData().Value).ParsingResponse.isSuccess()) {
            throw new SovrenException(this.getBodyIfDebug(apiRequest), response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).ParsingResponse, response.getData().Info.TransactionId);
        }
        if (((ParseResumeResponseValue)response.getData().Value).GeocodeResponse != null && !((ParseResumeResponseValue)response.getData().Value).GeocodeResponse.isSuccess()) {
            throw new SovrenGeocodeResumeException(response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).GeocodeResponse, response.getData().Info.TransactionId, response.getData());
        }
        if (((ParseResumeResponseValue)response.getData().Value).IndexingResponse != null && !((ParseResumeResponseValue)response.getData().Value).IndexingResponse.isSuccess()) {
            throw new SovrenIndexResumeException(response.getResponse(), ((ParseResumeResponseValue)response.getData().Value).IndexingResponse, response.getData().Info.TransactionId, response.getData());
        }
        return response.getData();
    }

    public ParseJobResponse parseJob(ParseRequest request) throws SovrenException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.parseJob()).post(body).build();
        HttpResponse<ParseJobResponse> response = this.executeRequest(apiRequest, ParseJobResponse.class, this.getBodyIfDebug(apiRequest));
        if (((ParseJobResponseValue)response.getData().Value).ParsingResponse != null && !((ParseJobResponseValue)response.getData().Value).ParsingResponse.isSuccess()) {
            throw new SovrenException(this.getBodyIfDebug(apiRequest), response.getResponse(), ((ParseJobResponseValue)response.getData().Value).ParsingResponse, response.getData().Info.TransactionId);
        }
        if (((ParseJobResponseValue)response.getData().Value).GeocodeResponse != null && !((ParseJobResponseValue)response.getData().Value).GeocodeResponse.isSuccess()) {
            throw new SovrenGeocodeJobException(response.getResponse(), ((ParseJobResponseValue)response.getData().Value).GeocodeResponse, response.getData().Info.TransactionId, response.getData());
        }
        if (((ParseJobResponseValue)response.getData().Value).IndexingResponse != null && !((ParseJobResponseValue)response.getData().Value).IndexingResponse.isSuccess()) {
            throw new SovrenIndexJobException(response.getResponse(), ((ParseJobResponseValue)response.getData().Value).IndexingResponse, response.getData().Info.TransactionId, response.getData());
        }
        return response.getData();
    }

    public CreateIndexResponse createIndex(IndexType type, String indexId) throws SovrenException {
        CreateIndexRequest request = new CreateIndexRequest();
        request.IndexType = type;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.index(indexId)).post(body).build();
        HttpResponse<CreateIndexResponse> response = this.executeRequest(apiRequest, CreateIndexResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetAllIndexesResponse getAllIndexes() throws SovrenException {
        Request apiRequest = new Request.Builder().url(this._endpoints.allIndexes()).build();
        HttpResponse<GetAllIndexesResponse> response = this.executeRequest(apiRequest, GetAllIndexesResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteIndexResponse deleteIndex(String indexId) throws SovrenException {
        Request apiRequest = new Request.Builder().url(this._endpoints.index(indexId)).delete().build();
        HttpResponse<DeleteIndexResponse> response = this.executeRequest(apiRequest, DeleteIndexResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexDocumentResponse indexDocument(ParsedResume resume, String indexId, String documentId, List<String> userDefinedTags) throws SovrenException {
        IndexResumeRequest request = new IndexResumeRequest();
        request.ResumeData = resume;
        request.UserDefinedTags = userDefinedTags;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).post(body).build();
        HttpResponse<IndexDocumentResponse> response = this.executeRequest(apiRequest, IndexDocumentResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexDocumentResponse indexDocument(ParsedJob job, String indexId, String documentId, List<String> userDefinedTags) throws SovrenException {
        IndexJobRequest request = new IndexJobRequest();
        request.JobData = job;
        request.UserDefinedTags = userDefinedTags;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).post(body).build();
        HttpResponse<IndexDocumentResponse> response = this.executeRequest(apiRequest, IndexDocumentResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexMultipleDocumentsResponse indexMultipleResumes(List<IndexResumeInfo> resumes, String indexId) throws SovrenException {
        IndexMultipleResumesRequest request = new IndexMultipleResumesRequest();
        request.Resumes = resumes;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleResumes(indexId)).post(body).build();
        HttpResponse<IndexMultipleDocumentsResponse> response = this.executeRequest(apiRequest, IndexMultipleDocumentsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public IndexMultipleDocumentsResponse indexMultipleJobs(List<IndexJobInfo> jobs, String indexId) throws SovrenException {
        IndexMultipleJobsRequest request = new IndexMultipleJobsRequest();
        request.Jobs = jobs;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleJobs(indexId)).post(body).build();
        HttpResponse<IndexMultipleDocumentsResponse> response = this.executeRequest(apiRequest, IndexMultipleDocumentsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteDocumentResponse deleteDocument(String indexId, String documentId) throws SovrenException {
        Request apiRequest = new Request.Builder().url(this._endpoints.document(indexId, documentId)).delete().build();
        HttpResponse<DeleteDocumentResponse> response = this.executeRequest(apiRequest, DeleteDocumentResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public DeleteMultipleDocumentsResponse deleteMultipleDocuments(String indexId, List<String> documentIds) throws SovrenException {
        RequestBody requestBody = this.createJsonBody(documentIds);
        Request apiRequest = new Request.Builder().url(this._endpoints.multipleDocuments(indexId)).delete(requestBody).build();
        HttpResponse<DeleteMultipleDocumentsResponse> response = this.executeRequest(apiRequest, DeleteMultipleDocumentsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetResumeResponse getResume(String indexId, String documentId) throws SovrenException {
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).build();
        HttpResponse<GetResumeResponse> response = this.executeRequest(apiRequest, GetResumeResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GetJobResponse getJob(String indexId, String documentId) throws SovrenException {
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).build();
        HttpResponse<GetJobResponse> response = this.executeRequest(apiRequest, GetJobResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public UpdateUserDefinedTagsResponse updateResumeUserDefinedTags(String indexId, String documentId, List<String> userDefinedTags, UserDefinedTagsMethod method) throws SovrenException {
        UpdateUserDefinedTagsRequest request = new UpdateUserDefinedTagsRequest();
        request.UserDefinedTags = userDefinedTags;
        request.Method = method;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.resume(indexId, documentId)).patch(body).build();
        HttpResponse<UpdateUserDefinedTagsResponse> response = this.executeRequest(apiRequest, UpdateUserDefinedTagsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public UpdateUserDefinedTagsResponse updateJobUserDefinedTags(String indexId, String documentId, List<String> userDefinedTags, UserDefinedTagsMethod method) throws SovrenException {
        UpdateUserDefinedTagsRequest request = new UpdateUserDefinedTagsRequest();
        request.UserDefinedTags = userDefinedTags;
        request.Method = method;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.job(indexId, documentId)).patch(body).build();
        HttpResponse<UpdateUserDefinedTagsResponse> response = this.executeRequest(apiRequest, UpdateUserDefinedTagsResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public MatchResponse match(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws SovrenException {
        MatchResumeRequest request = this.createRequest(resume, indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchResume(false)).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchResumeRequest createRequest(ParsedResume resume, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchResumeRequest request = new MatchResumeRequest();
        request.ResumeData = resume;
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    public MatchResponse match(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws SovrenException {
        MatchJobRequest request = this.createRequest(job, indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchJob(false)).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchJobRequest createRequest(ParsedJob job, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchJobRequest request = new MatchJobRequest();
        request.JobData = job;
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    public MatchResponse match(String indexId, String documentId, List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) throws SovrenException {
        MatchByDocumentIdOptions request = this.createRequest(indexesToQuery, preferredWeights, filters, settings, numResults);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchDocId(indexId, documentId, false)).post(body).build();
        HttpResponse<MatchResponse> response = this.executeRequest(apiRequest, MatchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    MatchByDocumentIdOptions createRequest(List<String> indexesToQuery, CategoryWeights preferredWeights, FilterCriteria filters, SearchMatchSettings settings, int numResults) {
        MatchByDocumentIdOptions request = new MatchByDocumentIdOptions();
        request.IndexIdsToSearchInto = indexesToQuery;
        request.PreferredCategoryWeights = preferredWeights;
        request.FilterCriteria = filters;
        request.Settings = settings;
        request.Take = numResults;
        return request;
    }

    GenerateUIResponse uiMatch(String indexId, String documentId, UIMatchByDocumentIdOptions options) throws SovrenException {
        RequestBody body = this.createJsonBody(options);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchDocId(indexId, documentId, true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    GenerateUIResponse uiMatch(UIMatchResumeRequest request) throws SovrenException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchResume(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    GenerateUIResponse uiMatch(UIMatchJobRequest request) throws SovrenException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.matchJob(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    public SearchResponse search(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) throws SovrenException {
        SearchRequest request = this.createRequest(indexesToQuery, query, settings, pagination);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.search(false)).post(body).build();
        HttpResponse<SearchResponse> response = this.executeRequest(apiRequest, SearchResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    SearchRequest createRequest(List<String> indexesToQuery, FilterCriteria query, SearchMatchSettings settings, PaginationSettings pagination) {
        SearchRequest request = new SearchRequest();
        request.IndexIdsToSearchInto = indexesToQuery;
        request.FilterCriteria = query;
        request.Settings = settings;
        request.PaginationSettings = pagination;
        return request;
    }

    GenerateUIResponse uiSearch(UISearchRequest request) throws SovrenException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.search(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    public <TTarget extends IParsedDocWithId> BimetricScoreResponse bimetricScore(ParsedResumeWithId sourceResume, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws SovrenException {
        BimetricScoreResumeRequest request = this.createRequest(sourceResume, targetDocuments, preferredWeights, settings);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreResume(false)).post(body).build();
        HttpResponse<BimetricScoreResponse> response = this.executeRequest(apiRequest, BimetricScoreResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    <TTarget extends IParsedDocWithId> BimetricScoreResumeRequest createRequest(ParsedResumeWithId sourceResume, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) {
        BimetricScoreResumeRequest request = new BimetricScoreResumeRequest();
        request.PreferredCategoryWeights = preferredWeights;
        request.Settings = settings;
        request.SourceResume = sourceResume;
        if (targetDocuments.size() > 0) {
            if (targetDocuments.get(0) instanceof ParsedResumeWithId) {
                request.TargetResumes = targetDocuments;
            } else {
                request.TargetJobs = targetDocuments;
            }
        }
        return request;
    }

    public <TTarget extends IParsedDocWithId> BimetricScoreResponse bimetricScore(ParsedJobWithId sourceJob, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) throws SovrenException {
        BimetricScoreJobRequest request = this.createRequest(sourceJob, targetDocuments, preferredWeights, settings);
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreJob(false)).post(body).build();
        HttpResponse<BimetricScoreResponse> response = this.executeRequest(apiRequest, BimetricScoreResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    <TTarget extends IParsedDocWithId> BimetricScoreJobRequest createRequest(ParsedJobWithId sourceJob, List<TTarget> targetDocuments, CategoryWeights preferredWeights, SearchMatchSettings settings) {
        BimetricScoreJobRequest request = new BimetricScoreJobRequest();
        request.PreferredCategoryWeights = preferredWeights;
        request.Settings = settings;
        request.SourceJob = sourceJob;
        if (targetDocuments.size() > 0) {
            if (targetDocuments.get(0) instanceof ParsedResumeWithId) {
                request.TargetResumes = targetDocuments;
            } else {
                request.TargetJobs = targetDocuments;
            }
        }
        return request;
    }

    GenerateUIResponse uiBimetricScore(UIBimetricScoreResumeRequest request) throws SovrenException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreResume(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    GenerateUIResponse uiBimetricScore(UIBimetricScoreJobRequest request) throws SovrenException {
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.bimetricScoreJob(true)).post(body).build();
        GenerateUIResponse response = this.executeUIRequest(apiRequest, this.getBodyIfDebug(apiRequest));
        return response;
    }

    private GeocodeResumeResponse internalGeocode(ParsedResume resume, GeocodeCredentials geocodeCredentials, Address address) throws SovrenException {
        GeocodeResumeRequest request = new GeocodeResumeRequest();
        request.ResumeData = resume;
        request.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        request.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        request.PostalAddress = address;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeResume()).post(body).build();
        HttpResponse<GeocodeResumeResponse> response = this.executeRequest(apiRequest, GeocodeResumeResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    private GeocodeJobResponse internalGeocode(ParsedJob job, GeocodeCredentials geocodeCredentials, Address address) throws SovrenException {
        GeocodeJobRequest request = new GeocodeJobRequest();
        request.JobData = job;
        request.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        request.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        request.PostalAddress = address;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeJob()).post(body).build();
        HttpResponse<GeocodeJobResponse> response = this.executeRequest(apiRequest, GeocodeJobResponse.class, this.getBodyIfDebug(apiRequest));
        return response.getData();
    }

    public GeocodeResumeResponse geocode(ParsedResume resume, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocode(resume, geocodeCredentials, null);
    }

    public GeocodeResumeResponse geocode(ParsedResume resume, Address address, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocode(resume, geocodeCredentials, address);
    }

    public GeocodeJobResponse geocode(ParsedJob job, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocode(job, geocodeCredentials, null);
    }

    public GeocodeJobResponse geocode(ParsedJob job, Address address, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocode(job, geocodeCredentials, address);
    }

    private GeocodeAndIndexResumeResponse internalGeocodeAndIndex(ParsedResume resume, GeocodeCredentials geocodeCredentials, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, Address address, GeoCoordinates coordinates) throws SovrenException {
        GeocodeOptionsBase options = new GeocodeOptionsBase();
        options.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        options.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        options.PostalAddress = address;
        options.GeoCoordinates = coordinates;
        GeocodeAndIndexResumeRequest request = new GeocodeAndIndexResumeRequest();
        request.ResumeData = resume;
        request.GeocodeOptions = options;
        request.IndexingOptions = indexingOptions;
        request.IndexIfGeocodeFails = indexIfGeocodeFails;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeAndIndexResume()).post(body).build();
        HttpResponse<GeocodeAndIndexResumeResponse> response = this.executeRequest(apiRequest, GeocodeAndIndexResumeResponse.class, this.getBodyIfDebug(apiRequest));
        GeocodeAndIndexResumeResponseValue responseVal = (GeocodeAndIndexResumeResponseValue)response.getData().Value;
        if (!indexIfGeocodeFails && responseVal.GeocodeResponse != null && !responseVal.GeocodeResponse.isSuccess()) {
            throw new SovrenException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.GeocodeResponse, response.getData().getInfo().TransactionId);
        }
        if (responseVal.IndexingResponse != null && !responseVal.IndexingResponse.isSuccess()) {
            throw new SovrenException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.IndexingResponse, response.getData().getInfo().TransactionId);
        }
        return response.getData();
    }

    private GeocodeAndIndexJobResponse internalGeocodeAndIndex(ParsedJob job, GeocodeCredentials geocodeCredentials, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, Address address, GeoCoordinates coordinates) throws SovrenException {
        GeocodeOptionsBase options = new GeocodeOptionsBase();
        options.Provider = geocodeCredentials != null ? geocodeCredentials.Provider : GeocodeProvider.Google;
        options.ProviderKey = geocodeCredentials != null ? geocodeCredentials.ProviderKey : null;
        options.PostalAddress = address;
        options.GeoCoordinates = coordinates;
        GeocodeAndIndexJobRequest request = new GeocodeAndIndexJobRequest();
        request.JobData = job;
        request.GeocodeOptions = options;
        request.IndexingOptions = indexingOptions;
        request.IndexIfGeocodeFails = indexIfGeocodeFails;
        RequestBody body = this.createJsonBody(request);
        Request apiRequest = new Request.Builder().url(this._endpoints.geocodeAndIndexJob()).post(body).build();
        HttpResponse<GeocodeAndIndexJobResponse> response = this.executeRequest(apiRequest, GeocodeAndIndexJobResponse.class, this.getBodyIfDebug(apiRequest));
        GeocodeAndIndexJobResponseValue responseVal = (GeocodeAndIndexJobResponseValue)response.getData().Value;
        if (!indexIfGeocodeFails && responseVal.GeocodeResponse != null && !responseVal.GeocodeResponse.isSuccess()) {
            throw new SovrenException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.GeocodeResponse, response.getData().getInfo().TransactionId);
        }
        if (responseVal.IndexingResponse != null && !responseVal.IndexingResponse.isSuccess()) {
            throw new SovrenException(this.getBodyIfDebug(apiRequest), response.getResponse(), responseVal.IndexingResponse, response.getData().getInfo().TransactionId);
        }
        return response.getData();
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, null);
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexSingleDocumentInfo indexingOptions, Address address, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, address, null);
    }

    public GeocodeAndIndexResumeResponse geocodeAndIndex(ParsedResume resume, IndexSingleDocumentInfo indexingOptions, GeoCoordinates coordinates, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocodeAndIndex(resume, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, coordinates);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexSingleDocumentInfo indexingOptions, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, null);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexSingleDocumentInfo indexingOptions, Address address, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, address, null);
    }

    public GeocodeAndIndexJobResponse geocodeAndIndex(ParsedJob job, IndexSingleDocumentInfo indexingOptions, GeoCoordinates coordinates, boolean indexIfGeocodeFails, GeocodeCredentials geocodeCredentials) throws SovrenException {
        return this.internalGeocodeAndIndex(job, geocodeCredentials, indexingOptions, indexIfGeocodeFails, null, coordinates);
    }

    public SovrenUIClient ui(MatchUISettings uiOptions) {
        return new SovrenUIClient(uiOptions, this);
    }
}

