/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.entities;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.spikeify.taskqueue.utils.Assert;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class QueueSettings {
    protected int purgeSuccessfulAfterMinutes = 10;
    protected int purgeFailedAfterMinutes = 30;
    protected int taskTimeoutSeconds = 600;
    protected int interruptTimeout = 60;
    protected int maxThreads = 1;
    private long queueMaxSleepTimeSeconds = 10L;
    private long queuePurgeSleepTimeSeconds = 60L;

    @JsonProperty(value="purgeSuccessful")
    public int getPurgeSuccessfulAfterMinutes() {
        return this.purgeSuccessfulAfterMinutes;
    }

    @JsonProperty(value="purgeSuccessful")
    public void setPurgeSuccessfulAfterMinutes(int minutes) {
        Assert.isTrue(minutes >= 0, "Number of minutes must be >= 0!");
        this.purgeSuccessfulAfterMinutes = minutes;
    }

    @JsonProperty(value="purgeFailed")
    public int getPurgeFailedAfterMinutes() {
        return this.purgeFailedAfterMinutes;
    }

    @JsonProperty(value="purgeFailed")
    public void setPurgeFailedAfterMinutes(int minutes) {
        Assert.isTrue(minutes >= 0, "Number of minutes must be >= 0!");
        this.purgeFailedAfterMinutes = minutes;
    }

    @JsonProperty(value="timeout")
    public void setTaskTimeoutSeconds(int seconds) {
        Assert.isTrue(seconds > 0, "Time out must be >= 1!");
        Assert.isTrue(seconds <= 3600, "Time out must be <= 3600!");
        this.taskTimeoutSeconds = seconds;
    }

    @JsonProperty(value="timeout")
    public int getTaskTimeoutSeconds() {
        return this.taskTimeoutSeconds;
    }

    @JsonProperty(value="interrupt")
    public void setTaskInterruptTimeoutSeconds(int seconds) {
        Assert.isTrue(seconds >= 0, "Time out must be >= 0!");
        Assert.isTrue(seconds <= 3600, "Time out must be <= 3600!");
        this.interruptTimeout = seconds;
    }

    @JsonProperty(value="interrupt")
    public int getTaskInterruptTimeoutSeconds() {
        return this.interruptTimeout;
    }

    @JsonProperty(value="threads")
    public int getMaxThreads() {
        return this.maxThreads;
    }

    @JsonProperty(value="threads")
    public void setMaxThreads(int threads) {
        Assert.isTrue(threads > 0, "Number of threads must be >= 1!");
        Assert.isTrue(threads <= 10, "Number of threads must be <= 10!");
        this.maxThreads = threads;
    }

    @JsonProperty(value="checkTasks")
    public long getQueueMaxSleepTimeSeconds() {
        return this.queueMaxSleepTimeSeconds;
    }

    @JsonProperty(value="checkTasks")
    public void setQueueMaxSleepTimeSeconds(long queueMaxSleepTimeSeconds) {
        Assert.isTrue(queueMaxSleepTimeSeconds > 0L, "Number of threads must be >= 1!");
        Assert.isTrue(queueMaxSleepTimeSeconds <= 600L, "Number of threads must be <= 600!");
        this.queueMaxSleepTimeSeconds = queueMaxSleepTimeSeconds;
    }

    @JsonProperty(value="purgeTasks")
    public long getQueuePurgeSleepTimeSeconds() {
        return this.queuePurgeSleepTimeSeconds;
    }

    @JsonProperty(value="purgeTasks")
    public void setQueuePurgeSleepTimeSeconds(long queuePurgeSleepTimeSeconds) {
        Assert.isTrue(this.queueMaxSleepTimeSeconds > 0L, "Number of threads must be >= 1!");
        Assert.isTrue(this.queueMaxSleepTimeSeconds <= 600L, "Number of threads must be <= 600!");
        this.queuePurgeSleepTimeSeconds = queuePurgeSleepTimeSeconds;
    }
}

