/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.service;

import com.spikeify.taskqueue.Job;
import com.spikeify.taskqueue.TaskContext;
import com.spikeify.taskqueue.TaskResult;
import com.spikeify.taskqueue.entities.QueueTask;
import com.spikeify.taskqueue.entities.TaskResultState;
import com.spikeify.taskqueue.entities.TaskState;
import com.spikeify.taskqueue.service.TaskExecutorService;
import com.spikeify.taskqueue.service.TaskQueueService;
import com.spikeify.taskqueue.utils.Assert;
import com.spikeify.taskqueue.utils.StringUtils;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTaskExecutorService
implements TaskExecutorService {
    public static final Logger log = Logger.getLogger(DefaultTaskExecutorService.class.getSimpleName());
    private static final int MAX_START_RETRIES = 3;
    private final String queueName;
    private final TaskQueueService queue;
    private Job currentJob;

    public DefaultTaskExecutorService(TaskQueueService queueService, String queueName) {
        Assert.notNull(queueService, "Missing queue service!");
        this.queue = queueService;
        this.queueName = StringUtils.isNullOrEmptyTrimmed(queueName) ? "default" : queueName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TaskResult execute(TaskContext context) {
        int retries = 0;
        do {
            if (this.currentJob != null) {
                return null;
            }
            QueueTask next = this.queue.next(this.queueName);
            if (next == null) break;
            boolean started = TaskState.running.equals((Object)next.getState());
            if (started) {
                try {
                    this.currentJob = next.getJob();
                    TaskResult result = this.currentJob.execute(context);
                    switch (result.getState()) {
                        case ok: {
                            this.queue.transition(next, TaskState.finished);
                            break;
                        }
                        case interrupted: {
                            this.queue.transition(next, TaskState.interrupted);
                            break;
                        }
                        default: {
                            this.queue.transition(next, TaskState.failed);
                        }
                    }
                    log.fine("Task resulted in: " + result);
                    TaskResult taskResult = result;
                    return taskResult;
                }
                catch (Exception e) {
                    log.log(Level.SEVERE, "Failed to execute job: " + this.currentJob + ", queue id:" + next.getId(), e);
                    next = this.queue.transition(next, TaskState.failed);
                    if (next == null || !TaskState.failed.equals((Object)next.getState())) {
                        log.log(Level.SEVERE, "Failed to transition queued job to failed state: " + next + "!", e);
                    }
                    TaskResult taskResult = new TaskResult(TaskResultState.failed);
                    return taskResult;
                }
                finally {
                    this.currentJob = null;
                }
            }
            if (++retries >= 3) continue;
            try {
                Thread.sleep((long)(10.0 + Math.random() * 10.0 * (double)retries));
            }
            catch (InterruptedException e) {
                log.log(Level.SEVERE, "Thread.sleep() InterruptedException: ", e);
            }
        } while (retries < 3);
        return null;
    }

    @Override
    public boolean isRunning() {
        return this.currentJob != null;
    }

    @Override
    public void reset() {
        this.currentJob = null;
    }
}

