/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.service;

import com.spikeify.taskqueue.Job;
import com.spikeify.taskqueue.entities.QueueInfo;
import com.spikeify.taskqueue.entities.QueueSettings;
import com.spikeify.taskqueue.entities.QueueTask;
import com.spikeify.taskqueue.entities.TaskState;
import com.spikeify.taskqueue.service.QueueService;
import com.spikeify.taskqueue.service.TaskQueueManager;
import com.spikeify.taskqueue.service.TaskQueueService;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class QueueServiceImpl
implements QueueService {
    final Logger log = Logger.getLogger(QueueServiceImpl.class.getName());
    private final TaskQueueService queues;
    private final TaskQueueManager manager;
    private final String[] queueNames;

    public QueueServiceImpl(TaskQueueManager queueManager, TaskQueueService queueService, String ... queuesToRegister) {
        this(queueManager, queueService, (QueueSettings)null, queuesToRegister);
    }

    public QueueServiceImpl(TaskQueueManager queueManager, TaskQueueService queueService, QueueSettings settings, String ... queuesToRegister) {
        this.queues = queueService;
        this.manager = queueManager;
        for (String queue : this.queueNames = queuesToRegister) {
            this.manager.register(queue, settings, true);
        }
    }

    @Override
    public QueueTask addJob(Job newJob, String queueName) {
        return this.queues.add(newJob, queueName);
    }

    @Override
    public List<QueueTask> listJobs(TaskState state, String queueName) {
        return this.queues.list(state, queueName);
    }

    @Override
    public void settings(QueueSettings settings, String ... queues) {
        if (queues == null || queues.length == 0) {
            queues = this.queueNames;
        }
        for (String queue : queues) {
            this.manager.set(queue, settings);
            try {
                this.manager.start(queue);
            }
            catch (InterruptedException e) {
                this.log.log(Level.SEVERE, "Failed to restart queue when altering settings!", e);
            }
        }
    }

    @Override
    public QueueInfo info(String queueName) {
        return this.manager.info(queueName);
    }

    @Override
    public QueueInfo resetStatistics(String queueName) {
        this.manager.resetStatistics(queueName, false);
        return this.manager.info(queueName);
    }

    @Override
    public void start(String ... queues) {
        if (queues == null || queues.length == 0) {
            queues = this.queueNames;
        }
        for (String queueName : queues) {
            this.log.info("Starting queue: " + queueName);
            try {
                if (!this.manager.isRunning(queueName)) {
                    this.manager.start(queueName);
                    continue;
                }
                this.log.info("Queue already running ... skipping start!");
            }
            catch (InterruptedException e) {
                this.log.log(Level.SEVERE, "Failed to start queue!", e);
            }
        }
    }

    @Override
    public void restart(String queueName) {
        try {
            this.manager.start(queueName);
        }
        catch (InterruptedException e) {
            this.log.log(Level.SEVERE, "Failed to restart queue!", e);
        }
    }

    @Override
    public void stop(String ... queues) {
        if (queues == null || queues.length == 0) {
            queues = this.queueNames;
        }
        try {
            for (String queue : queues) {
                this.log.info("Stopping queue: " + queue);
                this.manager.stop(queue);
            }
        }
        catch (InterruptedException e) {
            this.log.log(Level.SEVERE, "Failed to stop queue!", e);
        }
    }

    @Override
    public void check() {
        try {
            for (String queueName : this.queueNames) {
                this.manager.check(queueName);
            }
        }
        catch (InterruptedException e) {
            this.log.log(Level.SEVERE, "Failed to check queue!", e);
        }
    }
}

