/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public final class JsonUtils {
    private static final ThreadLocal<ObjectMapper> tlObjectMapper = new ThreadLocal<ObjectMapper>(){

        @Override
        protected ObjectMapper initialValue() {
            return new ObjectMapper();
        }
    };

    private JsonUtils() {
    }

    public static ObjectMapper getObjectMapper() {
        return tlObjectMapper.get();
    }

    public static String toJson(Object object) {
        try {
            return JsonUtils.getObjectMapper().writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Given Object could not be serialized to JSON. Error: " + e.getMessage());
        }
    }

    public static String toJson(Object object, ObjectMapper customMapper) {
        if (customMapper == null) {
            throw new IllegalArgumentException("Missing custom mapper!");
        }
        try {
            return customMapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("Given Object could not be serialized to JSON. Error: " + e.getMessage());
        }
    }

    public static <T> T fromJson(String json, Class<T> valueType) {
        try {
            return (T)JsonUtils.getObjectMapper().readValue(json, valueType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given JSON could not be deserialized. Error: " + e.getMessage());
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Missing type reference!");
        }
        try {
            return (T)JsonUtils.getObjectMapper().readValue(json, reference);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given JSON could not be deserialized. Error: " + e.getMessage());
        }
    }

    public static <T> T fromJson(String json, TypeReference<T> reference, ObjectMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("Missing object mapper!");
        }
        if (reference == null) {
            throw new IllegalArgumentException("Missing type reference!");
        }
        try {
            return (T)mapper.readValue(json, reference);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given JSON could not be deserialized. Error: " + e.getMessage());
        }
    }

    public static <T> T fromJson(String json, Class<T> valueType, ObjectMapper mapper) {
        if (mapper == null) {
            throw new IllegalArgumentException("Missing object mapper!");
        }
        try {
            return (T)mapper.readValue(json, valueType);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given JSON could not be deserialized. Error: " + e.getMessage());
        }
    }

    public static <T> T convert(Object object, TypeReference<T> reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Missing type reference!");
        }
        return (T)JsonUtils.getObjectMapper().convertValue(object, reference);
    }

    public static <T> T convert(Object object, Class<T> valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("Missing class reference!");
        }
        return (T)JsonUtils.getObjectMapper().convertValue(object, valueType);
    }
}

