/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.entities;

import com.spikeify.annotations.Generation;
import com.spikeify.annotations.UserKey;
import com.spikeify.taskqueue.entities.QueueSettings;
import com.spikeify.taskqueue.entities.TaskState;
import com.spikeify.taskqueue.entities.TaskStatistics;
import com.spikeify.taskqueue.utils.Assert;
import com.spikeify.taskqueue.utils.JsonUtils;
import com.spikeify.taskqueue.utils.StringUtils;
import java.util.HashMap;

public class QueueInfo {
    @UserKey
    protected String name;
    @Generation
    protected int generation;
    protected String queueSettings;
    protected boolean enabled;
    protected boolean started;
    protected long queued;
    protected long running;
    protected long purge;
    protected long interrupted;
    protected long failed;
    protected long finished;
    protected long totalTasks;
    protected long totalFinished;
    protected long totalFailed;
    protected long totalRetries;
    protected HashMap<TaskState, String> statistics = new HashMap();

    protected QueueInfo() {
    }

    public QueueInfo(String queueName) {
        Assert.notNullOrEmpty(queueName, "Missing queue name!");
        this.enabled = true;
        this.name = queueName.trim();
        this.setSettings(new QueueSettings());
        this.reset(true);
    }

    public String getName() {
        return this.name;
    }

    public QueueSettings getSettings() {
        return JsonUtils.fromJson(this.queueSettings, QueueSettings.class);
    }

    public void setSettings(QueueSettings settings) {
        this.queueSettings = JsonUtils.toJson(settings);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean active) {
        this.enabled = active;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setStarted(boolean start) {
        this.started = start;
    }

    public void reset(boolean force) {
        this.totalTasks = 0L;
        this.totalFinished = 0L;
        this.totalFailed = 0L;
        this.totalRetries = 0L;
        if (force) {
            this.queued = 0L;
            this.running = 0L;
            this.purge = 0L;
            this.interrupted = 0L;
            this.failed = 0L;
            this.finished = 0L;
        }
        this.statistics = new HashMap();
    }

    public long getQueuedTasks() {
        return this.queued;
    }

    public long getRunningTasks() {
        return this.running;
    }

    public long getPurgeTasks() {
        return this.purge;
    }

    public long getInterruptedTasks() {
        return this.interrupted;
    }

    public long getFailedTasks() {
        return this.failed;
    }

    public long getFinishedTasks() {
        return this.finished;
    }

    public long getTotalTasks() {
        return this.totalTasks;
    }

    public long getTotalFinished() {
        return this.totalFinished;
    }

    public long getTotalFailed() {
        return this.totalFailed;
    }

    public long getTotalRetries() {
        return this.totalRetries;
    }

    public TaskStatistics getStatistics(TaskState state) {
        String json = this.statistics.get((Object)state);
        if (StringUtils.isNullOrEmptyTrimmed(json)) {
            return null;
        }
        return JsonUtils.fromJson(json, TaskStatistics.class);
    }

    public void setStatistics(TaskState state, TaskStatistics output) {
        if (state != null && output != null) {
            TaskStatistics old = this.getStatistics(state);
            if (old != null) {
                TaskStatistics.Builder builder = new TaskStatistics.Builder();
                TaskStatistics joined = builder.include(old).buildWith(output);
                String json = JsonUtils.toJson(joined);
                this.statistics.put(state, json);
            } else {
                String json = JsonUtils.toJson(output);
                this.statistics.put(state, json);
            }
        }
    }
}

