/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.entities;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.spikeify.annotations.Generation;
import com.spikeify.annotations.Indexed;
import com.spikeify.annotations.UserKey;
import com.spikeify.taskqueue.Job;
import com.spikeify.taskqueue.TaskQueueError;
import com.spikeify.taskqueue.entities.TaskState;
import com.spikeify.taskqueue.utils.Assert;
import com.spikeify.taskqueue.utils.JsonUtils;

public class QueueTask {
    private static final String LOCKED = "LOCKED";
    private static final String OPEN = "OPEN";
    private static final int MAX_RETRIES = 3;
    private static final ObjectMapper jsonMapper = new ObjectMapper();
    @Generation
    protected Integer generation;
    @UserKey(generate=true)
    private String id;
    protected String queue;
    protected String job;
    protected String className;
    protected long createTime;
    protected long updateTime;
    protected long startTime;
    protected long endTime;
    protected Long executionTime;
    protected Long jobRunTime;
    protected TaskState state;
    protected int runCount;
    @Indexed
    protected String stateFilter;
    @Indexed
    protected String lockFilter;

    protected QueueTask() {
    }

    public QueueTask(Job newJob, String queueName) {
        Assert.notNull(newJob, "Missing task!");
        Assert.notNull(queueName, "Missing queue name!");
        this.queue = queueName;
        this.updateTime = this.createTime = System.currentTimeMillis();
        this.startTime = 0L;
        this.endTime = 0L;
        this.state = TaskState.queued;
        this.runCount = 0;
        this.job = JsonUtils.toJson(newJob, jsonMapper);
        this.className = newJob.getClass().getName();
        this.updateFilter();
    }

    public Job getJob() {
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(this.className);
            Object instance = JsonUtils.fromJson(this.job, clazz, jsonMapper);
            if (!(instance instanceof Job)) {
                throw new TaskQueueError("Class '" + clazz.getName() + "' must derive from '" + Job.class.getName() + "'!");
            }
            return (Job)instance;
        }
        catch (IllegalArgumentException e) {
            throw new TaskQueueError("Deserialization problem: " + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            throw new TaskQueueError("Class '" + this.className + "' not found!", e);
        }
    }

    public String getId() {
        return this.id;
    }

    public String getClassName() {
        return this.className;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public Long getCreateTime() {
        return this.createTime;
    }

    public Long getUpdateTime() {
        return this.updateTime;
    }

    public Long getJobRunTime() {
        return this.jobRunTime;
    }

    public Long getExecutionTime() {
        return this.executionTime;
    }

    public TaskState getState() {
        return this.state;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setState(TaskState newState) {
        if (!this.state.canTransition(newState)) {
            throw new TaskQueueError("Can't transition from: " + (Object)((Object)this.state) + " to: " + (Object)((Object)newState));
        }
        this.updateTime = System.currentTimeMillis();
        if (TaskState.running.equals((Object)newState)) {
            this.startTime = System.currentTimeMillis();
            ++this.runCount;
        }
        if (TaskState.finished.equals((Object)newState) || TaskState.failed.equals((Object)newState)) {
            this.endTime = System.currentTimeMillis();
            this.jobRunTime = this.endTime - this.startTime;
            this.executionTime = this.endTime - this.createTime;
        }
        this.state = newState;
        this.updateFilter();
    }

    public int getRunCount() {
        return this.runCount;
    }

    public boolean isLocked() {
        return TaskState.running.equals((Object)this.state) || TaskState.finished.equals((Object)this.state) || TaskState.purge.equals((Object)this.state) || TaskState.interrupted.equals((Object)this.state) && this.runCount >= 3 || TaskState.failed.equals((Object)this.state) && this.runCount >= 3;
    }

    public String toString() {
        return this.id + ": " + this.className + " [" + (Object)((Object)this.state) + "]";
    }

    protected void updateFilter() {
        this.lockFilter = QueueTask.getLockedFilter(this.queue, this.isLocked());
        this.stateFilter = QueueTask.getStateFilter(this.queue, this.state);
    }

    public static String getLockedFilter(String queueName, boolean locked) {
        return queueName + "::" + (locked ? LOCKED : OPEN);
    }

    public static String getStateFilter(String queueName, TaskState taskState) {
        return queueName + "::" + taskState.name();
    }

    public boolean isOlderThan(int ageInMinutes) {
        if (ageInMinutes == 0) {
            return true;
        }
        long difference = System.currentTimeMillis() - this.updateTime;
        return difference >= (long)ageInMinutes * 1000L * 60L;
    }

    public boolean isOlderThanSeconds(int ageInSeconds) {
        if (ageInSeconds == 0) {
            return true;
        }
        long difference = System.currentTimeMillis() - this.updateTime;
        return difference >= (long)ageInSeconds * 1000L;
    }

    static {
        jsonMapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
    }
}

