/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.entities;

import java.util.HashMap;
import java.util.Map;

public enum TaskState {
    queued,
    running,
    finished,
    interrupted,
    failed,
    purge;

    private static Map<TaskState, TaskState[]> transitionMatrix;

    public boolean canTransition(TaskState toState) {
        TaskState[] possible = transitionMatrix.get((Object)this);
        if (possible == null) {
            return false;
        }
        for (TaskState state : possible) {
            if (!state.equals((Object)toState)) continue;
            return true;
        }
        return false;
    }

    static {
        transitionMatrix = new HashMap<TaskState, TaskState[]>();
        transitionMatrix.put(null, new TaskState[]{queued});
        transitionMatrix.put(queued, new TaskState[]{running, purge});
        transitionMatrix.put(running, new TaskState[]{finished, failed, interrupted});
        transitionMatrix.put(failed, new TaskState[]{running, purge});
        transitionMatrix.put(interrupted, new TaskState[]{running, purge});
        transitionMatrix.put(finished, new TaskState[]{purge});
    }
}

