/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.entities;

import com.spikeify.taskqueue.entities.QueueTask;

public class TaskStatistics {
    protected long count;
    protected long minJobRunTime;
    protected long maxJobRunTime;
    protected long totalJobRunTime;
    protected long minExecutionTime;
    protected long maxExecutionTime;
    protected long totalExecutionTime;
    protected long averageJobRunTime;
    protected long averageExecutionTime;

    public long getCount() {
        return this.count;
    }

    public long getMinJobRunTime() {
        return this.minJobRunTime;
    }

    public long getMaxJobRunTime() {
        return this.maxJobRunTime;
    }

    public long getTotalJobRunTime() {
        return this.totalJobRunTime;
    }

    public long getMinExecutionTime() {
        return this.minExecutionTime;
    }

    public long getMaxExecutionTime() {
        return this.maxExecutionTime;
    }

    public long getTotalExecutionTime() {
        return this.totalExecutionTime;
    }

    public long getAverageJobRunTime() {
        return this.averageJobRunTime;
    }

    public long getAverageExecutionTime() {
        return this.averageExecutionTime;
    }

    public static class Builder {
        long count;
        Long minJobRunTime = null;
        Long maxJobRunTime = null;
        Long minExecutionTime = null;
        Long maxExecutionTime = null;
        long totalJobRunTime;
        long totalExecutionTime;
        long averageJobRunTime;
        long averageExecutionTime;

        private void calculateAverage() {
            if (this.count > 0L) {
                this.averageJobRunTime = this.totalJobRunTime / this.count;
                this.averageExecutionTime = this.totalExecutionTime / this.count;
            }
        }

        public Builder include(QueueTask item) {
            if (item != null) {
                this.setMinMaxExecutionTime(item.getExecutionTime());
                this.setMinMaxJobRunTime(item.getJobRunTime());
                if (item.getExecutionTime() != null) {
                    this.totalExecutionTime += item.getExecutionTime().longValue();
                }
                if (item.getJobRunTime() != null) {
                    this.totalJobRunTime += item.getJobRunTime().longValue();
                }
                ++this.count;
            }
            return this;
        }

        public Builder include(TaskStatistics old) {
            if (old == null) {
                return this;
            }
            if (old.count > 0L) {
                this.totalJobRunTime += old.getTotalJobRunTime();
                this.totalExecutionTime += old.getTotalExecutionTime();
                this.count += old.count;
                this.setMinMaxExecutionTime(old.getMinExecutionTime());
                this.setMinMaxExecutionTime(old.getMaxExecutionTime());
                this.setMinMaxJobRunTime(old.getMinJobRunTime());
                this.setMinMaxJobRunTime(old.getMaxJobRunTime());
            }
            return this;
        }

        public TaskStatistics build() {
            if (this.count == 0L) {
                return null;
            }
            this.calculateAverage();
            return this.getTaskStatistics();
        }

        public TaskStatistics buildWith(TaskStatistics previous) {
            if (this.count > 0L && previous.count > 0L) {
                this.include(previous);
                this.calculateAverage();
            }
            return this.getTaskStatistics();
        }

        private void setMinMaxExecutionTime(Long jobExecutionTime) {
            if (jobExecutionTime != null) {
                if (this.minExecutionTime == null || jobExecutionTime < this.minExecutionTime) {
                    this.minExecutionTime = jobExecutionTime;
                }
                if (this.maxExecutionTime == null || jobExecutionTime > this.maxExecutionTime) {
                    this.maxExecutionTime = jobExecutionTime;
                }
            }
        }

        private void setMinMaxJobRunTime(Long jobRunTime) {
            if (jobRunTime != null) {
                if (this.minJobRunTime == null || jobRunTime < this.minJobRunTime) {
                    this.minJobRunTime = jobRunTime;
                }
                if (this.maxJobRunTime == null || jobRunTime > this.maxJobRunTime) {
                    this.maxJobRunTime = jobRunTime;
                }
            }
        }

        private TaskStatistics getTaskStatistics() {
            TaskStatistics statistics = new TaskStatistics();
            statistics.count = this.count;
            statistics.maxExecutionTime = this.maxExecutionTime != null ? this.maxExecutionTime : 0L;
            statistics.minExecutionTime = this.minExecutionTime != null ? this.minExecutionTime : 0L;
            statistics.averageExecutionTime = this.averageExecutionTime;
            statistics.totalExecutionTime = this.totalExecutionTime;
            statistics.minJobRunTime = this.minJobRunTime != null ? this.minJobRunTime : 0L;
            statistics.maxJobRunTime = this.maxJobRunTime != null ? this.maxJobRunTime : 0L;
            statistics.averageJobRunTime = this.averageJobRunTime;
            statistics.totalJobRunTime = this.totalJobRunTime;
            return statistics;
        }
    }
}

