/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.service;

import com.spikeify.taskqueue.entities.QueueSettings;
import com.spikeify.taskqueue.entities.QueueTask;
import com.spikeify.taskqueue.entities.TaskState;
import com.spikeify.taskqueue.entities.TaskStatistics;
import com.spikeify.taskqueue.service.TaskQueueService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class QueuePurger
implements Runnable {
    private static final Logger log = Logger.getLogger(QueuePurger.class.getSimpleName());
    private static final int ADDITIONAL_SLACK = 10;
    private final TaskQueueService queues;
    private final int timeout;
    private String queueName;
    private Map<TaskState, Integer> states = new HashMap<TaskState, Integer>();

    public QueuePurger(TaskQueueService queueService, String queue, QueueSettings settings) {
        this.queues = queueService;
        this.queueName = queue;
        this.states.put(TaskState.finished, settings.getPurgeSuccessfulAfterMinutes());
        this.states.put(TaskState.failed, settings.getPurgeFailedAfterMinutes());
        this.timeout = settings.getTaskTimeoutSeconds();
    }

    @Override
    public void run() {
        for (TaskState state : this.states.keySet()) {
            int maxAge;
            TaskStatistics purge = this.queues.purge(state, maxAge = this.states.get((Object)state).intValue(), this.queueName);
            if (purge == null) continue;
            log.info("[" + this.queueName + "] purge: " + purge.getCount() + " " + (Object)((Object)state) + " task(s).");
        }
        List<QueueTask> running = this.queues.list(TaskState.running, this.queueName);
        for (QueueTask task : running) {
            if (!task.isOlderThanSeconds(this.timeout + 10)) continue;
            log.info("Found hanged/timed out task: " + task + ", putting into failed state!");
            this.queues.transition(task, TaskState.failed);
        }
    }
}

