/*
 * Decompiled with CFR 0.152.
 */
package com.spikeify.taskqueue.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNullOrEmptyTrimmed(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static boolean equals(String original, String compare) {
        return StringUtils.equals(original, compare, false);
    }

    public static boolean equals(String original, String compare, boolean ignoreCase) {
        if (original == null && compare == null) {
            return true;
        }
        if (original != null) {
            if (ignoreCase) {
                return original.equalsIgnoreCase(compare);
            }
            return original.equals(compare);
        }
        return false;
    }

    public static int compare(String one, String two) {
        if (one == null && two == null) {
            return 0;
        }
        if (one == null) {
            return -1;
        }
        if (two == null) {
            return 1;
        }
        return one.compareTo(two);
    }

    public static String trim(String value) {
        return value != null ? value.trim() : null;
    }

    public static String trimDoubleSpaces(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        value = value.trim();
        return value.replaceAll("\\s+", " ");
    }

    public static String trimInner(String value) {
        if (StringUtils.isNullOrEmpty(value)) {
            return value;
        }
        value = value.trim();
        return value.replaceAll("\\s+", "");
    }

    public static String trimEnd(String text) {
        if (StringUtils.isNullOrEmpty(text)) {
            return text;
        }
        return text.replaceAll("\\s+$", "");
    }

    public static String trimStart(String text) {
        if (StringUtils.isNullOrEmpty(text)) {
            return text;
        }
        return text.replaceAll("^\\s+", "");
    }

    public static String trimAll(String text, String toBeTrimmed) {
        if (StringUtils.isNullOrEmpty(text) || StringUtils.isNullOrEmpty(toBeTrimmed)) {
            return text;
        }
        return text.replaceAll(toBeTrimmed, "");
    }

    public static String trimToNull(String text) {
        if ((text = StringUtils.trim(text)) == null || text.isEmpty()) {
            return null;
        }
        return text;
    }

    public static String join(List<?> list, String separator) {
        if (StringUtils.isNullOrEmptyTrimmed(separator)) {
            throw new IllegalArgumentException("Missing separator!");
        }
        String output = "";
        if (list != null && list.size() > 0) {
            for (int i = 1; i <= list.size(); ++i) {
                output = output + list.get(i - 1);
                if (i >= list.size()) continue;
                output = output + separator;
            }
        }
        return output;
    }

    public static String join(Object[] args, String separator) {
        if (StringUtils.isNullOrEmptyTrimmed(separator)) {
            throw new IllegalArgumentException("Missing separator!");
        }
        if (args != null && args.length > 0) {
            List<Object> array = Arrays.asList(args);
            return StringUtils.join(array, separator);
        }
        return "";
    }

    public static String join(Set<String> items, String separator) {
        if (StringUtils.isNullOrEmptyTrimmed(separator)) {
            throw new IllegalArgumentException("Missing separator!");
        }
        if (items != null && items.size() > 0) {
            Object[] array = items.toArray();
            return StringUtils.join(array, separator);
        }
        return "";
    }

    public static String join(HashMap<String, String> params, String separator) {
        if (StringUtils.isNullOrEmptyTrimmed(separator)) {
            throw new IllegalArgumentException("Missing separator!");
        }
        String output = "";
        if (params != null) {
            for (String name : params.keySet()) {
                if (output.length() > 0) {
                    output = output + separator;
                }
                output = output + name + "=" + params.get(name);
            }
        }
        return output;
    }

    public static List<String> getWords(String text) {
        ArrayList<String> output = new ArrayList<String>();
        if (StringUtils.isNullOrEmptyTrimmed(text)) {
            return output;
        }
        Pattern p = Pattern.compile("\\b\\p{L}+\\b");
        Matcher m = p.matcher(text);
        while (m.find()) {
            output.add(m.group());
        }
        return output;
    }

    public static String trimTextDown(String text, int size) {
        if (text.length() <= size) {
            return text;
        }
        int pos = text.lastIndexOf(" ", size);
        if (pos < 0) {
            return text.substring(0, size);
        }
        return text.substring(0, pos);
    }

    public static String toStringOrNull(Object value) {
        return null != value ? value.toString() : null;
    }

    public static List<String> asListOfChars(String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isNullOrEmptyTrimmed(value)) {
            return list;
        }
        for (int i = 0; i < value.length(); ++i) {
            list.add(Character.toString(value.charAt(i)));
        }
        return list;
    }

    public static boolean isWord(String word) {
        if (StringUtils.isNullOrEmptyTrimmed(word)) {
            return false;
        }
        List<String> list = StringUtils.getWords(word);
        return list.size() == 1;
    }
}

