/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.db.command.html.Menu;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.util.CommonUtils;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum MenuDefinition {
    General{

        @Override
        public boolean hasData(Catalog catalog) {
            return true;
        }

        @Override
        public String getHtmlName() {
            return "index.html";
        }
    }
    ,
    Schemas{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getSchemas().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }
    }
    ,
    Tables{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getTables().stream());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Columns{

        @Override
        public boolean hasData(Catalog catalog) {
            return true;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List tables = Tables.getDatas(catalog);
            List list = tables.stream().flatMap(table -> table.getColumns().stream()).collect(Collectors.toList());
            Collections.sort(list, new ColumnComparator());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Tables;
        }
    }
    ,
    Indexes{

        @Override
        public boolean hasData(Catalog catalog) {
            return true;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List tables = Tables.getDatas(catalog);
            List list = tables.stream().flatMap(table -> table.getIndexes().stream()).collect(Collectors.toList());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Tables;
        }
    }
    ,
    Relationships{

        @Override
        public boolean hasData(Catalog catalog) {
            return true;
        }
    }
    ,
    Functions{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getFunctions().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Procedures{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getProcedures().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Constants{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getConstants().stream());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Packages{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getPackages().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Triggers{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getTriggers().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Views{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getViews().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Mviews{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getMviews().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return "Materialized View";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    MviewLogs{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getMviewLogs().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return "Materialized View Logs";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Masks{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getMasks().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return "Masks";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    TableLinks{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getTableLinks().stream());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Table Links";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    ExternalTables{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getExternalTables().stream());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "External Tables";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Sequences{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getSequences().stream());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Synonyms{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getSynonyms().stream());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    PublicSynonyms{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getPublicSynonyms().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Public Synonyms";
        }
    }
    ,
    DbLinks{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getDbLinks().stream());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "DB Links";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    PublicDbLinks{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getPublicDbLinks().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Public DB Links";
        }
    }
    ,
    Domains{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getDomains().stream());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Types{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getTypes().stream());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    TableSpaces{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getTableSpaces().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return "Table Spaces";
        }
    }
    ,
    Rules{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getRules().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Events{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getEvents().stream());
            return list;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Directories{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getDirectories().stream().collect(Collectors.toList());
            return list;
        }
    }
    ,
    Operators{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getOperators().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    OperatorClasses{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getOperatorClasses().stream());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return "Operator Classes";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    PartitionFunctions{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getPartitionFunctions().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return "Partition Functions";
        }
    }
    ,
    PartitionSchemes{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getPartitionSchemes().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }

        @Override
        public String getDisplayName() {
            return "Partition Schemes";
        }
    }
    ,
    XmlSchemas{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getXmlSchemas().stream());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "XML Schemas";
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }
    }
    ,
    Assemblies{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getAssemblies().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public boolean hasDetails() {
            return true;
        }
    }
    ,
    Dimensions{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = this.getSchemaObjectList(catalog, s -> s.getDimensions().stream());
            return list;
        }

        @Override
        public int getNestLevel() {
            return 2;
        }

        @Override
        public MenuDefinition getParent() {
            return Schemas;
        }
    }
    ,
    Users{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getUsers().stream().collect(Collectors.toList());
            return list;
        }
    }
    ,
    Roles{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getRoles().stream().collect(Collectors.toList());
            return list;
        }
    }
    ,
    UserPrivileges{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getUserPrivileges().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "User Privileges";
        }
    }
    ,
    SchemaPrivileges{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getSchemaPrivileges().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Schema Privileges";
        }
    }
    ,
    ObjectPrivileges{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getObjectPrivileges().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Object Privileges";
        }
    }
    ,
    RoutinePrivileges{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getRoutinePrivileges().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Routine Privileges";
        }
    }
    ,
    ColumnPrivileges{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getColumnPrivileges().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Column Privileges";
        }
    }
    ,
    RolePrivileges{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getRolePrivileges().stream().collect(Collectors.toList());
            return list;
        }

        @Override
        public String getDisplayName() {
            return "Role Privileges";
        }
    }
    ,
    Settings{

        @Override
        public boolean hasData(Catalog catalog) {
            List list = this.getDatas(catalog);
            return list.size() > 0;
        }

        @Override
        public <S> List<S> getDatas(Catalog catalog) {
            List list = catalog.getSettings().stream().collect(Collectors.toList());
            return list;
        }
    };

    private List<MenuDefinition> nest = null;

    public MenuDefinition getParent() {
        return null;
    }

    public String getHtmlName() {
        return this.toString().toLowerCase() + ".html";
    }

    public List<MenuDefinition> getNest() {
        if (this.nest != null) {
            return this.nest;
        }
        List list = CommonUtils.list();
        this.createNest(this, list);
        List reverseList = CommonUtils.list();
        for (int i = list.size() - 1; i >= 0; --i) {
            reverseList.add((MenuDefinition)((Object)list.get(i)));
        }
        this.nest = Collections.unmodifiableList(reverseList);
        return this.nest;
    }

    private void createNest(MenuDefinition current, List<MenuDefinition> result) {
        if (current != null) {
            result.add(current);
            this.createNest(current.getParent(), result);
        }
    }

    public int getNestLevel() {
        return this.getNest().size();
    }

    public boolean hasDetails() {
        return false;
    }

    public boolean hasData(Catalog catalog) {
        return true;
    }

    public <S> List<S> getDatas(Catalog catalog) {
        return Collections.emptyList();
    }

    protected <R, S extends Stream<R>> List<R> getSchemaObjectList(Catalog catalog, Function<? super Schema, S> func) {
        List list = catalog.getSchemas().stream().flatMap(func).collect(Collectors.toList());
        return list;
    }

    public String getDisplayName() {
        return this.toString();
    }

    public Menu toMenu() {
        Menu menu = new Menu();
        menu.setId(this.name());
        menu.setName(this.getDisplayName());
        menu.setUrl(this.getHtmlName());
        menu.setMenuDefinition(this);
        return menu;
    }

    public static List<Menu> toMenus(Catalog catalog) {
        List result = CommonUtils.list();
        for (MenuDefinition menuDefinition : MenuDefinition.values()) {
            if (!menuDefinition.hasData(catalog)) continue;
            result.add(menuDefinition.toMenu());
        }
        return result;
    }

    public static MenuDefinition parse(String text) {
        for (MenuDefinition def : MenuDefinition.values()) {
            if (!def.toString().equalsIgnoreCase(text)) continue;
            return def;
        }
        return null;
    }

    static class ColumnComparator
    implements Comparator<Column> {
        ColumnComparator() {
        }

        @Override
        public int compare(Column o1, Column o2) {
            int ret = CommonUtils.compare((Comparable)((Object)o1.getName()), (Object)o2.getName());
            if (ret != 0) {
                return ret;
            }
            ret = CommonUtils.compare((Comparable)((Object)o1.getSchemaName()), (Object)o2.getSchemaName());
            if (ret != 0) {
                return ret;
            }
            ret = CommonUtils.compare((Comparable)((Object)o1.getTableName()), (Object)o2.getTableName());
            return ret;
        }
    }
}

