/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.AbstractSqlQueryCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.ColumnFunction;
import com.sqlapp.data.schemas.function.ColumnValueFunction;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.ResultSetRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.OutputTextBuilder;
import com.sqlapp.util.file.TextFileWriter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.util.List;

public class SqlQuery2FileCommand
extends AbstractSqlQueryCommand {
    private String outputFileCharset = "UTF-8";
    private File outputFile = null;
    private ColumnFunction<String> headerFunction = (ColumnFunction & Serializable)c -> c.getName();
    private ColumnValueFunction<Object, String> valueFunction = (ColumnValueFunction & Serializable)(column, value) -> Converters.getDefault().convertString(value);
    private RowValueConverter rowValueConverter = (RowValueConverter & Serializable)(r, c, v) -> v;

    @Override
    protected void outputTableData(Dialect dialect, Table table) {
        OutputTextBuilder builder = new OutputTextBuilder();
        builder.append(table);
        FileUtils.writeText((File)this.outputFile, (String)this.outputFileCharset, (String[])new String[]{builder.toString()});
    }

    @Override
    protected void outputTableData(Dialect dialect, Table table, ResultSet resultSet) throws IOException, Exception {
        WorkbookFileType workbookFileType = this.getOutputFormatType().getWorkbookFileType();
        if (workbookFileType != null) {
            try (TextFileWriter csvListWriter = workbookFileType.createCsvListWriter(this.outputFile, this.getOutputFileCharset());){
                List<String> headers = this.getHeaders(table);
                csvListWriter.writeHeader(headers.toArray(new String[0]));
                for (Row row : table.getRows((RowIteratorHandler)new ResultSetRowIteratorHandler(resultSet, this.getRowValueConverter()))) {
                    List<String> values = this.getValues(table, row);
                    csvListWriter.writeHeader(values.toArray(new String[0]));
                }
            }
        }
    }

    private List<String> getHeaders(Table table) {
        List list = CommonUtils.list();
        for (Column column : table.getColumns()) {
            String value = (String)this.getHeaderFunction().apply((Object)column);
            list.add(value);
        }
        return list;
    }

    private List<String> getValues(Table table, Row row) {
        List list = CommonUtils.list();
        for (Column column : table.getColumns()) {
            Object obj = row.get(column);
            String value = (String)this.valueFunction.apply((Object)column, obj);
            list.add(value);
        }
        return list;
    }

    public File getOutputFile() {
        return this.outputFile;
    }

    public void setOutputFile(File outputFile) {
        this.outputFile = outputFile;
    }

    public String getOutputFileCharset() {
        return this.outputFileCharset;
    }

    public void setOutputFileCharset(String outputFileCharset) {
        this.outputFileCharset = outputFileCharset;
    }

    public ColumnFunction<String> getHeaderFunction() {
        return this.headerFunction;
    }

    public void setHeaderFunction(ColumnFunction<String> headerFunction) {
        this.headerFunction = headerFunction;
    }

    public ColumnValueFunction<Object, String> getValueFunction() {
        return this.valueFunction;
    }

    public void setValueFunction(ColumnValueFunction<Object, String> valueFunction) {
        this.valueFunction = valueFunction;
    }

    public RowValueConverter getRowValueConverter() {
        return this.rowValueConverter;
    }

    public void setRowValueConverter(RowValueConverter rowValueConverter) {
        this.rowValueConverter = rowValueConverter;
    }
}

