/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.AbstractNamedObject;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.TablePredicate;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class TableSqlExecuteCommand
extends AbstractSchemaDataSourceCommand {
    private SqlType[] sqlType = null;
    private String catalogName;
    private String schemaName;
    private TableOptions tableOptions = new TableOptions();
    private SqlConverter sqlConverter = new SqlConverter();
    private TablePredicate targetTable = (TablePredicate & Serializable)table -> false;
    private TablePredicate commitPerTable = (TablePredicate & Serializable)table -> true;
    private IterationMethod iterationMethod = IterationMethod.TABLE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doRun() {
        Connection connection = null;
        try {
            connection = this.getConnection();
            Dialect dialect = this.getDialect(connection);
            Catalog catalog = new Catalog();
            catalog.setDialect(dialect);
            try {
                Map<String, Schema> schemaMap = this.getSchemaMap(connection, dialect);
                schemaMap.forEach((k, v) -> catalog.getSchemas().add((AbstractNamedObject)v));
            }
            catch (SQLException e) {
                this.getExceptionHandler().handle((Throwable)e);
            }
            SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
            sqlFactoryRegistry.getOption().setTableOptions(this.tableOptions);
            List tables = CommonUtils.list();
            for (Schema schema : catalog.getSchemas()) {
                for (Table table : schema.getTables()) {
                    tables.add(table);
                }
            }
            connection.setAutoCommit(false);
            if (this.getIterationMethod().isTable()) {
                for (Table table : tables) {
                    if (!this.targetTable.test((Object)table)) continue;
                    for (SqlType sqlType : this.sqlType) {
                        List sqlOperations = sqlFactoryRegistry.createSql((DbCommonObject)table, sqlType);
                        ParametersContext context = new ParametersContext();
                        context.putAll(this.getContext());
                        for (SqlOperation operation : sqlOperations) {
                            SqlNode sqlNode = this.sqlConverter.parseSql(context, operation.getSqlText());
                            JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                            jdbcHandler.execute(connection, context);
                            connection.commit();
                        }
                        if (this.getTableOptions().getCommitPerSqlType().test((Object)sqlType)) continue;
                        connection.commit();
                    }
                    if (this.getTableOptions().getCommitPerTable().test((Object)table)) continue;
                    connection.commit();
                }
            } else {
                for (SqlType sqlType : this.sqlType) {
                    Comparator comp = sqlType.getTableComparator();
                    if (comp != null) {
                        tables.sort(comp);
                    }
                    for (Table table : tables) {
                        if (!this.targetTable.test((Object)table)) continue;
                        List sqlOperations = sqlFactoryRegistry.createSql((DbCommonObject)table, sqlType);
                        ParametersContext context = new ParametersContext();
                        context.putAll(this.getContext());
                        for (SqlOperation operation : sqlOperations) {
                            SqlNode sqlNode = this.sqlConverter.parseSql(context, operation.getSqlText());
                            JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                            jdbcHandler.execute(connection, context);
                            connection.commit();
                        }
                        if (this.getTableOptions().getCommitPerTable().test((Object)table)) continue;
                        connection.commit();
                    }
                    if (this.getTableOptions().getCommitPerSqlType().test((Object)sqlType)) continue;
                    connection.commit();
                }
            }
            connection.commit();
        }
        catch (RuntimeException e) {
            this.rollback(connection);
            this.getExceptionHandler().handle((Throwable)e);
        }
        catch (SQLException e) {
            this.rollback(connection);
            this.getExceptionHandler().handle((Throwable)e);
        }
        finally {
            this.releaseConnection(connection);
        }
    }

    protected SchemaReader getSchemaReader(Dialect dialect) throws SQLException {
        try (Connection connection = this.getConnection();){
            SchemaReader schemaReader = this.getSchemaReader(connection, dialect);
            return schemaReader;
        }
    }

    private Map<String, Schema> getSchemaMap(Connection connection, Dialect dialect) throws SQLException {
        SchemaReader schemaReader = this.getSchemaReader(dialect);
        Map<String, Schema> schemaMap = this.getSchemas(connection, dialect, schemaReader, s -> true);
        return schemaMap;
    }

    protected SchemaReader getSchemaReader(Connection connection, Dialect dialect) throws SQLException {
        CatalogReader catalogReader = dialect.getCatalogReader();
        SchemaReader schemaReader = catalogReader.getSchemaReader();
        if (!CommonUtils.isEmpty((CharSequence)this.getCatalogName())) {
            schemaReader.setCatalogName(this.getCatalogName());
        } else {
            String catalogName = this.getCurrentCatalogName(connection, dialect);
            schemaReader.setCatalogName(catalogName);
        }
        if (!CommonUtils.isEmpty((CharSequence)this.getSchemaName())) {
            schemaReader.setSchemaName(this.getSchemaName());
        } else {
            String schemaName = this.getCurrentSchemaName(connection, dialect);
            schemaReader.setSchemaName(schemaName);
        }
        return schemaReader;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    public Predicate<Table> getTargetTable() {
        return this.targetTable;
    }

    public void setTargetTable(TablePredicate targetTable) {
        this.targetTable = targetTable;
    }

    public void setTargetTable(String targetTableName) {
        this.targetTable = (TablePredicate & Serializable)table -> CommonUtils.eq((Object)table.getName(), (Object)targetTableName);
    }

    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    public void setSqlConverter(SqlConverter sqlConverter) {
        this.sqlConverter = sqlConverter;
    }

    public void setIterationMethod(IterationMethod iterationMethod) {
        this.iterationMethod = iterationMethod;
    }

    public IterationMethod getIterationMethod() {
        return this.iterationMethod;
    }

    public SqlType[] getSqlType() {
        return this.sqlType;
    }

    public void setSqlType(SqlType ... sqlType) {
        this.sqlType = sqlType;
    }

    public TablePredicate getCommitPerTable() {
        return this.commitPerTable;
    }

    public void setCommitPerTable(TablePredicate commitPerTable) {
        this.commitPerTable = commitPerTable;
    }

    public void setCommitPerTable(boolean bool) {
        this.commitPerTable = (TablePredicate & Serializable)table -> bool;
    }

    public SqlConverter getSqlConverter() {
        return this.sqlConverter;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IterationMethod {
        TABLE{

            @Override
            public boolean isTable() {
                return true;
            }
        }
        ,
        SQL_TYPE;


        public boolean isTable() {
            return false;
        }
    }
}

