/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractSchemaDataSourceCommand;
import com.sqlapp.data.db.command.ConvertHandler;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.DefaultSqlExecutor;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.db.sql.SqlExecutor;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.SchemaUtils;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.util.CommonUtils;
import java.io.File;
import java.sql.Connection;
import java.util.List;

public abstract class AbstractFile2DataSourceCommand<T>
extends AbstractSchemaDataSourceCommand {
    private File[] files = null;
    private SqlExecutor sqlExecutor = DefaultSqlExecutor.getInstance();
    private Options schemaOptions = new Options();

    @Override
    protected void doRun() {
        List totalObjects = CommonUtils.list();
        ConvertHandler convertHandler = this.getConvertHandler();
        for (File file : this.getFiles()) {
            this.execute(() -> {
                DbCommonObject dbCommonObject = SchemaUtils.readXml((File)file);
                totalObjects.add(dbCommonObject);
            });
        }
        List convertedTotalObjects = convertHandler.handle(totalObjects);
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            this.handle(convertedTotalObjects, (Connection)connection, dialect);
        }));
    }

    protected void handle(List<DbCommonObject<?>> totalObjects, Connection connection, Dialect dialect) throws Exception {
        SqlFactoryRegistry sqlFactoryRegistry = this.getSqlFactoryRegistry(dialect);
        sqlFactoryRegistry.setOption(this.getSchemaOptions());
        List<T> list = this.getTarget(totalObjects, connection, dialect);
        list = this.filter(list);
        list = this.sort(list);
        this.handle((T)list, sqlFactoryRegistry, connection, dialect);
    }

    protected abstract List<T> getTarget(List<DbCommonObject<?>> var1, Connection var2, Dialect var3);

    protected List<T> filter(List<T> list) {
        return list;
    }

    protected List<T> sort(List<T> list) {
        return list;
    }

    protected void handle(List<T> list, SqlFactoryRegistry sqlFactoryRegistry, Connection connection, Dialect dialect) throws Exception {
        for (T obj : list) {
            this.handle(obj, sqlFactoryRegistry, connection, dialect);
        }
    }

    protected abstract void handle(T var1, SqlFactoryRegistry var2, Connection var3, Dialect var4) throws Exception;

    public SqlExecutor getSqlExecutor() {
        return this.sqlExecutor;
    }

    public void setSqlExecutor(SqlExecutor sqlExecutor) {
        this.sqlExecutor = sqlExecutor;
    }

    public File[] getFiles() {
        return this.files;
    }

    public void setFiles(File ... files) {
        if (files != null) {
            this.files = files;
        }
    }

    public Options getSchemaOptions() {
        return this.schemaOptions;
    }

    public void setSchemaOption(Options sqlOptions) {
        this.schemaOptions = sqlOptions;
    }

    public void setSqlOption(Options sqlOptions) {
        this.setSchemaOption(sqlOptions);
    }
}

