/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.export;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.export.AbstractExportCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableNameRowCollectionFilter;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.data.schemas.rowiterator.JdbcDynamicRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.JsonConverter;
import com.sqlapp.util.file.TextFileWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.Connection;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class ExportData2FileCommand
extends AbstractExportCommand {
    private boolean defaultExport = false;
    private WorkbookFileType outputFileType = WorkbookFileType.EXCEL2007;
    private String sheetName = "TABLE";
    private Converters converters = new Converters();

    @Override
    protected void doRun() {
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            SchemaReader schemaReader = this.getSchemaReader((Connection)connection, dialect);
            Map<String, Schema> schemaMap = this.getSchemas((Connection)connection, dialect, schemaReader, s -> true);
            RowIteratorHandler rowIteratorHandler = this.getRowIteratorHandler();
            schemaMap.forEach((k, v) -> v.setRowIteratorHandler(rowIteratorHandler));
            if (!this.getDirectory().exists()) {
                FileUtils.createParentDirectory((File)this.getDirectory());
                this.getDirectory().mkdir();
            }
            DoubleKeyMap execTables = CommonUtils.doubleKeyMap();
            for (Map.Entry<String, Schema> entry : schemaMap.entrySet()) {
                String k2 = entry.getKey();
                Schema v2 = entry.getValue();
                File targetDirectory = null;
                if (this.isUseSchemaNameDirectory()) {
                    File file = new File(this.getDirectory(), k2);
                    if (!file.exists()) {
                        file.mkdirs();
                        file.mkdir();
                    }
                    targetDirectory = file;
                } else {
                    targetDirectory = this.getDirectory();
                }
                for (Table t : v2.getTables()) {
                    this.writeTable(targetDirectory, t.getName(), t, this.getOutputFileType());
                    execTables.put((Object)t.getSchemaName(), (Object)t.getName(), (Object)t);
                }
                for (Synonym s2 : v2.getSynonyms()) {
                    Table table = s2.rootSynonym().getTable();
                    if (table == null || execTables.containsKey((Object)table.getSchemaName(), (Object)table.getName())) continue;
                    this.writeTable(targetDirectory, s2.getName(), table, this.getOutputFileType());
                }
            }
        }));
    }

    private void writeTable(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws Exception {
        if (this.getOutputFileType().isTextFile()) {
            if (this.getOutputFileType().isCsv()) {
                this.writeTableAsCsv(directory, filename, table, this.getOutputFileType());
            } else if (this.getOutputFileType().isXml()) {
                this.writeTableAsXml(directory, filename, table, this.getOutputFileType());
            } else if (this.getOutputFileType().isJson()) {
                this.writeTableAsJson(directory, filename, table, this.getOutputFileType());
            } else if (this.getOutputFileType().isJsonl()) {
                this.writeTableAsJsonl(directory, filename, table, this.getOutputFileType());
            } else if (this.getOutputFileType().isYaml()) {
                this.writeTableAsYaml(directory, filename, table, this.getOutputFileType());
            }
        } else {
            this.writeTableAsExcel(directory, filename, table, this.getOutputFileType());
        }
    }

    private void writeTableAsCsv(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws Exception {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, this.getCsvEncoding());
             BufferedWriter bw = new BufferedWriter(writer);
             TextFileWriter csvWriter = workbookFileType.createCsvListWriter((Writer)bw);){
            List<String> headers = table.getColumns().stream().map(c -> c.getName()).collect(Collectors.toList());
            csvWriter.writeHeader(headers.toArray(new String[0]));
            String[] values = new String[table.getColumns().size()];
            for (Row row : table.getRows()) {
                int i = 0;
                for (Column column : table.getColumns()) {
                    Object value = row.get(column);
                    values[i++] = column.getConverter().convertString(value);
                }
                csvWriter.writeRow(values);
            }
        }
    }

    private void writeTableAsXml(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws IOException, XMLStreamException {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        table.writeRowData(file);
    }

    private void writeTableAsJson(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws IOException, XMLStreamException {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
             BufferedWriter bw = new BufferedWriter(writer);){
            bw.write("[");
            boolean first = true;
            for (Row row : table.getRows()) {
                String text = this.getJsonConverter().toJsonString((Object)row.getValuesAsMapWithoutNullValue());
                if (!first) {
                    bw.write(",\n");
                } else {
                    bw.write("\n");
                    first = false;
                }
                bw.write(text);
            }
            bw.write("]");
        }
    }

    private void writeTableAsJsonl(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws IOException, XMLStreamException {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        JsonConverter converter = this.getJsonConverter().clone();
        converter.setIndentOutput(false);
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
             BufferedWriter bw = new BufferedWriter(writer);){
            for (Row row : table.getRows()) {
                String text = this.getJsonConverter().toJsonString((Object)row.getValuesAsMapWithoutNullValue());
                bw.write("\n");
                bw.write(text);
            }
        }
    }

    private void writeTableAsYaml(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws IOException, XMLStreamException {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
             BufferedWriter bw = new BufferedWriter(writer);){
            for (Row row : table.getRows()) {
                String text = this.getYamlConverter().toJsonString((Object)row.getValuesAsMapWithoutNullValue());
                bw.write(text);
            }
        }
    }

    private void writeTableAsExcel(File directory, String fileName, Table table, WorkbookFileType workbookFileType) throws FileNotFoundException, IOException, EncryptedDocumentException, InvalidFormatException {
        File file = new File(directory, fileName + "." + workbookFileType.getFileExtension());
        try (Workbook workbook = this.createWorkbook(workbookFileType, file);){
            Cell cell;
            Sheet sheet;
            if (file.exists()) {
                sheet = ExcelUtils.getFirstOrCreateSeet((Workbook)workbook, (String)this.getSheetName());
                ExcelUtils.clearCellValues((Sheet)sheet);
            } else {
                sheet = ExcelUtils.getFirstOrCreateSeet((Workbook)workbook, (String)this.getSheetName());
            }
            int rownum = 0;
            org.apache.poi.ss.usermodel.Row headerRow = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rownum++);
            int cellnum = 0;
            CreationHelper helper = workbook.getCreationHelper();
            for (Column column : table.getColumns()) {
                cell = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)headerRow, (int)cellnum++);
                ExcelUtils.setCell((Converters)this.converters, (Workbook)workbook, (Cell)cell, (Object)column.getName());
            }
            for (Row row : table.getRows()) {
                org.apache.poi.ss.usermodel.Row dataRow = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rownum++);
                cellnum = 0;
                for (Column column : table.getColumns()) {
                    Object obj = row.get(column);
                    if (obj != null) {
                        Cell cell2 = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)dataRow, (int)cellnum);
                        ExcelUtils.setCell((Converters)this.converters, (Workbook)workbook, (Cell)cell2, (Object)obj);
                    }
                    ++cellnum;
                }
            }
            cellnum = 0;
            for (Column column : table.getColumns()) {
                sheet.autoSizeColumn(cellnum);
                if (column.getRemarks() != null) {
                    cell = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)headerRow, (int)cellnum);
                    ExcelUtils.setComment((CreationHelper)helper, (Cell)cell, (String)column.getRemarks());
                }
                ++cellnum;
            }
            ExcelUtils.writeWorkbook((Workbook)workbook, (File)file);
        }
    }

    private Workbook createWorkbook(WorkbookFileType workbookFileType, File file) throws EncryptedDocumentException, InvalidFormatException, IOException {
        if (file.exists()) {
            return workbookFileType.createWorkBook(file);
        }
        return workbookFileType.createWorkbook();
    }

    protected RowIteratorHandler getRowIteratorHandler() {
        JdbcDynamicRowIteratorHandler rowIteratorHandler = new JdbcDynamicRowIteratorHandler();
        rowIteratorHandler.setDataSource(this.getDataSource());
        rowIteratorHandler.getOptions().setTableOptions(this.getTableOptions());
        TableNameRowCollectionFilter filter = new TableNameRowCollectionFilter();
        filter.setIncludes(this.getIncludeTables());
        filter.setExcludes(this.getExcludeTables());
        filter.setDefaultInclude(this.isDefaultExport());
        rowIteratorHandler.setFilter((Predicate)filter);
        return rowIteratorHandler;
    }

    public WorkbookFileType getOutputFileType() {
        return this.outputFileType;
    }

    public void setOutputFileType(WorkbookFileType outputFileType) {
        this.outputFileType = outputFileType;
    }

    public boolean isDefaultExport() {
        return this.defaultExport;
    }

    public void setDefaultExport(boolean defaultExport) {
        this.defaultExport = defaultExport;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }

    public Converters getConverters() {
        return this.converters;
    }

    public void setConverters(Converters converters) {
        this.converters = converters;
    }
}

