/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.OutputFormatType;
import com.sqlapp.data.db.command.generator.MultiTableFoundException;
import com.sqlapp.data.db.command.generator.TableNotFoundException;
import com.sqlapp.data.db.command.generator.factory.TableGeneratorSettingFactory;
import com.sqlapp.data.db.command.generator.setting.TableGeneratorSetting;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.util.SqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.db.sql.TableOptions;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.jdbc.function.SQLRunnable;
import com.sqlapp.jdbc.sql.GeneratedKeyInfo;
import com.sqlapp.jdbc.sql.JdbcBatchIterateHander;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.JdbcHandlerUtils;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.SqlParameterCollection;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.CountIterable;
import com.sqlapp.util.eval.CachedEvaluator;
import com.sqlapp.util.eval.mvel.CachedMvelEvaluator;
import com.sqlapp.util.eval.mvel.ParserContextFactory;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.mvel2.ParserContext;

public class GenerateDataInsertCommand
extends AbstractDataSourceCommand {
    private String schemaName;
    private String tableName;
    private File fileDirectory = new File("./");
    private long queryCommitInterval = Long.MAX_VALUE;
    private CachedEvaluator evaluator = new CachedMvelEvaluator();
    private TableOptions tableOptions = new TableOptions();
    private TableGeneratorSettingFactory generatorSettingFactory = new TableGeneratorSettingFactory();
    private static final String LOG_SEPARATOR_START = "<<========= ";
    private static final String LOG_SEPARATOR_END = " =========>>";
    private static final String MESSAGE_SEPARATOR_START = "-- ";
    private static final String MESSAGE_SEPARATOR_END = " --";

    @Override
    protected void doRun() {
        Map<String, TableGeneratorSetting> tableSettings;
        if (this.evaluator == null) {
            CachedMvelEvaluator ceval = new CachedMvelEvaluator();
            ParserContext mvelParserContext = ParserContextFactory.getInstance().getParserContext();
            ceval.setParserContext(mvelParserContext);
            this.evaluator = ceval;
        }
        try {
            tableSettings = this.readSetting();
        }
        catch (IOException | EncryptedDocumentException | InvalidFormatException e) {
            throw new RuntimeException(e);
        }
        if (tableSettings.isEmpty()) {
            this.info((Object)("File not found. settingDirectory=" + this.fileDirectory.getAbsolutePath()));
            return;
        }
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            CatalogReader catalogReader = dialect.getCatalogReader();
            TableReader tableReader = catalogReader.getSchemaReader().getTableReader();
            tableReader.setSchemaName(this.getSchemaName());
            tableReader.setObjectName(this.getTableName());
            List tableList = tableReader.getAllFull(connection);
            if (tableList.isEmpty()) {
                throw new TableNotFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName());
            }
            if (!CommonUtils.isEmpty((CharSequence)this.getTableName()) && !tableList.isEmpty()) {
                throw new MultiTableFoundException("schemaName=" + this.getSchemaName() + ", tableName=" + this.getTableName() + ", tableSize=" + tableList.size());
            }
            connection.setAutoCommit(false);
            for (Table table : tableList) {
                TableGeneratorSetting tableSetting = (TableGeneratorSetting)tableSettings.get(table.getName());
                if (tableSetting == null) continue;
                tableSetting.initializeTableColumnData(table);
                tableSetting.loadData((Connection)connection);
                tableSetting.setEvaluator(this.evaluator);
                tableSetting.calculateInitialObjectValues();
                this.applyFromFileByRow((Connection)connection, dialect, table, tableSetting);
                tableSettings.remove(table.getName());
            }
        }));
    }

    protected void applyFromFileByRow(Connection connection, Dialect dialect, Table table, TableGeneratorSetting tableSetting) throws SQLException {
        List<SqlNode> insertSqlNodes;
        String insertSql;
        long start = System.currentTimeMillis();
        LocalDateTime startLocalTime = LocalDateTime.now();
        int batchSize = (Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table);
        this.info(LOG_SEPARATOR_START, table.getName(), " Insert start. numberOfRows=[" + tableSetting.getNumberOfRows() + "]. batchSize=[", batchSize, "]. start=[", startLocalTime, "].", LOG_SEPARATOR_END);
        if (!CommonUtils.isBlank((CharSequence)tableSetting.getSetupSql())) {
            this.executeSql(connection, dialect, table, "Setup SQL", tableSetting.getSetupSql());
        }
        SqlConverter sqlConverter = this.getSqlConverter();
        if (CommonUtils.isBlank((CharSequence)tableSetting.getInsertSql())) {
            insertSql = this.getGeneratorSettingFactory().createInsertSql(table, dialect, this.getTableOptions(), SqlType.INSERT);
            insertSqlNodes = this.createSqlNode(dialect, sqlConverter, insertSql);
        } else {
            insertSql = tableSetting.getInsertSql().trim();
            insertSqlNodes = this.createSqlNode(dialect, sqlConverter, insertSql);
        }
        ParametersContext contextForStartValue = new ParametersContext();
        SqlNode startValueSqlNode = sqlConverter.parseSql(contextForStartValue, tableSetting.getStartValueSql());
        Table startTable = new Table();
        long[] startValueCounter = new long[1];
        SqlParameterCollection sqlParameterCollection = startValueSqlNode.eval((Object)contextForStartValue);
        this.execute(table.getName() + " Start Value SQL", () -> {
            this.info((Object)tableSetting.getStartValueSql());
            try (PreparedStatement statement = JdbcHandlerUtils.getStatement((Connection)connection, (SqlParameterCollection)sqlParameterCollection);
                 ResultSet resultSet = statement.executeQuery();){
                startTable.readMetaData(resultSet);
                while (resultSet.next()) {
                    startValueCounter[0] = startValueCounter[0] + 1L;
                }
            }
        });
        long total = tableSetting.getNumberOfRows() * startValueCounter[0];
        this.execute(table.getName() + " Insert SQL", () -> {
            try {
                this.info((Object)insertSql);
                long[] rowCount = new long[1];
                long[] insertedRowCount = new long[1];
                List valueList = null;
                try (PreparedStatement statement = JdbcHandlerUtils.getStatement((Connection)connection, (SqlParameterCollection)sqlParameterCollection);
                     ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        JdbcBatchIterateHander handler;
                        Map valueMap = CommonUtils.upperMap();
                        for (int j = 0; j < startTable.getColumns().size(); ++j) {
                            Object obj = resultSet.getObject(j + 1);
                            Column column = (Column)startTable.getColumns().get(j);
                            valueMap.put(column.getName(), obj);
                        }
                        if (tableSetting.getNumberOfRows() > 1L) {
                            tableSetting.setSqlStartValue(rowCount[0], valueMap);
                            CountIterable countIterable = new CountIterable(rowCount[0], rowCount[0] + tableSetting.getNumberOfRows(), i -> {
                                Map<String, Object> vals = tableSetting.generateValue((long)i, i - rowCount[0]);
                                return vals;
                            });
                            handler = this.createJdbcBatchIterateHander(connection, dialect, table, insertSqlNodes, total, tableSetting, insertedRowCount, o -> {
                                Map vals = (Map)o;
                                ParametersContext context = this.convertDataType(vals, table);
                                context.putAll(this.getContext());
                                return context;
                            });
                            handler.execute(connection, (Iterable)countIterable);
                            rowCount[0] = rowCount[0] + insertedRowCount[0];
                            continue;
                        }
                        if (valueList == null) {
                            valueList = CommonUtils.list();
                        }
                        tableSetting.setSqlStartValue(rowCount[0], valueMap);
                        Map<String, Object> convertedVals = tableSetting.generateValue(rowCount[0], 0L);
                        valueList.add(convertedVals);
                        if ((long)valueList.size() < (long)batchSize * this.getQueryCommitInterval()) continue;
                        handler = this.createJdbcBatchIterateHander(connection, dialect, table, insertSqlNodes, total, tableSetting, insertedRowCount, o -> {
                            Map vals = (Map)o;
                            ParametersContext context = this.convertDataType(vals, table);
                            context.putAll(this.getContext());
                            return context;
                        });
                        handler.execute(connection, (Iterable)valueList);
                        valueList.clear();
                        rowCount[0] = rowCount[0] + insertedRowCount[0];
                    }
                    if (!CommonUtils.isEmpty(valueList)) {
                        JdbcBatchIterateHander handler = this.createJdbcBatchIterateHander(connection, dialect, table, insertSqlNodes, total, tableSetting, insertedRowCount, o -> {
                            Map vals = (Map)o;
                            ParametersContext context = this.convertDataType(vals, table);
                            context.putAll(this.getContext());
                            return context;
                        });
                        handler.execute(connection, (Iterable)valueList);
                        valueList.clear();
                        rowCount[0] = rowCount[0] + insertedRowCount[0];
                    }
                }
            }
            catch (SQLException e) {
                throw e;
            }
            finally {
                table.setRowIteratorHandler(null);
            }
        });
        if (!CommonUtils.isBlank((CharSequence)tableSetting.getFinalizeSql())) {
            this.executeSql(connection, dialect, table, "Finalize SQL", tableSetting.getFinalizeSql());
            this.commit(connection);
        }
        long end = System.currentTimeMillis();
        LocalDateTime endLocalTime = LocalDateTime.now();
        this.info(LOG_SEPARATOR_START, table.getName(), " Insert completed. numberOfRows=[", total, "]. start=[", startLocalTime, "]. end=[", endLocalTime, "]. [", end - start, " ms].", LOG_SEPARATOR_END);
    }

    private List<SqlNode> createSqlNode(Dialect dialect, SqlConverter sqlConverter, String sql) {
        SqlSplitter splitter = dialect.createSqlSplitter();
        List splitResults = splitter.parse(sql);
        List<SqlNode> nodes = splitResults.stream().map(c -> {
            ParametersContext context = new ParametersContext();
            context.putAll(this.getContext());
            if (c.getTextType().isComment() || CommonUtils.isBlank((CharSequence)c.getText())) {
                return null;
            }
            SqlNode sqlNode = sqlConverter.parseSql(context, c.getText());
            return sqlNode;
        }).filter(c -> c != null).collect(Collectors.toList());
        return nodes;
    }

    private JdbcBatchIterateHander createJdbcBatchIterateHander(Connection connection, Dialect dialect, Table table, List<SqlNode> nodes, long total, TableGeneratorSetting tableSetting, long[] insertedRowCount, Function<Object, Object> valueConverter) {
        long oneper = total / 100L;
        long[] pointTime1 = new long[]{System.currentTimeMillis()};
        JdbcBatchIterateHander handler = new JdbcBatchIterateHander(nodes, ((Integer)this.getTableOptions().getDmlBatchSize().apply((Object)table)).intValue(), this.getQueryCommitInterval());
        handler.setValueConverter(valueConverter);
        handler.setBatchUpdateResultHandler(result -> {
            insertedRowCount[0] = insertedRowCount[0] + (long)result.getValues().size();
            int max = result.getGeneratedKeys().size();
            for (int i = 0; i < max; ++i) {
                GeneratedKeyInfo gk = (GeneratedKeyInfo)result.getGeneratedKeys().get(i);
                Map vals = (Map)((JdbcBatchIterateHander.ValueHolder)result.getValues().get(i)).value();
                vals.put(gk.getColumnName(), gk.getValue());
                vals.put(gk.getColumnLabel(), gk.getValue());
            }
            this.debug("execute query batch size=[", result.getResult().length, "]. [", result.getMillis(), " ms]");
            if (oneper == 0L) {
                long pointTime2 = System.currentTimeMillis();
                this.info("100% insert completed.[", String.format("%3s", insertedRowCount[0]), "/", total, "]. [", pointTime2 - pointTime1[0], " ms]");
                pointTime1[0] = pointTime2;
            } else if ((result.getLastRowIndex() + 1L) % oneper == 0L) {
                long pointTime2 = System.currentTimeMillis();
                this.info(String.format("%3s", insertedRowCount[0] / oneper), "% insert completed.[", String.format("%3s", insertedRowCount[0]), "/", total, "]. [", pointTime2 - pointTime1[0], " ms]");
                pointTime1[0] = pointTime2;
            }
        });
        this.commit(connection);
        return handler;
    }

    private void executeSql(Connection connection, Dialect dialect, Table table, String type, String sql) throws SQLException {
        this.execute(table.getName() + " " + type, () -> {
            SqlSplitter sqlSplitter = dialect.createSqlSplitter();
            SqlConverter sqlConverter = this.getSqlConverter();
            this.executeSql(sqlSplitter, sqlConverter, dialect, connection, sql);
        });
    }

    private void execute(String type, SQLRunnable run) throws SQLException {
        long start = System.currentTimeMillis();
        LocalDateTime startLocalTime = LocalDateTime.now();
        this.info(MESSAGE_SEPARATOR_START, type, " start. start=[", startLocalTime, "].", MESSAGE_SEPARATOR_END);
        try {
            run.run();
            LocalDateTime endLocalTime = LocalDateTime.now();
            long end = System.currentTimeMillis();
            this.info(MESSAGE_SEPARATOR_START, type, " completed. end=[", endLocalTime, "]. [", end - start, " ms].", MESSAGE_SEPARATOR_END);
        }
        catch (RuntimeException e) {
            LocalDateTime endLocalTime = LocalDateTime.now();
            long end = System.currentTimeMillis();
            this.error(e, MESSAGE_SEPARATOR_START, type, " errored. end=[", endLocalTime, "]. [", end - start, " ms].", MESSAGE_SEPARATOR_END);
            throw e;
        }
    }

    private void executeSql(SqlSplitter sqlSplitter, SqlConverter sqlConverter, Dialect dialect, Connection connection, String sql) throws SQLException {
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        List sqls = sqlSplitter.parse(sql);
        for (SqlSplitter.SplitResult splitResult : sqls) {
            if (splitResult.getTextType().isComment()) continue;
            this.info((Object)splitResult.getText());
            this.executeSql(sqlConverter, dialect, connection, splitResult);
        }
    }

    private void executeSql(SqlConverter sqlConverter, Dialect dialect, Connection connection, SqlSplitter.SplitResult splitResult) throws SQLException {
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        SqlNode sqlNode = sqlConverter.parseSql(context, splitResult.getText());
        OutputFormatType outputFormatType = OutputFormatType.TSV;
        Table table = new Table();
        table.setDialect(dialect);
        JdbcHandler jdbcHandler = dialect.createJdbcHandler(sqlNode, rs -> {
            StringBuilder builder;
            boolean first = false;
            if (table.getColumns().size() == 0) {
                table.readMetaData((ResultSet)rs);
                builder = new StringBuilder();
                for (Column column : table.getColumns()) {
                    builder.append(column.getName());
                    builder.append(outputFormatType.getSeparator());
                }
                this.info((Object)builder.substring(0, builder.length() - 1));
                first = true;
            }
            builder = new StringBuilder();
            int size = table.getColumns().size();
            for (int i = 1; i <= size; ++i) {
                Object obj = rs.getObject(i);
                Column column = (Column)table.getColumns().get(i - 1);
                String text = dialect.getValueForDisplay(column, obj);
                builder.append(text);
                builder.append(outputFormatType.getSeparator());
            }
            String text = builder.substring(0, builder.length() - 1);
            if (first) {
                this.info((Object)this.getCharText("-", 10));
            }
            this.info((Object)text);
        });
        jdbcHandler.execute(connection, context);
    }

    private String getCharText(String text, int len) {
        StringBuilder builder = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            builder.append(text);
        }
        return builder.toString();
    }

    private ParametersContext convertDataType(Map<String, Object> map, Table table) {
        ParametersContext context = new ParametersContext();
        context.putAll(map);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            Column column = (Column)table.getColumns().get(entry.getKey());
            if (column == null) continue;
            Object val = Converters.getDefault().convertObject(entry.getValue(), column.getDataType().getDefaultClass());
            context.put(entry.getKey(), val);
        }
        return context;
    }

    private Map<String, TableGeneratorSetting> readSetting() throws EncryptedDocumentException, InvalidFormatException, IOException {
        if (this.getFileDirectory() == null) {
            return Collections.emptyMap();
        }
        File[] files = this.getFileDirectory().listFiles();
        if (files == null) {
            return Collections.emptyMap();
        }
        Map ret = CommonUtils.caseInsensitiveMap();
        for (File file : files) {
            TableGeneratorSetting setting = this.getGeneratorSettingFactory().fromFile(file);
            if (setting == null) continue;
            ret.put(setting.getName(), setting);
        }
        return ret;
    }

    protected SqlConverter getSqlConverter() {
        SqlConverter sqlConverter = new SqlConverter();
        return sqlConverter;
    }

    public void setDmlBatchSize(int batchSize) {
        this.getTableOptions().setDmlBatchSize(batchSize);
    }

    @Generated
    public String getSchemaName() {
        return this.schemaName;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public File getFileDirectory() {
        return this.fileDirectory;
    }

    @Generated
    public long getQueryCommitInterval() {
        return this.queryCommitInterval;
    }

    @Generated
    public CachedEvaluator getEvaluator() {
        return this.evaluator;
    }

    @Generated
    public TableOptions getTableOptions() {
        return this.tableOptions;
    }

    @Generated
    public TableGeneratorSettingFactory getGeneratorSettingFactory() {
        return this.generatorSettingFactory;
    }

    @Generated
    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    @Generated
    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    @Generated
    public void setFileDirectory(File fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    @Generated
    public void setQueryCommitInterval(long queryCommitInterval) {
        this.queryCommitInterval = queryCommitInterval;
    }

    @Generated
    public void setEvaluator(CachedEvaluator evaluator) {
        this.evaluator = evaluator;
    }

    @Generated
    public void setTableOptions(TableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    @Generated
    public void setGeneratorSettingFactory(TableGeneratorSettingFactory generatorSettingFactory) {
        this.generatorSettingFactory = generatorSettingFactory;
    }
}

