/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.setting;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import lombok.Generated;

public class QueryGeneratorSetting {
    @JsonProperty(index=0)
    private String generationGroup;
    @JsonProperty(index=1)
    private String selectSql;
    @JsonIgnore
    private final List<Map<String, Object>> values = CommonUtils.list();

    public void loadData(Connection conn) throws SQLException {
        try (Statement stmt = conn.createStatement(1003, 1007);
             ResultSet rs = stmt.executeQuery(this.selectSql);){
            Map indexNamelMap = CommonUtils.map();
            ResultSetMetaData resultSetMetaData = rs.getMetaData();
            int colCount = resultSetMetaData.getColumnCount();
            for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                String label = resultSetMetaData.getColumnLabel(i);
                indexNamelMap.put(i - 1, label.intern());
            }
            while (rs.next()) {
                Map map = CommonUtils.map();
                for (int i = 0; i < colCount; ++i) {
                    String name = (String)indexNamelMap.get(i);
                    Object value = rs.getObject(i + 1);
                    map.put(name.intern(), value);
                }
                this.values.add(map);
            }
        }
    }

    public Map<String, Object> getValueMap(int i) {
        if (this.values.isEmpty()) {
            return Collections.emptyMap();
        }
        int size = this.values.size();
        int pos = i % size;
        return this.values.get(pos);
    }

    @Generated
    public String getGenerationGroup() {
        return this.generationGroup;
    }

    @Generated
    public String getSelectSql() {
        return this.selectSql;
    }

    @Generated
    public List<Map<String, Object>> getValues() {
        return this.values;
    }

    @JsonProperty(index=0)
    @Generated
    public void setGenerationGroup(String generationGroup) {
        this.generationGroup = generationGroup;
    }

    @JsonProperty(index=1)
    @Generated
    public void setSelectSql(String selectSql) {
        this.selectSql = selectSql;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof QueryGeneratorSetting)) {
            return false;
        }
        QueryGeneratorSetting other = (QueryGeneratorSetting)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$generationGroup = this.getGenerationGroup();
        String other$generationGroup = other.getGenerationGroup();
        if (this$generationGroup == null ? other$generationGroup != null : !this$generationGroup.equals(other$generationGroup)) {
            return false;
        }
        String this$selectSql = this.getSelectSql();
        String other$selectSql = other.getSelectSql();
        return !(this$selectSql == null ? other$selectSql != null : !this$selectSql.equals(other$selectSql));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof QueryGeneratorSetting;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $generationGroup = this.getGenerationGroup();
        result = result * 59 + ($generationGroup == null ? 43 : $generationGroup.hashCode());
        String $selectSql = this.getSelectSql();
        result = result * 59 + ($selectSql == null ? 43 : $selectSql.hashCode());
        return result;
    }
}

