/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractDataSourceCommand;
import com.sqlapp.data.db.command.OutputFormatType;
import com.sqlapp.data.db.command.properties.OutputFormatTypeProperty;
import com.sqlapp.data.db.command.properties.SqlProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import lombok.Generated;

abstract class AbstractSqlQueryCommand
extends AbstractDataSourceCommand
implements OutputFormatTypeProperty,
SqlProperty {
    private String sql = null;
    private OutputFormatType outputFormatType = OutputFormatType.TSV;

    AbstractSqlQueryCommand() {
    }

    @Override
    protected void doRun() {
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            try (Statement statement = connection.createStatement(1003, 1007);
                 ResultSet resultSet = statement.executeQuery(this.getSql());){
                Table table = new Table();
                table.setDialect(dialect);
                table.readMetaData(resultSet);
                if (this.getOutputFormatType().isTable()) {
                    table.readData(resultSet);
                    this.outputTableData(dialect, table);
                } else {
                    this.outputTableData(dialect, table, resultSet);
                }
            }
        }));
    }

    protected abstract void outputTableData(Dialect var1, Table var2) throws Exception;

    protected abstract void outputTableData(Dialect var1, Table var2, ResultSet var3) throws SQLException, IOException, Exception;

    @Override
    @Generated
    public String getSql() {
        return this.sql;
    }

    @Override
    @Generated
    public OutputFormatType getOutputFormatType() {
        return this.outputFormatType;
    }

    @Override
    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Override
    @Generated
    public void setOutputFormatType(OutputFormatType outputFormatType) {
        this.outputFormatType = outputFormatType;
    }
}

