/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command;

import com.sqlapp.data.db.command.AbstractTableCommand;
import com.sqlapp.data.db.command.properties.CommitPerSqlTypeProperty;
import com.sqlapp.data.db.command.properties.CommitPerTableProperty;
import com.sqlapp.data.db.command.properties.SqlTypesProperty;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.db.sql.SqlType;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.DbCommonObject;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.jdbc.function.ExceptionConsumer;
import com.sqlapp.jdbc.sql.JdbcHandler;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.util.Comparator;
import java.util.List;
import lombok.Generated;

public class TableSqlExecuteCommand
extends AbstractTableCommand
implements CommitPerTableProperty,
CommitPerSqlTypeProperty,
SqlTypesProperty {
    private SqlType[] sqlTypes = null;
    private SqlConverter sqlConverter = new SqlConverter();
    private IterationMethod iterationMethod = IterationMethod.TABLE;

    @Override
    protected void doRun() {
        this.execute(this.getDataSource(), (ExceptionConsumer<Connection>)((ExceptionConsumer)connection -> {
            Dialect dialect = this.getDialect((Connection)connection);
            List<Table> tables = this.getTables((Connection)connection, dialect);
            SqlFactoryRegistry sqlFactoryRegistry = dialect.createSqlFactoryRegistry();
            sqlFactoryRegistry.getOption().setTableOptions(this.getTableOptions());
            connection.setAutoCommit(false);
            if (this.getIterationMethod().isTable()) {
                for (Table table : tables) {
                    for (SqlType sqlType : this.getSqlTypes()) {
                        List sqlOperations = sqlFactoryRegistry.createSql((DbCommonObject)table, sqlType);
                        ParametersContext context = new ParametersContext();
                        context.putAll(this.getContext());
                        for (SqlOperation operation : sqlOperations) {
                            SqlNode sqlNode = this.sqlConverter.parseSql(context, operation.getSqlText());
                            JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                            jdbcHandler.execute(connection, context);
                        }
                        if (!this.getTableOptions().getCommitPerSqlType().test((Object)sqlType)) continue;
                        this.commit((Connection)connection);
                    }
                    if (!this.getTableOptions().getCommitPerTable().test((Object)table)) continue;
                    this.commit((Connection)connection);
                }
            } else {
                for (SqlType sqlType : this.getSqlTypes()) {
                    Comparator comp = sqlType.getTableComparator();
                    if (comp != null) {
                        tables.sort(comp);
                    }
                    for (Table table : tables) {
                        List sqlOperations = sqlFactoryRegistry.createSql((DbCommonObject)table, sqlType);
                        ParametersContext context = new ParametersContext();
                        context.putAll(this.getContext());
                        for (SqlOperation operation : sqlOperations) {
                            SqlNode sqlNode = this.sqlConverter.parseSql(context, operation.getSqlText());
                            JdbcHandler jdbcHandler = new JdbcHandler(sqlNode);
                            jdbcHandler.execute(connection, context);
                        }
                        if (!this.getTableOptions().getCommitPerTable().test((Object)table)) continue;
                        this.commit((Connection)connection);
                    }
                    if (!this.getTableOptions().getCommitPerSqlType().test((Object)sqlType)) continue;
                    this.commit((Connection)connection);
                }
            }
            this.commit((Connection)connection);
        }));
    }

    @Override
    public void setSqlTypes(SqlType ... sqlTypes) {
        this.sqlTypes = sqlTypes;
    }

    @Override
    public void setSqlTypes(String ... obj) {
        List list = CommonUtils.list();
        for (String sqlType : obj) {
            SqlType enm = SqlType.parse((String)sqlType);
            if (enm == null) continue;
            list.add(enm);
        }
        this.setSqlTypes(list.toArray(new SqlType[0]));
    }

    @Override
    public void setCommitPerTable(boolean bool) {
        this.getTableOptions().setCommitPerTable(bool);
    }

    @Override
    public void setCommitPerSqlType(boolean bool) {
        this.getTableOptions().setCommitPerSqlType(bool);
    }

    @Override
    @Generated
    public SqlType[] getSqlTypes() {
        return this.sqlTypes;
    }

    @Generated
    public SqlConverter getSqlConverter() {
        return this.sqlConverter;
    }

    @Generated
    public IterationMethod getIterationMethod() {
        return this.iterationMethod;
    }

    @Generated
    public void setSqlConverter(SqlConverter sqlConverter) {
        this.sqlConverter = sqlConverter;
    }

    @Generated
    public void setIterationMethod(IterationMethod iterationMethod) {
        this.iterationMethod = iterationMethod;
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum IterationMethod {
        TABLE{

            @Override
            public boolean isTable() {
                return true;
            }
        }
        ,
        SQL_TYPE;


        public boolean isTable() {
            return false;
        }
    }
}

