/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.generator.factory;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.generator.factory.ColumnDefaultCharacterExpression;
import com.sqlapp.data.db.command.generator.factory.ColumnUUIDExpression;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.function.ColumnFunction;
import java.time.LocalDate;

public class ColumnMinValue
implements ColumnFunction<String> {
    private static final long serialVersionUID = -2049712084354162318L;
    private ColumnDefaultCharacterExpression charExpression = new ColumnDefaultCharacterExpression();
    private ColumnUUIDExpression uuidExpression = new ColumnUUIDExpression();

    public String apply(Column column) {
        if (column.getDataType() == DataType.BOOLEAN) {
            return "true";
        }
        if (column.getDataType() == DataType.DOUBLE) {
            return "1.0d";
        }
        if (column.getDataType() == DataType.FLOAT) {
            return "1.0f";
        }
        if (column.getDataType().isNumeric()) {
            return "" + Converters.getNewBooleanTrueInstance().convertObject((Object)1, column.getDataType().getDefaultClass());
        }
        if (column.getDataType() == DataType.TIMESTAMP || column.getDataType() == DataType.DATETIME) {
            LocalDate dt = LocalDate.now();
            return "LocalDateTime.of(" + dt.getYear() + "," + dt.getMonthValue() + ",1,0,0,0)";
        }
        if (column.getDataType() == DataType.TIME) {
            return "LocalTime.of(0,0,0)";
        }
        if (column.getDataType() == DataType.DATE) {
            LocalDate dt = LocalDate.now();
            return "LocalDate.of(" + dt.getYear() + "," + dt.getMonthValue() + ",1)";
        }
        if (column.getDataType().isCharacter()) {
            return this.charExpression.apply(column);
        }
        if (column.getDataType() == DataType.UUID) {
            return this.uuidExpression.apply(column);
        }
        return null;
    }
}

