/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.html;

import com.sqlapp.data.db.command.html.Renderer;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.util.FileUtils;
import java.io.File;
import java.util.ConcurrentModificationException;
import java.util.Map;
import org.mvel2.ParserContext;
import org.mvel2.templates.CompiledTemplate;
import org.mvel2.templates.TemplateCompiler;
import org.mvel2.templates.TemplateRuntime;

public class HtmlRenderer
extends Renderer {
    private CompiledTemplate compiledLayoutTemplate = null;
    private String layoutTemplate;

    public HtmlRenderer() {
        this.setLayoutTemplate(this.readResource("basicLayout.html"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void compile() {
        HtmlRenderer htmlRenderer = this;
        synchronized (htmlRenderer) {
            if (this.layoutTemplate != null) {
                this.compiledLayoutTemplate = TemplateCompiler.compileTemplate((String)this.convertInclude(this.layoutTemplate), (ParserContext)this.getRenderOptions().getParserContext());
            }
            super.compile();
        }
    }

    @Override
    public String render(ParametersContext context) {
        this.initializeContext(context);
        return this.execute(context);
    }

    @Override
    protected void initializeContext(ParametersContext context) {
    }

    private String execute(ParametersContext context) {
        if (this.getCompiledTemplate() == null) {
            this.compile();
        }
        if (!context.containsKeyInternal((Object)"renderOptions")) {
            context.put("renderOptions", (Object)this.getRenderOptions());
        }
        String text = this.executeTemplate(this.getCompiledTemplate(), context);
        if (this.compiledLayoutTemplate != null) {
            context.put("body", (Object)text);
            String result = this.executeTemplate(this.compiledLayoutTemplate, context);
            return result;
        }
        return text;
    }

    private String executeTemplate(CompiledTemplate compiled, ParametersContext context) {
        while (true) {
            try {
                String text = (String)TemplateRuntime.execute((CompiledTemplate)compiled, (Map)context);
                return text;
            }
            catch (ConcurrentModificationException e) {
                continue;
            }
            break;
        }
    }

    public void setLayoutTemplate(File file) {
        this.layoutTemplate = FileUtils.readText((File)file, (String)"utf8");
    }

    public void setLayoutTemplate(String layoutTemplate) {
        this.layoutTemplate = layoutTemplate;
    }
}

