/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.export;

import com.sqlapp.data.converter.Converters;
import com.sqlapp.data.db.command.export.AbstractExportCommand;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.sql.Options;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Row;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.TableNameRowCollectionFilter;
import com.sqlapp.data.schemas.rowiterator.ExcelUtils;
import com.sqlapp.data.schemas.rowiterator.JdbcDynamicRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.DoubleKeyMap;
import com.sqlapp.util.FileUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.supercsv.io.ICsvListWriter;

public class ExportData2FileCommand
extends AbstractExportCommand {
    private boolean defaultExport = false;
    private WorkbookFileType outputFileType = WorkbookFileType.EXCEL2007;
    private Options options = null;
    private String sheetName = "TABLE";
    private Converters converters = new Converters();

    @Override
    protected void doRun() {
        Dialect dialect = this.getDialect();
        SchemaReader schemaReader = null;
        try {
            schemaReader = this.getSchemaReader(dialect);
        }
        catch (SQLException e) {
            this.getExceptionHandler().handle((Throwable)e);
        }
        Map<String, Schema> schemaMap = this.getSchemas(dialect, schemaReader);
        RowIteratorHandler rowIteratorHandler = this.getRowIteratorHandler();
        schemaMap.forEach((k, v) -> v.setRowIteratorHandler(rowIteratorHandler));
        if (!this.getDirectory().exists()) {
            FileUtils.createParentDirectory((File)this.getDirectory());
            this.getDirectory().mkdir();
        }
        DoubleKeyMap execTables = CommonUtils.doubleKeyMap();
        schemaMap.forEach((k, v) -> {
            File targetDirectory = null;
            if (this.isUseSchemaNameDirectory()) {
                File file = new File(this.getDirectory(), (String)k);
                if (!file.exists()) {
                    file.mkdirs();
                    file.mkdir();
                }
                targetDirectory = file;
            } else {
                targetDirectory = this.getDirectory();
            }
            for (Table t : v.getTables()) {
                try {
                    this.writeTable(targetDirectory, t.getName(), t, this.getOutputFileType());
                    execTables.put((Object)t.getSchemaName(), (Object)t.getName(), (Object)t);
                }
                catch (FileNotFoundException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (EncryptedDocumentException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (XMLStreamException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (InvalidFormatException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (IOException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
            }
            for (Synonym s : v.getSynonyms()) {
                Table table = s.rootSynonym().getTable();
                if (table == null || execTables.containsKey((Object)table.getSchemaName(), (Object)table.getName())) continue;
                try {
                    this.writeTable(targetDirectory, s.getName(), table, this.getOutputFileType());
                }
                catch (FileNotFoundException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (EncryptedDocumentException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (XMLStreamException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (InvalidFormatException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
                catch (IOException e) {
                    this.getExceptionHandler().handle((Throwable)e);
                }
            }
        });
    }

    private void writeTable(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws FileNotFoundException, IOException, EncryptedDocumentException, InvalidFormatException, XMLStreamException {
        if (this.getOutputFileType().isTextFile()) {
            if (this.getOutputFileType().isCsv()) {
                this.writeTableAsCsv(directory, filename, table, this.getOutputFileType());
            } else if (this.getOutputFileType().isXml()) {
                this.writeTableAsXml(directory, filename, table, this.getOutputFileType());
            } else {
                this.writeTableAsJson(directory, filename, table, this.getOutputFileType());
            }
        } else {
            this.writeTableAsExcel(directory, filename, table, this.getOutputFileType());
        }
    }

    private void writeTableAsCsv(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws IOException {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, this.getCsvEncoding());
             BufferedWriter bw = new BufferedWriter(writer);
             ICsvListWriter csvWriter = workbookFileType.createCsvListWriter((Writer)bw);){
            List<String> headers = table.getColumns().stream().map(c -> c.getName()).collect(Collectors.toList());
            csvWriter.writeHeader(headers.toArray(new String[0]));
            String[] values = new String[table.getColumns().size()];
            for (Row row : table.getRows()) {
                int i = 0;
                for (Column column : table.getColumns()) {
                    Object value = row.get(column);
                    values[i++] = column.getConverter().convertString(value);
                }
                csvWriter.write(values);
            }
        }
    }

    private void writeTableAsXml(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws IOException, XMLStreamException {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        table.writeRowData(file);
    }

    private void writeTableAsJson(File directory, String filename, Table table, WorkbookFileType workbookFileType) throws IOException, XMLStreamException {
        File file = new File(directory, filename + "." + workbookFileType.getFileExtension());
        try (FileOutputStream fos = new FileOutputStream(file);
             OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fos, "UTF8");
             BufferedWriter bw = new BufferedWriter(writer);){
            bw.write("[");
            boolean first = true;
            for (Row row : table.getRows()) {
                String text = this.getJsonConverter().toJsonString((Object)row.getValuesAsMapWithoutNullValue());
                if (!first) {
                    bw.write(",\n");
                } else {
                    bw.write("\n");
                    first = false;
                }
                bw.write(text);
            }
            bw.write("]");
        }
    }

    private void writeTableAsExcel(File directory, String fileName, Table table, WorkbookFileType workbookFileType) throws FileNotFoundException, IOException, EncryptedDocumentException, InvalidFormatException {
        Cell cell;
        Sheet sheet;
        Workbook workbook;
        File file = new File(directory, fileName + "." + workbookFileType.getFileExtension());
        if (file.exists()) {
            workbook = WorkbookFileType.createWorkBook((File)file);
            sheet = ExcelUtils.getFirstOrCreateSeet((Workbook)workbook, (String)this.getSheetName());
            ExcelUtils.clearCellValues((Sheet)sheet);
        } else {
            workbook = workbookFileType.createWorkbook();
            sheet = ExcelUtils.getFirstOrCreateSeet((Workbook)workbook, (String)this.getSheetName());
        }
        int rownum = 0;
        org.apache.poi.ss.usermodel.Row headerRow = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rownum++);
        int cellnum = 0;
        CreationHelper helper = workbook.getCreationHelper();
        for (Column column : table.getColumns()) {
            cell = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)headerRow, (int)cellnum++);
            ExcelUtils.setCell((Converters)this.converters, (Workbook)workbook, (Cell)cell, (Object)column.getName());
        }
        for (Row row : table.getRows()) {
            org.apache.poi.ss.usermodel.Row dataRow = ExcelUtils.getOrCreateRow((Sheet)sheet, (int)rownum++);
            cellnum = 0;
            for (Column column : table.getColumns()) {
                Object obj = row.get(column);
                if (obj != null) {
                    Cell cell2 = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)dataRow, (int)cellnum);
                    ExcelUtils.setCell((Converters)this.converters, (Workbook)workbook, (Cell)cell2, (Object)obj);
                }
                ++cellnum;
            }
        }
        cellnum = 0;
        for (Column column : table.getColumns()) {
            sheet.autoSizeColumn(cellnum);
            if (column.getRemarks() != null) {
                cell = ExcelUtils.getOrCreateCell((org.apache.poi.ss.usermodel.Row)headerRow, (int)cellnum);
                ExcelUtils.setComment((CreationHelper)helper, (Cell)cell, (String)column.getRemarks());
            }
            ++cellnum;
        }
        ExcelUtils.writeWorkbook((Workbook)workbook, (File)file);
    }

    protected RowIteratorHandler getRowIteratorHandler() {
        JdbcDynamicRowIteratorHandler rowIteratorHandler = new JdbcDynamicRowIteratorHandler();
        rowIteratorHandler.setDataSource(this.getDataSource());
        rowIteratorHandler.setOption(this.getOptions());
        TableNameRowCollectionFilter filter = new TableNameRowCollectionFilter();
        filter.setIncludes(this.getIncludeTables());
        filter.setExcludes(this.getExcludeTables());
        filter.setDefaultInclude(this.isDefaultExport());
        rowIteratorHandler.setFilter((Predicate)filter);
        return rowIteratorHandler;
    }

    public WorkbookFileType getOutputFileType() {
        return this.outputFileType;
    }

    public void setOutputFileType(WorkbookFileType outputFileType) {
        this.outputFileType = outputFileType;
    }

    public Options getOptions() {
        return this.options;
    }

    public void setOption(Options options) {
        this.options = options;
    }

    public boolean isDefaultExport() {
        return this.defaultExport;
    }

    public void setDefaultExport(boolean defaultExport) {
        this.defaultExport = defaultExport;
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public void setSheetName(String sheetName) {
        this.sheetName = sheetName;
    }
}

