/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.command.export;

import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Catalog;
import com.sqlapp.data.schemas.RowIteratorHandler;
import com.sqlapp.data.schemas.Schema;
import com.sqlapp.data.schemas.SchemaCollection;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.data.schemas.Table;
import com.sqlapp.data.schemas.function.RowValueConverter;
import com.sqlapp.data.schemas.rowiterator.CombinedRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.CsvRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.ExcelRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.JsonRowIteratorHandler;
import com.sqlapp.data.schemas.rowiterator.WorkbookFileType;
import com.sqlapp.data.schemas.rowiterator.XmlRowIteratorHandler;
import com.sqlapp.exceptions.InvalidValueException;
import com.sqlapp.jdbc.sql.SqlConverter;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.FileUtils;
import com.sqlapp.util.JsonConverter;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;

public class TableFileReader {
    private File directory = null;
    private boolean useSchemaNameDirectory = false;
    private String csvEncoding = Charset.defaultCharset().toString();
    private int csvSkipHeaderRowsSize = 1;
    private boolean useTableNameDirectory = false;
    private JsonConverter jsonConverter = this.createJsonConverter();
    private File fileDirectory = null;
    private Predicate<File> fileFilter = f -> true;
    private String placeholderPrefix = "${";
    private String placeholderSuffix = "}";
    private boolean placeholders = false;
    private Map<String, Object> context = CommonUtils.linkedMap();

    public List<TableFilesPair> getTableFilePairs(Catalog catalog) {
        List<TableFilePair> tableFilePairs;
        File[] directories;
        Set schemaNames = CommonUtils.lowerSet();
        if (this.isUseSchemaNameDirectory() && (directories = this.getDirectory().listFiles(c -> c.isDirectory())) != null) {
            for (File directory : directories) {
                String name = directory.getName();
                schemaNames.add(name);
            }
        }
        if (this.isUseSchemaNameDirectory()) {
            File[] directories2 = this.getDirectory().listFiles(c -> c.isDirectory());
            tableFilePairs = CommonUtils.list();
            if (directories2 != null) {
                for (File directory : directories2) {
                    Schema schema = (Schema)catalog.getSchemas().get(directory.getName());
                    if (schema == null) continue;
                    tableFilePairs.addAll(this.getTableFilePairs(directory, schema));
                }
            }
        } else {
            tableFilePairs = this.getTableFilePairs(this.getDirectory(), catalog.getSchemas());
        }
        List<TableFilesPair> tfs = this.toTableFilesPairs(tableFilePairs);
        Set tables = tfs.stream().map(tf -> tf.getTable()).collect(Collectors.toSet());
        List notExists = CommonUtils.list();
        catalog.getSchemas().forEach(s -> s.getTables().forEach(t -> {
            if (!tables.contains(t)) {
                notExists.add(t);
            }
        }));
        notExists.forEach(t -> {
            TableFilesPair tf = new TableFilesPair((Table)t, Collections.emptyList());
            tfs.add(tf);
        });
        return tfs;
    }

    public void setFiles(List<TableFilesPair> tfs) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException {
        for (TableFilesPair tf : tfs) {
            this.readFiles(tf.getTable(), tf.getFiles());
        }
    }

    private List<TableFilesPair> toTableFilesPairs(List<TableFilePair> tableFilePairs) {
        Map tableFileMap = CommonUtils.linkedMap();
        tableFilePairs.forEach(c -> {
            List files = (List)tableFileMap.get(c.getTable());
            if (files == null) {
                files = CommonUtils.list();
                tableFileMap.put(c.getTable(), files);
            }
            files.add(c.getFile());
        });
        List tables = CommonUtils.list(tableFileMap.keySet());
        List<TableFilesPair> result = tables.stream().map(t -> {
            List files = (List)tableFileMap.get(t);
            TableFilesPair tfs = new TableFilesPair((Table)t, files);
            return tfs;
        }).collect(Collectors.toList());
        return result;
    }

    private List<TableFilePair> getTableFilePairs(File directory, SchemaCollection schemas) {
        Map tables = CommonUtils.linkedMap();
        schemas.forEach(schema -> {
            schema.getTables().forEach(t -> {
                TableFilePair pair = new TableFilePair((Table)t);
                tables.put(t.getName(), pair);
            });
            schema.getSynonyms().forEach(t -> {
                TableFilePair pair = new TableFilePair((Synonym)t);
                if (!tables.containsKey(t.getName())) {
                    tables.put(t.getName(), pair);
                }
            });
        });
        File[] files = null;
        if (directory != null && directory.exists()) {
            files = directory.listFiles();
        }
        List<TableFilePair> result = this.getTableFilePairWithFile(files, name -> (TableFilePair)tables.get(name));
        return result;
    }

    private List<TableFilePair> getTableFilePairs(File directory, Schema schema) {
        return this.getTableFilePairWithFile(directory.listFiles(), name -> {
            Table table = (Table)schema.getTables().get(name);
            if (table != null) {
                TableFilePair pair = new TableFilePair(table);
                return pair;
            }
            Synonym synonym = (Synonym)schema.getSynonyms().get(name);
            if (synonym != null) {
                TableFilePair pair = new TableFilePair(synonym);
                return pair;
            }
            return null;
        });
    }

    private List<TableFilePair> getTableFilePairWithFile(File[] files, Function<String, TableFilePair> func) {
        List result = CommonUtils.list();
        if (files == null) {
            return result;
        }
        List fs = Arrays.stream(files).filter(f -> f.isFile()).filter(f -> WorkbookFileType.parse((File)f) != null).filter(f -> this.fileFilter.test((File)f)).collect(Collectors.toList());
        for (File file : fs) {
            String name = FileUtils.getFileNameWithoutExtension((File)file);
            TableFilePair pair = func.apply(name);
            if (pair == null) continue;
            pair.setFile(file);
            result.add(pair);
        }
        return result;
    }

    private SqlConverter getSqlConverter() {
        SqlConverter sqlConverter = new SqlConverter();
        sqlConverter.getExpressionConverter().setFileDirectory(this.getFileDirectory());
        sqlConverter.getExpressionConverter().setPlaceholderPrefix(this.getPlaceholderPrefix());
        sqlConverter.getExpressionConverter().setPlaceholderSuffix(this.getPlaceholderSuffix());
        sqlConverter.getExpressionConverter().setPlaceholders(this.isPlaceholders());
        return sqlConverter;
    }

    private void readFiles(Table table, List<File> files) throws EncryptedDocumentException, InvalidFormatException, IOException, XMLStreamException {
        List handlers = files.stream().map(file -> {
            WorkbookFileType workbookFileType = WorkbookFileType.parse((File)file);
            if (workbookFileType.isTextFile()) {
                if (workbookFileType.isCsv()) {
                    return new CsvRowIteratorHandler(file, this.getCsvEncoding(), this.getCsvSkipHeaderRowsSize(), this.getRowValueConverter());
                }
                if (workbookFileType.isXml()) {
                    return new XmlRowIteratorHandler(file, this.getRowValueConverter());
                }
                return new JsonRowIteratorHandler(file, this.getJsonConverter(), this.getRowValueConverter());
            }
            return new ExcelRowIteratorHandler(file, this.getRowValueConverter());
        }).collect(Collectors.toList());
        if (!handlers.isEmpty()) {
            table.setRowIteratorHandler((RowIteratorHandler)new CombinedRowIteratorHandler(handlers));
        }
    }

    private RowValueConverter getRowValueConverter() {
        SqlConverter sqlConverter = this.getSqlConverter();
        ParametersContext context = new ParametersContext();
        context.putAll(this.getContext());
        return (RowValueConverter & Serializable)(r, c, v) -> {
            Object val;
            try {
                val = sqlConverter.getExpressionConverter().convert(v, (Object)context);
            }
            catch (IOException e) {
                throw new InvalidValueException(r, c, v, (Throwable)e);
            }
            return val;
        };
    }

    public boolean isUseTableNameDirectory() {
        return this.useTableNameDirectory;
    }

    public void setUseTableNameDirectory(boolean useTableNameDirectory) {
        this.useTableNameDirectory = useTableNameDirectory;
    }

    public File getDirectory() {
        return this.directory;
    }

    public void setDirectory(File directory) {
        this.directory = directory;
    }

    public boolean isUseSchemaNameDirectory() {
        return this.useSchemaNameDirectory;
    }

    public void setUseSchemaNameDirectory(boolean useSchemaNameDirectory) {
        this.useSchemaNameDirectory = useSchemaNameDirectory;
    }

    public File getFileDirectory() {
        return this.fileDirectory;
    }

    public void setFileDirectory(File fileDirectory) {
        this.fileDirectory = fileDirectory;
    }

    public Predicate<File> getFileFilter() {
        return this.fileFilter;
    }

    public void setFileFilter(Predicate<File> fileFilter) {
        this.fileFilter = fileFilter;
    }

    public String getPlaceholderPrefix() {
        return this.placeholderPrefix;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public String getPlaceholderSuffix() {
        return this.placeholderSuffix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    public boolean isPlaceholders() {
        return this.placeholders;
    }

    public void setPlaceholders(boolean placeholders) {
        this.placeholders = placeholders;
    }

    public JsonConverter getJsonConverter() {
        return this.jsonConverter;
    }

    public void setJsonConverter(JsonConverter jsonConverter) {
        this.jsonConverter = jsonConverter;
    }

    public String getCsvEncoding() {
        return this.csvEncoding;
    }

    public void setCsvEncoding(String csvEncoding) {
        this.csvEncoding = csvEncoding;
    }

    public int getCsvSkipHeaderRowsSize() {
        return this.csvSkipHeaderRowsSize;
    }

    public void setCsvSkipHeaderRowsSize(int csvSkipHeaderRowsSize) {
        this.csvSkipHeaderRowsSize = csvSkipHeaderRowsSize;
    }

    public Map<String, Object> getContext() {
        return this.context;
    }

    public void setContext(Map<String, Object> context) {
        this.context = context;
    }

    private JsonConverter createJsonConverter() {
        JsonConverter jsonConverter = new JsonConverter();
        jsonConverter.setIndentOutput(true);
        return jsonConverter;
    }

    public static class TableFilesPair {
        private final Table table;
        private final List<File> files;

        TableFilesPair(Table table, List<File> files) {
            this.table = table;
            this.files = files;
        }

        public Table getTable() {
            return this.table;
        }

        public List<File> getFiles() {
            return this.files;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("[");
            builder.append(this.table.getName());
            builder.append(", ");
            builder.append("files=");
            builder.append(this.files);
            builder.append("]");
            return builder.toString();
        }
    }

    static class TableFilePair {
        private final Table table;
        private final Synonym synonym;
        private File file;
        private final String name;

        TableFilePair(Table table) {
            this.table = table;
            this.synonym = null;
            this.name = table.getName();
        }

        TableFilePair(Synonym synonym) {
            this.synonym = synonym;
            this.table = synonym.rootSynonym().getTable();
            this.name = synonym.getName();
        }

        public String getName() {
            return this.name;
        }

        public Synonym getSynonym() {
            return this.synonym;
        }

        public Table getTable() {
            return this.table;
        }

        public void setFile(File file) {
            this.file = file;
        }

        public File getFile() {
            return this.file;
        }
    }
}

