/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.postgres.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.ExcludeConstraintReader;
import com.sqlapp.data.db.metadata.OperatorReader;
import com.sqlapp.data.db.metadata.SchemaReader;
import com.sqlapp.data.db.metadata.TableReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Deferrability;
import com.sqlapp.data.schemas.ExcludeConstraint;
import com.sqlapp.data.schemas.Operator;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

public class Postgres90ExcludeConstraintReader
extends ExcludeConstraintReader {
    public Postgres90ExcludeConstraintReader(Dialect dialect) {
        super(dialect);
    }

    protected List<ExcludeConstraint> doGetAll(final Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        final Map operatorMap = CommonUtils.map();
        final TripleKeyMap operatorIdMap = CommonUtils.tripleKeyMap();
        TableReader tableReader = (TableReader)this.getParent();
        SchemaReader schemaReader = (SchemaReader)tableReader.getParent();
        final OperatorReader operatorReader = schemaReader.getOperatorReader();
        operatorReader.setCatalogName(null);
        operatorReader.setSchemaName(null);
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String[] oidArray;
                String constraint_name;
                String table_name;
                String schema_name = this.getString(rs, "constraint_schema");
                ExcludeConstraint c = (ExcludeConstraint)map.get((Object)schema_name, (Object)(table_name = this.getString(rs, "table_name")), (Object)(constraint_name = this.getString(rs, "constraint_name")));
                if (c == null) {
                    c = new ExcludeConstraint(constraint_name);
                    c.setSchemaName(schema_name);
                    c.setTableName(table_name);
                    c.setDeferrability(Deferrability.getDeferrability((boolean)rs.getBoolean("is_deferrable"), (boolean)rs.getBoolean("initially_deferred")));
                    result.add(c);
                    String oids = CommonUtils.unwrap((String)rs.getString("conexclop"), (String)"{", (String)"}");
                    oidArray = CommonUtils.split((String)oids, (String)"[, ]");
                    operatorIdMap.put((Object)schema_name, (Object)table_name, (Object)constraint_name, (Object)oidArray);
                    for (String oid : oidArray) {
                        Operator operator = (Operator)operatorMap.get(oid);
                        if (operator != null) continue;
                        ParametersContext opContext = new ParametersContext();
                        opContext.put("id", (Object)Integer.valueOf(oid));
                        List list = operatorReader.getAll(connection, opContext);
                        operator = (Operator)CommonUtils.first((List)list);
                        operatorMap.put(oid, operator);
                    }
                    map.put((Object)schema_name, (Object)table_name, (Object)constraint_name, (Object)c);
                }
                int attnum = rs.getInt("attnum");
                oidArray = (String[])operatorIdMap.get((Object)schema_name, (Object)table_name, (Object)constraint_name);
                Operator operator = (Operator)operatorMap.get(oidArray[attnum - 1]);
                Column column = new Column(this.getString(rs, "column_name"));
                column.setTableName(table_name);
                c.getColumns().add(column);
                c.getColumns().get(column.getName()).setWith(operator.getName());
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("excludeConstraints.sql");
    }
}

