/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.IndexReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.data.schemas.Index;
import com.sqlapp.data.schemas.IndexType;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.data.schemas.properties.StatisticsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import com.sqlapp.util.TripleKeyMap;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005FullTextIndexReader
extends IndexReader {
    protected static final String FULL_TEXT_CATALOG_NAME = "full_text_catalog_name";

    public SqlServer2005FullTextIndexReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Index> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final TripleKeyMap map = CommonUtils.tripleKeyMap();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                String name;
                String schema_name;
                String catalog_name = this.getString(rs, "catalog_name");
                Index index = (Index)map.get((Object)catalog_name, (Object)(schema_name = this.getString(rs, "schema_name")), (Object)(name = this.getString(rs, "index_name")));
                if (index == null) {
                    index = SqlServer2005FullTextIndexReader.this.createIndex(rs);
                    map.put((Object)catalog_name, (Object)schema_name, (Object)name, (Object)index);
                }
                String columnName = this.getString(rs, "column_name");
                index.getColumns().add(new Column(columnName));
            }
        });
        return map.toList();
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("fullTextIndexes2005.sql");
    }

    protected Index createIndex(ExResultSet rs) throws SQLException {
        Index index = new Index(this.getString((ResultSet)rs, "index_name"));
        index.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        index.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        index.setTableName(this.getString((ResultSet)rs, "table_name"));
        index.setIndexType(IndexType.FullText);
        index.setEnable(rs.getBoolean("is_enabled"));
        this.setSpecifics(rs, FULL_TEXT_CATALOG_NAME, (SpecificsProperty)index);
        this.setSpecifics(rs, "language_name", (SpecificsProperty)index);
        this.setSpecifics(rs, "unique_index_name", (SpecificsProperty)index);
        this.setSpecifics(rs, "change_tracking", (SpecificsProperty)index);
        this.setStatistics(rs, "crawl_start_date", (StatisticsProperty)index);
        this.setStatistics(rs, "crawl_end_date", (StatisticsProperty)index);
        this.setStatistics(rs, "has_crawl_completed", (StatisticsProperty)index);
        return index;
    }
}

