/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2005FunctionArgumentReader;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.FunctionReader;
import com.sqlapp.data.db.metadata.RoutineArgumentReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.Function;
import com.sqlapp.data.schemas.FunctionReturning;
import com.sqlapp.data.schemas.FunctionType;
import com.sqlapp.data.schemas.OnNullCall;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.properties.DataTypeLengthProperties;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005FunctionReader
extends FunctionReader {
    protected SqlServer2005FunctionReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Function> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Function obj = SqlServer2005FunctionReader.this.createFunction(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("functions2005.sql");
    }

    protected Function createFunction(ExResultSet rs) throws SQLException {
        Function obj = new Function(this.getString((ResultSet)rs, "function_name"));
        obj.setDialect(this.getDialect());
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setClassNamePrefix(this.getString((ResultSet)rs, "assembly_name"));
        obj.setClassName(this.getString((ResultSet)rs, "assembly_class"));
        obj.setMethodName(this.getString((ResultSet)rs, "assembly_method"));
        String type = rs.getString("type");
        if ("AF".equalsIgnoreCase(type)) {
            obj.setFunctionType(FunctionType.Aggregate);
        } else if ("FN".equalsIgnoreCase(type) || "FS".equalsIgnoreCase(type)) {
            obj.setFunctionType(FunctionType.Scalar);
        } else if ("FT".equalsIgnoreCase(type) || "IF".equalsIgnoreCase(type) || "TF".equalsIgnoreCase(type)) {
            obj.setFunctionType(FunctionType.Table);
        }
        String definition = this.getString((ResultSet)rs, "definition");
        if (this.getReaderOptions().isReadDefinition()) {
            obj.setDefinition(definition);
        } else if (this.getReaderOptions().isReadStatement()) {
            obj.setStatement(SqlServerUtils.getFunctionStatement(definition, type));
        }
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        obj.setSqlSecurity(this.getString((ResultSet)rs, "sql_security"));
        obj.setExecuteAs(this.getString((ResultSet)rs, "execute_as"));
        Boolean nullOnNullInput = this.getBoolean((ResultSet)rs, "null_on_null_input");
        if (nullOnNullInput != null && nullOnNullInput.booleanValue()) {
            obj.setOnNullCall(OnNullCall.ReturnsNullOnNullInput);
        } else {
            obj.setOnNullCall(OnNullCall.CalledOnNullInput);
        }
        this.setSpecifics(rs, "assembly_id", (SpecificsProperty)obj);
        FunctionReturning ret = obj.getReturning();
        ret.setName(SqlServerUtils.getFunctionReturnName(definition));
        if ("FT".equalsIgnoreCase(type) || "TF".equalsIgnoreCase(type)) {
            String tableDef = SqlServerUtils.getFunctionReturnTable(definition);
            ret.setDefinition(tableDef);
            obj.setFunctionType(FunctionType.Table);
        } else if ("IF".equalsIgnoreCase(type)) {
            obj.setFunctionType(FunctionType.Table);
        } else {
            String productDataType = this.getString((ResultSet)rs, "NAME");
            Long max_length = this.getLong((ResultSet)rs, "max_length");
            Long precision = this.getLong((ResultSet)rs, "precision");
            Integer scale = this.getInteger((ResultSet)rs, "scale");
            this.getDialect().setDbType(productDataType, CommonUtils.notZero((Long[])new Long[]{max_length, precision}), scale, (DataTypeLengthProperties)ret);
        }
        return obj;
    }

    protected RoutineArgumentReader<?> newRoutineArgumentReader() {
        return new SqlServer2005FunctionArgumentReader(this.getDialect());
    }
}

