/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServerUtils;
import com.sqlapp.data.db.metadata.TriggerReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Trigger;
import com.sqlapp.data.schemas.properties.SpecificsProperty;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;

public class SqlServer2005TriggerReader
extends TriggerReader {
    protected SqlServer2005TriggerReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Trigger> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Trigger trigger = SqlServer2005TriggerReader.this.createTrigger(rs);
                result.add(trigger);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("triggers2005.sql");
    }

    protected Trigger createTrigger(ExResultSet rs) throws SQLException {
        String trigger_name = this.getString((ResultSet)rs, "trigger_name");
        String definition = this.getString((ResultSet)rs, "definition");
        String parentName = this.getString((ResultSet)rs, "parent_name");
        String type = CommonUtils.trim((String)rs.getString("type"));
        String parent_class_desc = this.getString((ResultSet)rs, "parent_class_desc");
        boolean fireringTime = rs.getBoolean("is_instead_of_trigger");
        Trigger trigger = new Trigger(trigger_name);
        trigger.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        trigger.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        if ("TR".equals(type)) {
            // empty if block
        }
        if ("TA".equals(type)) {
            // empty if block
        }
        if (fireringTime) {
            trigger.setActionTiming("INSTEAD OF");
        } else {
            trigger.setActionTiming("AFTER");
        }
        List<String> events = this.getEventManipulation(rs);
        trigger.getEventManipulation().addAll(events);
        if ("OBJECT_OR_COLUMN".equalsIgnoreCase(parent_class_desc)) {
            trigger.setTableName(parentName);
            trigger.setActionOrientation("ROW");
        } else if ("DATABASE".equalsIgnoreCase(parent_class_desc)) {
            trigger.setActionOrientation("STATEMENT");
        }
        trigger.setClassName(this.getString((ResultSet)rs, "assembly_class"));
        trigger.setMethodName(this.getString((ResultSet)rs, "assembly_method"));
        trigger.setEnable(!rs.getBoolean("is_disabled"));
        trigger.setCreatedAt(rs.getTimestamp("create_date"));
        trigger.setLastAlteredAt(rs.getTimestamp("modify_date"));
        trigger.setStatement(SqlServerUtils.getTriggerStatement(definition));
        this.setSpecifics((ResultSet)rs, "is_not_for_replication", (SpecificsProperty)trigger);
        return trigger;
    }

    private List<String> getEventManipulation(ExResultSet rs) throws SQLException {
        Event event;
        List events = CommonUtils.list((int)4);
        if (rs.getBoolean("is_insert")) {
            event = new Event("INSERT");
            if (rs.getBoolean("insert_is_first")) {
                event.setOrder(0);
            }
            if (rs.getBoolean("insert_is_last")) {
                event.setOrder(Integer.MAX_VALUE);
            }
            events.add(event);
        }
        if (rs.getBoolean("is_update")) {
            event = new Event("UPDATE");
            if (rs.getBoolean("update_is_first")) {
                event.setOrder(0);
            }
            if (rs.getBoolean("update_is_last")) {
                event.setOrder(Integer.MAX_VALUE);
            }
            events.add(event);
        }
        if (rs.getBoolean("is_delete")) {
            event = new Event("DELETE");
            if (rs.getBoolean("delete_is_first")) {
                event.setOrder(0);
            }
            if (rs.getBoolean("delete_is_last")) {
                event.setOrder(Integer.MAX_VALUE);
            }
            events.add(event);
        }
        Collections.sort(events);
        List ret = CommonUtils.list((int)events.size());
        for (int i = 0; i < events.size(); ++i) {
            ret.add(((Event)events.get(i)).getName());
        }
        return ret;
    }

    static class Event
    implements Comparable<Event> {
        private final String name;
        private int order = 0x3FFFFFFF;

        Event(String name) {
            this.name = name;
        }

        protected int getOrder() {
            return this.order;
        }

        protected void setOrder(int order) {
            this.order = order;
        }

        protected String getName() {
            return this.name;
        }

        @Override
        public int compareTo(Event o) {
            if (this.getOrder() > o.getOrder()) {
                return 1;
            }
            if (this.getOrder() == o.getOrder()) {
                return 0;
            }
            return -1;
        }
    }
}

