/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect;

import com.sqlapp.data.db.datatype.BlobType;
import com.sqlapp.data.db.datatype.DataType;
import com.sqlapp.data.db.datatype.DateTimeType;
import com.sqlapp.data.db.datatype.DecimalType;
import com.sqlapp.data.db.datatype.LongNVarcharType;
import com.sqlapp.data.db.datatype.LongVarcharType;
import com.sqlapp.data.db.datatype.SmallDateTimeType;
import com.sqlapp.data.db.datatype.UUIDType;
import com.sqlapp.data.db.dialect.DefaultCase;
import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.dialect.sqlserver.metadata.SqlServer2000CatalogReader;
import com.sqlapp.data.db.dialect.sqlserver.sql.SqlServerSqlFactoryRegistry;
import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerSqlBuilder;
import com.sqlapp.data.db.dialect.sqlserver.util.SqlServerSqlSplitter;
import com.sqlapp.data.db.metadata.CatalogReader;
import com.sqlapp.data.db.sql.SqlFactoryRegistry;
import com.sqlapp.data.db.sql.SqlOperation;
import com.sqlapp.data.schemas.CascadeRule;
import com.sqlapp.data.schemas.Column;
import com.sqlapp.util.CommonUtils;
import java.util.function.Supplier;

public class SqlServer2000
extends Dialect {
    private static final long serialVersionUID = 3840025482658828284L;

    protected SqlServer2000(Supplier<Dialect> nextVersionDialectSupplier) {
        super(nextVersionDialectSupplier);
    }

    protected void registerDataType() {
        this.getDbDataTypes().addChar(8000L);
        this.getDbDataTypes().addVarchar(8000L);
        ((LongVarcharType)((LongVarcharType)((LongVarcharType)this.getDbDataTypes().addLongVarchar("TEXT", CommonUtils.LEN_2GB - 1L).setCreateFormat("TEXT")).setFormats(new String[]{"TEXT"})).setDefaultLength(Long.valueOf(CommonUtils.LEN_2GB - 1L))).setFixedLength(false);
        this.getDbDataTypes().addNChar(4000L);
        this.getDbDataTypes().addNVarchar(4000L);
        ((LongNVarcharType)((LongNVarcharType)((LongNVarcharType)((LongNVarcharType)this.getDbDataTypes().addLongNVarchar("NTEXT", (long)(CommonUtils.LEN_1GB - 1)).setCreateFormat("NTEXT")).setFormats(new String[]{"NTEXT"})).addFormats(new String[]{"NATIONAL\\s+TEXT"})).setDefaultLength((Number)(CommonUtils.LEN_1GB - 1))).setFixedLength(false);
        this.getDbDataTypes().addBinary(8000L).setLiteral("0x", "");
        this.getDbDataTypes().addVarBinary(8000L).setLiteral("0x", "");
        ((BlobType)((BlobType)this.getDbDataTypes().addBlob("IMAGE", CommonUtils.LEN_2GB - 1L).setCreateFormat("IMAGE")).setFormats(new String[]{"IMAGE"})).setLiteral("0x", "");
        this.getDbDataTypes().addBit();
        this.getDbDataTypes().addTinyInt().addFormats(new String[]{"TINYINT IDENTITY"});
        this.getDbDataTypes().addSmallInt().addFormats(new String[]{"SMALLINT IDENTITY"});
        this.getDbDataTypes().addInt().addFormats(new String[]{"INT IDENTITY"});
        this.getDbDataTypes().addBigInt().addFormats(new String[]{"BIGINT IDENTITY"});
        ((UUIDType)this.getDbDataTypes().addUUID("UNIQUEIDENTIFIER").setLiteral("'", "'")).setDefaultValueLiteral("NEWID()");
        this.getDbDataTypes().addReal();
        this.getDbDataTypes().addFloat(53L);
        ((SmallDateTimeType)((SmallDateTimeType)this.getDbDataTypes().addSmallDateTime().setLiteral("{ts '", "'}")).setCreateFormat("SMALLDATETIME")).setDefaultValueLiteral(this.getCurrentDateTimeFunction());
        ((DateTimeType)((DateTimeType)this.getDbDataTypes().addDateTime().setLiteral("{ts '", "'}")).setCreateFormat("DATETIME")).setDefaultValueLiteral(this.getCurrentDateTimeFunction());
        this.getDbDataTypes().addSmallMoney("SMALLMONEY");
        this.getDbDataTypes().addMoney("MONEY");
        ((DecimalType)((DecimalType)this.getDbDataTypes().addDecimal().setMaxPrecision(Integer.valueOf(38)).setDefaultPrecision(Integer.valueOf(19))).setDefaultScale(Integer.valueOf(5))).addPrecisionScaleFormat("DEC");
        ((DecimalType)this.getDbDataTypes().addNumeric().setMaxPrecision(Integer.valueOf(38)).setDefaultPrecision(Integer.valueOf(19))).setDefaultScale(Integer.valueOf(5));
        this.getDbDataTypes().addRowVersion("TIMESTAMP").setLiteral("0x", "");
        this.getDbDataTypes().addSqlIdentifierType("SYSNAME");
        this.getDbDataTypes().addAnyData("VARIANT");
        this.getDbDataTypes().registerRecommend(DataType.CHAR, DataType.NVARCHAR);
        this.getDbDataTypes().registerRecommend(DataType.NCHAR, DataType.NVARCHAR);
        this.getDbDataTypes().registerRecommend(DataType.VARCHAR, DataType.NVARCHAR);
        this.getDbDataTypes().registerRecommend(DataType.SMALLDATETIME, DataType.DATETIME);
    }

    public String getProductName() {
        return "Microsoft SQL Server";
    }

    public String getSimpleName() {
        return "sqlserver";
    }

    public boolean supportsWith() {
        return false;
    }

    public boolean supportsTop() {
        return true;
    }

    public String getIdentitySelectString() {
        return "select SCOPE_IDENTITY()";
    }

    public boolean supportsIdentity() {
        return true;
    }

    public String getIdentityColumnString() {
        return "IDENTITY NOT NULL";
    }

    public boolean supportsCatalog() {
        return true;
    }

    public boolean supportsSchema() {
        return false;
    }

    public boolean recommendsNTypeChar() {
        return true;
    }

    public char getCloseQuote() {
        return ']';
    }

    public char getOpenQuote() {
        return '[';
    }

    public DefaultCase getDefaultCase() {
        return DefaultCase.NonConvert;
    }

    public String getCurrentDateFunction() {
        return "CAST(CONVERT(VARCHAR(10),CURRENT_TIMESTAMP,121) AS DATETIME)";
    }

    public String getCurrentDateTimeFunction() {
        return "CURRENT_TIMESTAMP";
    }

    public String getCurrentTimestampFunction() {
        return "CURRENT_TIMESTAMP";
    }

    public String getCurrentTimestampWithTimeZoneFunction() {
        return "CURRENT_TIMESTAMP";
    }

    public String defaultSchema() {
        return "dbo";
    }

    public boolean supportsCascadeDelete() {
        return true;
    }

    public boolean supportsDefaultValueFunction() {
        return true;
    }

    public boolean supportsDropCascade() {
        return true;
    }

    public boolean supportsFunctionOverload() {
        return false;
    }

    public boolean supportsProcedureOverload() {
        return false;
    }

    public boolean supportsRuleOnDelete(CascadeRule rule) {
        return rule == CascadeRule.None || rule == CascadeRule.SetNull || rule == CascadeRule.Cascade;
    }

    public boolean supportsCascadeUpdate() {
        return true;
    }

    public boolean supportsRuleOnUpdate(CascadeRule rule) {
        return rule == CascadeRule.None || rule == CascadeRule.SetNull || rule == CascadeRule.Cascade;
    }

    public boolean supportsIndexNameTableScope() {
        return true;
    }

    public boolean storesMixedCaseIdentifiers() {
        return true;
    }

    public boolean isOptimisticLockColumn(Column column) {
        if (column.getDataType().isBinary() && column.getName().equalsIgnoreCase("TIMESTAMP")) {
            return true;
        }
        return super.isOptimisticLockColumn(column);
    }

    public int hashCode() {
        return this.getProductName().hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public CatalogReader getCatalogReader() {
        return new SqlServer2000CatalogReader(this);
    }

    public String getObjectFullName(String catalogName, String schemaName, String objectName) {
        StringBuilder builder = new StringBuilder(CommonUtils.size((String)catalogName) + CommonUtils.size((String)schemaName) + CommonUtils.size((String)objectName) + 2);
        if (!CommonUtils.isEmpty((CharSequence)catalogName)) {
            builder.append(catalogName);
            builder.append('.');
            if (!CommonUtils.isEmpty((CharSequence)schemaName)) {
                builder.append(schemaName);
            }
            builder.append('.');
        } else if (!CommonUtils.isEmpty((CharSequence)schemaName)) {
            builder.append(schemaName);
            builder.append('.');
        }
        builder.append(objectName);
        return builder.toString();
    }

    public SqlFactoryRegistry createSqlFactoryRegistry() {
        return new SqlServerSqlFactoryRegistry(this);
    }

    public SqlServerSqlBuilder createSqlBuilder() {
        return new SqlServerSqlBuilder(this);
    }

    public SqlServerSqlSplitter createSqlSplitter() {
        return new SqlServerSqlSplitter(this);
    }

    protected String doQuote(String target) {
        StringBuilder builder = new StringBuilder(target.length() + 2);
        builder.append(this.getOpenQuote()).append(target.replace("]", "]]")).append(this.getCloseQuote());
        return builder.toString();
    }

    public void setChangeAndResetSqlDelimiter(SqlOperation operation) {
        if (!operation.getSqlText().contains(";")) {
            return;
        }
        operation.setTerminator("GO");
        operation.setEndStatementTerminator("GO");
    }

    public boolean isDdlRollbackable() {
        return true;
    }
}

