/*
 * Decompiled with CFR 0.152.
 */
package com.sqlapp.data.db.dialect.sqlserver.metadata;

import com.sqlapp.data.db.dialect.Dialect;
import com.sqlapp.data.db.metadata.SynonymReader;
import com.sqlapp.data.parameter.ParametersContext;
import com.sqlapp.data.schemas.ProductVersionInfo;
import com.sqlapp.data.schemas.Synonym;
import com.sqlapp.jdbc.ExResultSet;
import com.sqlapp.jdbc.sql.ResultSetNextHandler;
import com.sqlapp.jdbc.sql.node.SqlNode;
import com.sqlapp.util.CommonUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

public class SqlServer2005SynonymReader
extends SynonymReader {
    protected SqlServer2005SynonymReader(Dialect dialect) {
        super(dialect);
    }

    protected List<Synonym> doGetAll(Connection connection, ParametersContext context, ProductVersionInfo productVersionInfo) {
        SqlNode node = this.getSqlSqlNode(productVersionInfo);
        final List result = CommonUtils.list();
        this.execute(connection, node, context, new ResultSetNextHandler(){

            public void handleResultSetNext(ExResultSet rs) throws SQLException {
                Synonym obj = SqlServer2005SynonymReader.this.createSynonym(rs);
                result.add(obj);
            }
        });
        return result;
    }

    protected SqlNode getSqlSqlNode(ProductVersionInfo productVersionInfo) {
        return this.getSqlNodeCache().getString("synonyms2005.sql");
    }

    protected Synonym createSynonym(ExResultSet rs) throws SQLException {
        Synonym obj = new Synonym(this.getString((ResultSet)rs, "name"));
        obj.setCatalogName(this.getString((ResultSet)rs, "catalog_name"));
        obj.setSchemaName(this.getString((ResultSet)rs, "schema_name"));
        obj.setObjectName(this.getString((ResultSet)rs, "base_object_name"));
        obj.setCreatedAt(rs.getTimestamp("create_date"));
        obj.setLastAlteredAt(rs.getTimestamp("modify_date"));
        return obj;
    }
}

